/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.ui.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.identity.entitlement.ui.client.EntitlementPolicyAdminServiceClient;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class EntitlementPolicyUploadExecutor
extends AbstractFileUploadExecutor {
    private static final String[] ALLOWED_FILE_EXTENSIONS = new String[]{".xml"};
    private String errorRedirectionPage;

    public boolean execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws CarbonException, IOException {
        String webContext = (String)httpServletRequest.getAttribute("WebContext");
        String serverURL = (String)httpServletRequest.getAttribute("ServerURL");
        String cookie = (String)httpServletRequest.getAttribute("wso2carbon.admin.service.cookie");
        this.errorRedirectionPage = this.getContextRoot(httpServletRequest) + "/" + webContext + "/entitlement/import-policy.jsp";
        Map fileItemsMap = this.getFileItemsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            String msg = "File uploading failed. No files are specified";
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)this.errorRedirectionPage);
            return false;
        }
        EntitlementPolicyAdminServiceClient client = new EntitlementPolicyAdminServiceClient(cookie, serverURL, this.configurationContext);
        List fileItems = (List)fileItemsMap.get("policyFromFileSystem");
        try {
            for (FileItemData fileItem : fileItems) {
                String temp;
                String filename = this.getFileName(fileItem.getFileItem().getName());
                this.checkServiceFileExtensionValidity(filename, ALLOWED_FILE_EXTENSIONS);
                if (!filename.endsWith(".xml")) {
                    throw new CarbonException("File with extension " + this.getFileName(fileItem.getFileItem().getName()) + " is not supported!");
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(fileItem.getDataHandler().getInputStream()));
                String policyContent = "";
                while ((temp = br.readLine()) != null) {
                    policyContent = policyContent + temp;
                }
                if (policyContent == "") continue;
                client.uploadPolicy(policyContent);
            }
            httpServletResponse.setContentType("text/html; charset=utf-8");
            String msg = "Policy have been uploaded successfully.";
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"info", (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)(this.getContextRoot(httpServletRequest) + "/" + webContext + "/entitlement/index.jsp"));
            return true;
        }
        catch (Exception e) {
            String msg = "Policy uploading failed. " + e.getMessage();
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)this.errorRedirectionPage);
            return false;
        }
    }

    protected String getErrorRedirectionPage() {
        return this.errorRedirectionPage;
    }
}

