/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.AbstractPolicy;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.policy.PolicyMetaDataBuilder;
import org.wso2.carbon.identity.entitlement.policy.PolicyReader;
import org.wso2.carbon.identity.entitlement.policy.PolicyStore;
import org.wso2.carbon.identity.entitlement.policy.PolicyTarget;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;

public class PolicyStoreReader {
    public static final String POLICY_SCHEMA_PROPERTY = "com.sun.xacml.PolicySchema";
    private static Log log = LogFactory.getLog(PolicyStoreReader.class);
    private PolicyStore store;

    public PolicyStoreReader(PolicyStore store) {
        this.store = store;
    }

    public synchronized AbstractPolicy readPolicy(String policyId) throws IdentityException {
        Resource resource = null;
        resource = this.store.getPolicy(policyId);
        return this.readPolicy(resource);
    }

    public synchronized AbstractPolicy[] readPolicies() throws IdentityException {
        Resource[] resources = null;
        AbstractPolicy[] policies = null;
        resources = this.store.getActivePolicies();
        if (resources == null) {
            return new AbstractPolicy[0];
        }
        policies = new AbstractPolicy[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            if (resources[i] == null) continue;
            policies[i] = this.readPolicy(resources[i]);
        }
        return policies;
    }

    public synchronized PolicyTarget[] readTargets() throws IdentityException {
        Resource[] resources = null;
        PolicyTarget[] targets = null;
        resources = this.store.getActivePolicies();
        if (resources == null) {
            return new PolicyTarget[0];
        }
        targets = new PolicyTarget[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            if (resources[i] == null) continue;
            targets[i] = this.readTarget(resources[i]);
        }
        return targets;
    }

    private AbstractPolicy readPolicy(Resource resource) throws IdentityException {
        String policy = null;
        try {
            policy = new String((byte[])resource.getContent());
            return PolicyReader.getInstance(null, null).getPolicy(policy);
        }
        catch (RegistryException e) {
            log.error((Object)"Error while loading entitlement policy", (Throwable)e);
            throw new IdentityException("Error while loading entitlement policy", (Throwable)e);
        }
    }

    private PolicyTarget readTarget(Resource resource) throws IdentityException {
        String policy = null;
        try {
            policy = new String((byte[])resource.getContent());
            return PolicyReader.getInstance(null, null).getTarget(policy);
        }
        catch (RegistryException e) {
            log.error((Object)"Error while loading entitlement policy", (Throwable)e);
            throw new IdentityException("Error while loading entitlement policy", (Throwable)e);
        }
    }

    public PolicyDTO[] readAllPolicyDTOs() throws IdentityException {
        int i;
        Resource[] resources = null;
        PolicyDTO[] policies = null;
        resources = this.store.getAllPolicies();
        if (resources == null) {
            return new PolicyDTO[0];
        }
        policies = new PolicyDTO[resources.length];
        ArrayList<PolicyDTO> policyDTOList = new ArrayList<PolicyDTO>();
        int[] policyOrder = new int[resources.length];
        for (int i2 = 0; i2 < resources.length; ++i2) {
            PolicyDTO policyDTO = this.readPolicyDTO(resources[i2]);
            policyDTOList.add(policyDTO);
            policyOrder[i2] = policyDTO.getPolicyOrder();
        }
        int[] tempArray = new int[policyOrder.length];
        Arrays.sort(policyOrder);
        for (i = 0; i < tempArray.length; ++i) {
            int j = policyOrder.length - 1 - i;
            tempArray[j] = policyOrder[i];
        }
        policyOrder = tempArray;
        for (i = 0; i < policyOrder.length; ++i) {
            for (PolicyDTO policyDTO : policyDTOList) {
                if (policyOrder[i] != policyDTO.getPolicyOrder()) continue;
                policies[i] = policyDTO;
            }
        }
        return policies;
    }

    public PolicyDTO[] readAllLightPolicyDTOs() throws IdentityException {
        int i;
        String[] resources = null;
        PolicyDTO[] policies = null;
        resources = this.store.getAllPolicyIds();
        if (resources == null) {
            return new PolicyDTO[0];
        }
        policies = new PolicyDTO[resources.length];
        ArrayList<PolicyDTO> policyDTOList = new ArrayList<PolicyDTO>();
        int[] policyOrder = new int[resources.length];
        for (int i2 = 0; i2 < resources.length; ++i2) {
            PolicyDTO policyDTO = this.readLightPolicyDTO(resources[i2]);
            policyDTOList.add(policyDTO);
            policyOrder[i2] = policyDTO.getPolicyOrder();
        }
        int[] tempArray = new int[policyOrder.length];
        Arrays.sort(policyOrder);
        for (i = 0; i < tempArray.length; ++i) {
            int j = policyOrder.length - 1 - i;
            tempArray[j] = policyOrder[i];
        }
        policyOrder = tempArray;
        for (i = 0; i < policyOrder.length; ++i) {
            for (PolicyDTO policyDTO : policyDTOList) {
                if (policyOrder[i] != policyDTO.getPolicyOrder()) continue;
                policies[i] = policyDTO;
            }
        }
        return policies;
    }

    public PolicyDTO readPolicyDTO(String policyId) throws IdentityException {
        Resource resource = null;
        PolicyDTO dto = null;
        boolean policyEditable = false;
        boolean policyCanDelete = false;
        try {
            String policySetReferences;
            String policyOrder;
            resource = this.store.getPolicy(policyId);
            if (resource == null) {
                return null;
            }
            if (this.store.getRegistry() != null) {
                String userName = ((UserRegistry)this.store.getRegistry()).getUserName();
                int tenantId = ((UserRegistry)this.store.getRegistry()).getTenantId();
                RealmService realmService = EntitlementServiceComponent.getRealmservice();
                if (realmService != null) {
                    policyEditable = realmService.getTenantUserRealm(tenantId).getAuthorizationManager().isUserAuthorized(userName, "/_system/governance" + resource.getPath(), "write");
                    policyCanDelete = realmService.getTenantUserRealm(tenantId).getAuthorizationManager().isUserAuthorized(userName, "/_system/governance" + resource.getPath(), "delete");
                }
            }
            dto = new PolicyDTO();
            dto.setPolicyId(policyId);
            dto.setPolicy(new String((byte[])resource.getContent()));
            dto.setPolicyEditable(policyEditable);
            dto.setPolicyCanDelete(policyCanDelete);
            if ("true".equals(resource.getProperty("isActive"))) {
                dto.setActive(true);
            }
            if ((policyOrder = resource.getProperty("policyOrder")) != null) {
                dto.setPolicyOrder(Integer.parseInt(policyOrder));
            } else {
                dto.setPolicyOrder(0);
            }
            dto.setPolicyType(resource.getProperty("policyType"));
            String policyReferences = resource.getProperty("policyIdReferences");
            if (policyReferences != null && policyReferences.trim().length() > 0) {
                dto.setPolicyIdReferences(policyReferences.split(","));
            }
            if ((policySetReferences = resource.getProperty("policySetIdReferences")) != null && policySetReferences.trim().length() > 0) {
                dto.setPolicySetIdReferences(policySetReferences.split(","));
            }
            dto.setPolicyEditor(resource.getProperty("policyEditor"));
            String basicPolicyEditorMetaDataAmount = resource.getProperty("NoOfBasicPolicyEditorMetaData");
            if (basicPolicyEditorMetaDataAmount != null) {
                int amount = Integer.parseInt(basicPolicyEditorMetaDataAmount);
                String[] basicPolicyEditorMetaData = new String[amount];
                for (int i = 0; i < amount; ++i) {
                    basicPolicyEditorMetaData[i] = resource.getProperty("basicPolicyEditorMetaData" + i);
                }
                dto.setBasicPolicyEditorMetaData(basicPolicyEditorMetaData);
            }
            PolicyMetaDataBuilder policyMetaDataBuilder = new PolicyMetaDataBuilder();
            dto.setPolicyMetaData(policyMetaDataBuilder.getPolicyMetaDataFromRegistryProperties(resource.getProperties()));
            return dto;
        }
        catch (RegistryException e) {
            log.error((Object)"Error while loading entitlement policy", (Throwable)e);
            throw new IdentityException("Error while loading entitlement policy", (Throwable)e);
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while loading entitlement policy", (Throwable)e);
            throw new IdentityException("Error while loading entitlement policy", (Throwable)e);
        }
    }

    public PolicyDTO readLightPolicyDTO(String policyId) throws IdentityException {
        Resource resource = null;
        PolicyDTO dto = null;
        boolean policyEditable = false;
        boolean policyCanDelete = false;
        try {
            String policySetReferences;
            String policyOrder;
            resource = this.store.getPolicy(policyId);
            if (resource == null) {
                return null;
            }
            if (this.store.getRegistry() != null) {
                String userName = ((UserRegistry)this.store.getRegistry()).getUserName();
                int tenantId = ((UserRegistry)this.store.getRegistry()).getTenantId();
                RealmService realmService = EntitlementServiceComponent.getRealmservice();
                if (realmService != null) {
                    policyEditable = realmService.getTenantUserRealm(tenantId).getAuthorizationManager().isUserAuthorized(userName, "/_system/governance" + resource.getPath(), "write");
                    policyCanDelete = realmService.getTenantUserRealm(tenantId).getAuthorizationManager().isUserAuthorized(userName, "/_system/governance" + resource.getPath(), "delete");
                }
            }
            dto = new PolicyDTO();
            dto.setPolicyId(policyId);
            dto.setPolicyEditable(policyEditable);
            dto.setPolicyCanDelete(policyCanDelete);
            if ("true".equals(resource.getProperty("isActive"))) {
                dto.setActive(true);
            }
            if ((policyOrder = resource.getProperty("policyOrder")) != null) {
                dto.setPolicyOrder(Integer.parseInt(policyOrder));
            } else {
                dto.setPolicyOrder(0);
            }
            dto.setPolicyType(resource.getProperty("policyType"));
            String policyReferences = resource.getProperty("policyIdReferences");
            if (policyReferences != null && policyReferences.trim().length() > 0) {
                dto.setPolicyIdReferences(policyReferences.split(","));
            }
            if ((policySetReferences = resource.getProperty("policySetIdReferences")) != null && policySetReferences.trim().length() > 0) {
                dto.setPolicySetIdReferences(policySetReferences.split(","));
            }
            dto.setPolicyEditor(resource.getProperty("policyEditor"));
            return dto;
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while loading entitlement policy", (Throwable)e);
            throw new IdentityException("Error while loading entitlement policy", (Throwable)e);
        }
    }

    public PolicyDTO readMetaDataPolicyDTO(String policyId) throws IdentityException {
        Resource resource = null;
        PolicyDTO dto = null;
        boolean policyEditable = false;
        boolean policyCanDelete = false;
        try {
            String policySetReferences;
            String policyOrder;
            resource = this.store.getPolicy(policyId);
            if (resource == null) {
                return null;
            }
            if (this.store.getRegistry() != null) {
                String userName = ((UserRegistry)this.store.getRegistry()).getUserName();
                int tenantId = ((UserRegistry)this.store.getRegistry()).getTenantId();
                RealmService realmService = EntitlementServiceComponent.getRealmservice();
                if (realmService != null) {
                    policyEditable = realmService.getTenantUserRealm(tenantId).getAuthorizationManager().isUserAuthorized(userName, "/_system/governance" + resource.getPath(), "write");
                    policyCanDelete = realmService.getTenantUserRealm(tenantId).getAuthorizationManager().isUserAuthorized(userName, "/_system/governance" + resource.getPath(), "delete");
                }
            }
            dto = new PolicyDTO();
            dto.setPolicyId(policyId);
            dto.setPolicyEditable(policyEditable);
            dto.setPolicyCanDelete(policyCanDelete);
            if ("true".equals(resource.getProperty("isActive"))) {
                dto.setActive(true);
            }
            if ((policyOrder = resource.getProperty("policyOrder")) != null) {
                dto.setPolicyOrder(Integer.parseInt(policyOrder));
            } else {
                dto.setPolicyOrder(0);
            }
            dto.setPolicyType(resource.getProperty("policyType"));
            String policyReferences = resource.getProperty("policyIdReferences");
            if (policyReferences != null && policyReferences.trim().length() > 0) {
                dto.setPolicyIdReferences(policyReferences.split(","));
            }
            if ((policySetReferences = resource.getProperty("policySetIdReferences")) != null && policySetReferences.trim().length() > 0) {
                dto.setPolicySetIdReferences(policySetReferences.split(","));
            }
            dto.setPolicyEditor(resource.getProperty("policyEditor"));
            String basicPolicyEditorMetaDataAmount = resource.getProperty("NoOfBasicPolicyEditorMetaData");
            if (basicPolicyEditorMetaDataAmount != null) {
                int amount = Integer.parseInt(basicPolicyEditorMetaDataAmount);
                String[] basicPolicyEditorMetaData = new String[amount];
                for (int i = 0; i < amount; ++i) {
                    basicPolicyEditorMetaData[i] = resource.getProperty("basicPolicyEditorMetaData" + i);
                }
                dto.setBasicPolicyEditorMetaData(basicPolicyEditorMetaData);
            }
            PolicyMetaDataBuilder policyMetaDataBuilder = new PolicyMetaDataBuilder();
            dto.setPolicyMetaData(policyMetaDataBuilder.getPolicyMetaDataFromRegistryProperties(resource.getProperties()));
            return dto;
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while loading entitlement policy", (Throwable)e);
            throw new IdentityException("Error while loading entitlement policy", (Throwable)e);
        }
    }

    private PolicyDTO readPolicyDTO(Resource resource) throws IdentityException {
        String policy = null;
        AbstractPolicy absPolicy = null;
        PolicyDTO dto = null;
        boolean policyEditable = false;
        boolean policyCanDelete = false;
        try {
            String policySetReferences;
            String policyOrder;
            if (this.store.getRegistry() != null) {
                String userName = ((UserRegistry)this.store.getRegistry()).getUserName();
                int tenantId = ((UserRegistry)this.store.getRegistry()).getTenantId();
                RealmService realmService = EntitlementServiceComponent.getRealmservice();
                if (realmService != null) {
                    policyEditable = realmService.getTenantUserRealm(tenantId).getAuthorizationManager().isUserAuthorized(userName, "/_system/governance" + resource.getPath(), "write");
                    policyCanDelete = realmService.getTenantUserRealm(tenantId).getAuthorizationManager().isUserAuthorized(userName, "/_system/governance" + resource.getPath(), "delete");
                }
            }
            policy = new String((byte[])resource.getContent());
            absPolicy = PolicyReader.getInstance(null, null).getPolicy(policy);
            dto = new PolicyDTO();
            dto.setPolicyId(absPolicy.getId().toASCIIString());
            dto.setPolicyEditable(policyEditable);
            dto.setPolicyCanDelete(policyCanDelete);
            if ("true".equals(resource.getProperty("isActive"))) {
                dto.setActive(true);
            }
            if ((policyOrder = resource.getProperty("policyOrder")) != null) {
                dto.setPolicyOrder(Integer.parseInt(policyOrder));
            } else {
                dto.setPolicyOrder(0);
            }
            dto.setPolicyType(resource.getProperty("policyType"));
            String policyReferences = resource.getProperty("policyIdReferences");
            if (policyReferences != null && policyReferences.trim().length() > 0) {
                dto.setPolicyIdReferences(policyReferences.split(","));
            }
            if ((policySetReferences = resource.getProperty("policySetIdReferences")) != null && policySetReferences.trim().length() > 0) {
                dto.setPolicySetIdReferences(policySetReferences.split(","));
            }
            dto.setPolicyEditor(resource.getProperty("policyEditor"));
            String basicPolicyEditorMetaDataAmount = resource.getProperty("NoOfBasicPolicyEditorMetaData");
            if (basicPolicyEditorMetaDataAmount != null) {
                int amount = Integer.parseInt(basicPolicyEditorMetaDataAmount);
                String[] basicPolicyEditorMetaData = new String[amount];
                for (int i = 0; i < amount; ++i) {
                    basicPolicyEditorMetaData[i] = resource.getProperty("basicPolicyEditorMetaData" + i);
                }
                dto.setBasicPolicyEditorMetaData(basicPolicyEditorMetaData);
            }
            PolicyMetaDataBuilder policyMetaDataBuilder = new PolicyMetaDataBuilder();
            dto.setPolicyMetaData(policyMetaDataBuilder.getPolicyMetaDataFromRegistryProperties(resource.getProperties()));
            return dto;
        }
        catch (RegistryException e) {
            log.error((Object)"Error while loading entitlement policy", (Throwable)e);
            throw new IdentityException("Error while loading entitlement policy", (Throwable)e);
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while loading entitlement policy", (Throwable)e);
            throw new IdentityException("Error while loading entitlement policy", (Throwable)e);
        }
    }

    public String readPolicyCombiningAlgorithm() throws IdentityException {
        try {
            Collection policyCollection = this.store.getPolicyCollection();
            if (policyCollection != null) {
                return policyCollection.getProperty("globalPolicyCombiningAlgorithm");
            }
            return null;
        }
        catch (IdentityException e) {
            log.error((Object)"Error while reading policy combining algorithm", (Throwable)e);
            throw new IdentityException("Error while reading policy combining algorithm", (Throwable)e);
        }
    }
}

