/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.entitlement.dto.AttributeValueDTO;

public class PolicyMetaDataBuilder {
    public Properties getPolicyMetaDataFromPolicy(String policy) throws IdentityException {
        List<AttributeValueDTO> attributeValueDTOs = new ArrayList<AttributeValueDTO>();
        try {
            attributeValueDTOs = this.createPolicyMetaData(policy, attributeValueDTOs);
        }
        catch (IdentityException e) {
            throw new IdentityException("Can not create Policy MetaData for given policy");
        }
        int attributeElementNo = 0;
        Properties properties = new Properties();
        if (attributeValueDTOs != null) {
            for (AttributeValueDTO attributeValueDTO : attributeValueDTOs) {
                properties.setProperty("policyMetaData" + attributeElementNo, attributeValueDTO.getAttributeType() + "," + attributeValueDTO.getAttribute() + "," + attributeValueDTO.getAttributeId() + "," + attributeValueDTO.getAttributeDataType());
                ++attributeElementNo;
            }
        }
        return properties;
    }

    public AttributeValueDTO[] getPolicyMetaDataFromRegistryProperties(Properties properties) {
        ArrayList<AttributeValueDTO> attributeValueDTOs = new ArrayList<AttributeValueDTO>();
        if (properties != null && !properties.isEmpty()) {
            for (int attributeElementNo = 0; attributeElementNo < properties.size(); ++attributeElementNo) {
                String[] attributeData;
                ArrayList attributeList = (ArrayList)properties.get("policyMetaData" + attributeElementNo);
                if (attributeList == null || attributeList.get(0) == null || (attributeData = attributeList.get(0).toString().split(",")).length != 4) continue;
                AttributeValueDTO attributeValueDTO = new AttributeValueDTO();
                attributeValueDTO.setAttributeType(attributeData[0]);
                attributeValueDTO.setAttribute(attributeData[1]);
                attributeValueDTO.setAttributeId(attributeData[2]);
                attributeValueDTO.setAttributeDataType(attributeData[3]);
                attributeValueDTOs.add(attributeValueDTO);
            }
        } else {
            return null;
        }
        return attributeValueDTOs.toArray(new AttributeValueDTO[attributeValueDTOs.size()]);
    }

    public List<AttributeValueDTO> createPolicyMetaData(String policy, List<AttributeValueDTO> attributeValueDTOs) throws IdentityException {
        OMElement omElement;
        try {
            omElement = AXIOMUtil.stringToOM((String)policy);
        }
        catch (XMLStreamException e) {
            throw new IdentityException("Policy xml can not be converted to OMElement");
        }
        if (omElement != null) {
            Iterator iterator1 = omElement.getChildrenWithLocalName("Target");
            while (iterator1.hasNext()) {
                OMElement targetElement = (OMElement)iterator1.next();
                this.createMetaDataFromTargetElement(targetElement, attributeValueDTOs);
            }
            Iterator iterator2 = omElement.getChildrenWithLocalName("Rule");
            while (iterator2.hasNext()) {
                OMElement targetElement = (OMElement)iterator2.next();
                this.createMetaDataFromRuleElement(targetElement, attributeValueDTOs);
            }
            Iterator iterator3 = omElement.getChildrenWithLocalName("Policy");
            while (iterator3.hasNext()) {
                OMElement targetElement = (OMElement)iterator3.next();
                this.createPolicyMetaData(targetElement.toString(), attributeValueDTOs);
            }
        }
        return attributeValueDTOs;
    }

    public List<AttributeValueDTO> createMetaDataFromTargetElement(OMElement omElement, List<AttributeValueDTO> attributeValueDTOs) {
        if (omElement != null) {
            Iterator iterator1 = omElement.getChildrenWithLocalName("Resources");
            while (iterator1.hasNext()) {
                OMElement resourceElements = (OMElement)iterator1.next();
                Iterator iterator2 = resourceElements.getChildrenWithLocalName("Resource");
                while (iterator2.hasNext()) {
                    OMElement resourceElement = (OMElement)iterator2.next();
                    Iterator iterator3 = resourceElement.getChildrenWithLocalName("ResourceMatch");
                    while (iterator3.hasNext()) {
                        OMElement resourceMatch = (OMElement)iterator3.next();
                        List<AttributeValueDTO> attributeValueDTOList = this.createMetaDataFromMatchElement(resourceMatch, "Resource");
                        for (AttributeValueDTO attributeValueDTO : attributeValueDTOList) {
                            attributeValueDTOs.add(attributeValueDTO);
                        }
                    }
                }
            }
            Iterator iterator4 = omElement.getChildrenWithLocalName("Subjects");
            while (iterator4.hasNext()) {
                OMElement resourceElements = (OMElement)iterator4.next();
                Iterator iterator2 = resourceElements.getChildrenWithLocalName("Subject");
                while (iterator2.hasNext()) {
                    OMElement resourceElement = (OMElement)iterator2.next();
                    Iterator iterator3 = resourceElement.getChildrenWithLocalName("SubjectMatch");
                    while (iterator3.hasNext()) {
                        OMElement resourceMatch = (OMElement)iterator3.next();
                        List<AttributeValueDTO> attributeValueDTOList = this.createMetaDataFromMatchElement(resourceMatch, "Subject");
                        for (AttributeValueDTO attributeValueDTO : attributeValueDTOList) {
                            attributeValueDTOs.add(attributeValueDTO);
                        }
                    }
                }
            }
            Iterator iterator5 = omElement.getChildrenWithLocalName("Actions");
            while (iterator5.hasNext()) {
                OMElement resourceElements = (OMElement)iterator5.next();
                Iterator iterator2 = resourceElements.getChildrenWithLocalName("Action");
                while (iterator2.hasNext()) {
                    OMElement resourceElement = (OMElement)iterator2.next();
                    Iterator iterator3 = resourceElement.getChildrenWithLocalName("ActionMatch");
                    while (iterator3.hasNext()) {
                        OMElement resourceMatch = (OMElement)iterator3.next();
                        List<AttributeValueDTO> attributeValueDTOList = this.createMetaDataFromMatchElement(resourceMatch, "Action");
                        for (AttributeValueDTO attributeValueDTO : attributeValueDTOList) {
                            attributeValueDTOs.add(attributeValueDTO);
                        }
                    }
                }
            }
            Iterator iterator6 = omElement.getChildrenWithLocalName("Environments");
            while (iterator6.hasNext()) {
                OMElement resourceElements = (OMElement)iterator6.next();
                Iterator iterator2 = resourceElements.getChildrenWithLocalName("Environment");
                while (iterator2.hasNext()) {
                    OMElement resourceElement = (OMElement)iterator2.next();
                    Iterator iterator3 = resourceElement.getChildrenWithLocalName("EnvironmentMatch");
                    while (iterator3.hasNext()) {
                        OMElement resourceMatch = (OMElement)iterator3.next();
                        List<AttributeValueDTO> attributeValueDTOList = this.createMetaDataFromMatchElement(resourceMatch, "Environment");
                        for (AttributeValueDTO attributeValueDTO : attributeValueDTOList) {
                            attributeValueDTOs.add(attributeValueDTO);
                        }
                    }
                }
            }
        }
        return attributeValueDTOs;
    }

    public List<AttributeValueDTO> createMetaDataFromMatchElement(OMElement omElement, String subElementName) {
        ArrayList<AttributeValueDTO> attributeValueDTOs = new ArrayList<AttributeValueDTO>();
        String attributeId = null;
        String dataType = null;
        if (omElement != null) {
            Iterator iterator1 = omElement.getChildrenWithLocalName(subElementName + "AttributeDesignator");
            while (iterator1.hasNext()) {
                OMElement attributeDesignator = (OMElement)iterator1.next();
                if (attributeDesignator == null) continue;
                attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
                dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
            }
            Iterator iterator2 = omElement.getChildrenWithLocalName("AttributeSelector");
            while (iterator2.hasNext()) {
                OMElement attributeDesignator = (OMElement)iterator2.next();
                if (attributeDesignator == null) continue;
                attributeId = attributeDesignator.getAttributeValue(new QName("RequestContextPath"));
                dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
            }
            Iterator iterator3 = omElement.getChildrenWithLocalName("AttributeValue");
            while (iterator3.hasNext()) {
                OMElement attributeElement = (OMElement)iterator3.next();
                if (attributeElement == null) continue;
                AttributeValueDTO attributeValueDTO = new AttributeValueDTO();
                attributeValueDTO.setAttribute(attributeElement.getText());
                attributeValueDTO.setAttributeId(attributeId);
                attributeValueDTO.setAttributeDataType(dataType);
                attributeValueDTO.setAttributeType(subElementName);
                attributeValueDTOs.add(attributeValueDTO);
            }
        }
        return attributeValueDTOs;
    }

    public List<AttributeValueDTO> createMetaDataFromApplyElement(OMElement omElement, List<AttributeValueDTO> attributeValueDTOs) {
        if (omElement != null) {
            AttributeValueDTO attributeValueDTO;
            AttributeValueDTO attributeValueDTO2;
            List<String> attributeValues;
            AttributeValueDTO attributeValueDTO3;
            AttributeValueDTO attributeValueDTO4;
            Iterator iterator1 = omElement.getChildrenWithLocalName("ResourceAttributeDesignator");
            while (iterator1.hasNext()) {
                AttributeValueDTO attributeValueDTO5;
                OMElement attributeDesignator = (OMElement)iterator1.next();
                if (attributeDesignator == null) continue;
                String attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
                String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
                List<String> attributeValues2 = this.searchAttributeValues(omElement, new ArrayList<String>(), true);
                if (attributeValues2 == null) {
                    attributeValueDTO5 = new AttributeValueDTO();
                    attributeValueDTO5.setAttributeType("UNKNOWN");
                    attributeValueDTO5.setAttribute("Attribute values are not defined directly for Resource Designator Element ");
                    attributeValueDTOs.add(attributeValueDTO5);
                    continue;
                }
                if (attributeValues2.isEmpty()) {
                    attributeValueDTO5 = new AttributeValueDTO();
                    attributeValueDTO5.setAttributeType("UNKNOWN");
                    attributeValueDTO5.setAttribute("No Attributes are defined for Resource Designator Element ");
                    continue;
                }
                for (String value : attributeValues2) {
                    attributeValueDTO4 = new AttributeValueDTO();
                    attributeValueDTO4.setAttribute(value);
                    attributeValueDTO4.setAttributeDataType(dataType);
                    attributeValueDTO4.setAttributeType("Resource");
                    attributeValueDTO4.setAttributeId(attributeId);
                    attributeValueDTOs.add(attributeValueDTO4);
                }
            }
            Iterator iterator2 = omElement.getChildrenWithLocalName("SubjectAttributeDesignator");
            while (iterator2.hasNext()) {
                AttributeValueDTO attributeValueDTO6;
                OMElement attributeDesignator = (OMElement)iterator2.next();
                if (attributeDesignator == null) continue;
                String attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
                String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
                List<String> attributeValues3 = this.searchAttributeValues(omElement, new ArrayList<String>(), true);
                if (attributeValues3 == null) {
                    attributeValueDTO6 = new AttributeValueDTO();
                    attributeValueDTO6.setAttributeType("UNKNOWN");
                    attributeValueDTO6.setAttribute("Attribute values are not defined directly for Resource Designator Element ");
                    attributeValueDTOs.add(attributeValueDTO6);
                    continue;
                }
                if (attributeValues3.isEmpty()) {
                    attributeValueDTO6 = new AttributeValueDTO();
                    attributeValueDTO6.setAttributeType("UNKNOWN");
                    attributeValueDTO6.setAttribute("No Attributes are defined for Resource Designator Element ");
                    continue;
                }
                for (String value : attributeValues3) {
                    attributeValueDTO3 = new AttributeValueDTO();
                    attributeValueDTO3.setAttribute(value);
                    attributeValueDTO3.setAttributeDataType(dataType);
                    attributeValueDTO3.setAttributeType("Subject");
                    attributeValueDTO3.setAttributeId(attributeId);
                    attributeValueDTOs.add(attributeValueDTO3);
                }
            }
            Iterator iterator3 = omElement.getChildrenWithLocalName("ActionAttributeDesignator");
            while (iterator3.hasNext()) {
                OMElement attributeDesignator = (OMElement)iterator3.next();
                if (attributeDesignator == null) continue;
                String attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
                String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
                attributeValues = this.searchAttributeValues(omElement, new ArrayList<String>(), true);
                if (attributeValues == null) {
                    attributeValueDTO4 = new AttributeValueDTO();
                    attributeValueDTO4.setAttributeType("UNKNOWN");
                    attributeValueDTO4.setAttribute("Attribute values are not defined directly for Resource Designator Element ");
                    attributeValueDTOs.add(attributeValueDTO4);
                    continue;
                }
                if (attributeValues.isEmpty()) {
                    attributeValueDTO4 = new AttributeValueDTO();
                    attributeValueDTO4.setAttributeType("UNKNOWN");
                    attributeValueDTO4.setAttribute("No Attributes are defined for Resource Designator Element ");
                    continue;
                }
                for (String value : attributeValues) {
                    attributeValueDTO2 = new AttributeValueDTO();
                    attributeValueDTO2.setAttribute(value);
                    attributeValueDTO2.setAttributeDataType(dataType);
                    attributeValueDTO2.setAttributeType("Action");
                    attributeValueDTO2.setAttributeId(attributeId);
                    attributeValueDTOs.add(attributeValueDTO2);
                }
            }
            Iterator iterator4 = omElement.getChildrenWithLocalName("EnvironmentAttributeDesignator");
            while (iterator4.hasNext()) {
                OMElement attributeDesignator = (OMElement)iterator4.next();
                if (attributeDesignator == null) continue;
                String attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
                String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
                List<String> attributeValues4 = this.searchAttributeValues(omElement, new ArrayList<String>(), true);
                if (attributeValues4 == null) {
                    attributeValueDTO3 = new AttributeValueDTO();
                    attributeValueDTO3.setAttributeType("UNKNOWN");
                    attributeValueDTO3.setAttribute("Attribute values are not defined directly for Resource Designator Element ");
                    attributeValueDTOs.add(attributeValueDTO3);
                    continue;
                }
                if (attributeValues4.isEmpty()) {
                    attributeValueDTO3 = new AttributeValueDTO();
                    attributeValueDTO3.setAttributeType("UNKNOWN");
                    attributeValueDTO3.setAttribute("No Attributes are defined for Resource Designator Element ");
                    continue;
                }
                for (String value : attributeValues4) {
                    attributeValueDTO = new AttributeValueDTO();
                    attributeValueDTO.setAttribute(value);
                    attributeValueDTO.setAttributeDataType(dataType);
                    attributeValueDTO.setAttributeType("Environment");
                    attributeValueDTO.setAttributeId(attributeId);
                    attributeValueDTOs.add(attributeValueDTO);
                }
            }
            Iterator iterator5 = omElement.getChildrenWithLocalName("AttributeSelector");
            while (iterator5.hasNext()) {
                String attributeId;
                OMElement attributeSelector = (OMElement)iterator5.next();
                if (attributeSelector == null) continue;
                String subElementName = attributeId = attributeSelector.getAttributeValue(new QName("RequestContextPath"));
                String dataType = attributeSelector.getAttributeValue(new QName("DataType"));
                List<String> attributeValues5 = this.searchAttributeValues(omElement, new ArrayList<String>(), true);
                if (attributeValues5 == null) {
                    attributeValueDTO = new AttributeValueDTO();
                    attributeValueDTO.setAttributeType("UNKNOWN");
                    attributeValueDTO.setAttribute("Attribute Selector Element is contained with Xpath expression");
                    attributeValueDTOs.add(attributeValueDTO);
                    continue;
                }
                if (attributeValues5.isEmpty()) {
                    attributeValueDTO = new AttributeValueDTO();
                    attributeValueDTO.setAttributeType("UNKNOWN");
                    attributeValueDTO.setAttribute("Attribute Selector Element is contained with Xpath expression");
                    continue;
                }
                for (String value : attributeValues5) {
                    AttributeValueDTO attributeValueDTO7 = new AttributeValueDTO();
                    attributeValueDTO7.setAttribute(value);
                    attributeValueDTO7.setAttributeDataType(dataType);
                    attributeValueDTO7.setAttributeType(subElementName);
                    attributeValueDTO7.setAttributeId(attributeId);
                    attributeValueDTOs.add(attributeValueDTO7);
                    attributeValueDTO7.setAttributeType("UNKNOWN");
                    attributeValueDTO7.setAttribute("Attribute Selector Element is contained with Xpath expression");
                }
            }
            Iterator iterator6 = omElement.getChildrenWithLocalName("AttributeValue");
            if (iterator6.hasNext()) {
                attributeValues = this.searchAttributeValues(omElement, new ArrayList<String>(), false);
                if (attributeValues == null) {
                    attributeValueDTO4 = new AttributeValueDTO();
                    attributeValueDTO4.setAttributeType("UNKNOWN");
                    attributeValueDTO4.setAttribute("Attribute values are not defined directly for Resource Designator Element ");
                    attributeValueDTOs.add(attributeValueDTO4);
                } else if (attributeValues.isEmpty()) {
                    attributeValueDTO4 = new AttributeValueDTO();
                    attributeValueDTO4.setAttributeType("UNKNOWN");
                    attributeValueDTO4.setAttribute("No Attributes are defined for Resource Designator Element ");
                } else {
                    for (String values : attributeValues) {
                        attributeValueDTO2 = new AttributeValueDTO();
                        attributeValueDTO2.setAttribute(values);
                        Iterator iterator8 = omElement.getChildrenWithLocalName("Apply");
                        while (iterator8.hasNext()) {
                            OMElement applyElement = (OMElement)iterator8.next();
                            this.searchDesignatorOrSelector(applyElement, attributeValueDTO2);
                        }
                        if (attributeValueDTO2.getAttributeType() == null && !"".equals(attributeValueDTO2.getAttributeType())) continue;
                        attributeValueDTOs.add(attributeValueDTO2);
                    }
                }
            }
            Iterator iterator7 = omElement.getChildrenWithLocalName("Apply");
            while (iterator7.hasNext()) {
                OMElement applyElement = (OMElement)iterator7.next();
                this.createMetaDataFromApplyElement(applyElement, attributeValueDTOs);
            }
        }
        return attributeValueDTOs;
    }

    public List<String> searchAttributeValues(OMElement omElement, List<String> values, boolean searchDesignators) {
        if (values != null) {
            Iterator iterator = omElement.getChildrenWithLocalName("AttributeValue");
            while (iterator.hasNext()) {
                OMElement attributeElement = (OMElement)iterator.next();
                if (attributeElement == null) continue;
                values.add(attributeElement.getText());
            }
        }
        Iterator iterator1 = omElement.getChildrenWithLocalName("Apply");
        while (iterator1.hasNext()) {
            OMElement applyElement = (OMElement)iterator1.next();
            this.searchAttributeValues(applyElement, values, searchDesignators);
            AttributeValueDTO attributeValueDTO = new AttributeValueDTO();
            if (searchDesignators) {
                this.searchDesignatorOrSelector(applyElement, attributeValueDTO);
            }
            if (attributeValueDTO.getAttributeType() == null && attributeValueDTO.getAttributeId() == null && attributeValueDTO.getAttributeDataType() == null) continue;
            values = null;
        }
        return values;
    }

    public AttributeValueDTO searchDesignatorOrSelector(OMElement omElement, AttributeValueDTO attributeValueDTO) {
        Iterator iterator1 = omElement.getChildrenWithLocalName("ResourceAttributeDesignator");
        while (iterator1.hasNext()) {
            OMElement attributeDesignator = (OMElement)iterator1.next();
            if (attributeDesignator == null) continue;
            String attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
            String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
            attributeValueDTO.setAttributeDataType(dataType);
            attributeValueDTO.setAttributeType("Resource");
            attributeValueDTO.setAttributeId(attributeId);
        }
        Iterator iterator2 = omElement.getChildrenWithLocalName("SubjectAttributeDesignator");
        while (iterator2.hasNext()) {
            OMElement attributeDesignator = (OMElement)iterator2.next();
            if (attributeDesignator == null) continue;
            String attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
            String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
            attributeValueDTO.setAttributeDataType(dataType);
            attributeValueDTO.setAttributeType("Subject");
            attributeValueDTO.setAttributeId(attributeId);
        }
        Iterator iterator3 = omElement.getChildrenWithLocalName("ActionAttributeDesignator");
        while (iterator3.hasNext()) {
            OMElement attributeDesignator = (OMElement)iterator3.next();
            if (attributeDesignator == null) continue;
            String attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
            String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
            attributeValueDTO.setAttributeDataType(dataType);
            attributeValueDTO.setAttributeType("Action");
            attributeValueDTO.setAttributeId(attributeId);
        }
        Iterator iterator4 = omElement.getChildrenWithLocalName("EnvironmentAttributeDesignator");
        while (iterator4.hasNext()) {
            OMElement attributeDesignator = (OMElement)iterator4.next();
            if (attributeDesignator == null) continue;
            String attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
            String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
            attributeValueDTO.setAttributeDataType(dataType);
            attributeValueDTO.setAttributeType("Environment");
            attributeValueDTO.setAttributeId(attributeId);
        }
        Iterator iterator5 = omElement.getChildrenWithLocalName("AttributeSelector");
        while (iterator5.hasNext()) {
            String attributeId;
            OMElement attributeDesignator = (OMElement)iterator5.next();
            if (attributeDesignator == null) continue;
            String subElementName = attributeId = attributeDesignator.getAttributeValue(new QName("RequestContextPath"));
            String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
            attributeValueDTO.setAttributeDataType(dataType);
            attributeValueDTO.setAttributeType("UNKNOWN");
            attributeValueDTO.setAttribute("Attribute Selector Element is contained with Xpath expression");
            attributeValueDTO.setAttributeId(attributeId);
        }
        return attributeValueDTO;
    }

    public List<AttributeValueDTO> createMetaDataFromConditionElement(OMElement omElement, List<AttributeValueDTO> attributeValueDTOs) {
        Iterator iterator = omElement.getChildrenWithLocalName("Apply");
        if (iterator.hasNext()) {
            this.createMetaDataFromApplyElement(omElement, attributeValueDTOs);
        } else {
            AttributeValueDTO attributeValueDTO = new AttributeValueDTO();
            attributeValueDTO.setAttributeType("UNKNOWN");
            attributeValueDTO.setAttribute("Apply Element is not contained within Condition Element");
        }
        return attributeValueDTOs;
    }

    public List<AttributeValueDTO> createMetaDataFromRuleElement(OMElement omElement, List<AttributeValueDTO> attributeValueDTOs) {
        if (omElement != null) {
            Iterator iterator1 = omElement.getChildrenWithLocalName("Target");
            while (iterator1.hasNext()) {
                OMElement targetElement = (OMElement)iterator1.next();
                this.createMetaDataFromTargetElement(targetElement, attributeValueDTOs);
            }
            Iterator iterator2 = omElement.getChildrenWithLocalName("Condition");
            while (iterator2.hasNext()) {
                OMElement conditionElement = (OMElement)iterator2.next();
                this.createMetaDataFromConditionElement(conditionElement, attributeValueDTOs);
            }
        }
        return attributeValueDTOs;
    }
}

