/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml3.advice;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.Indenter;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.xacml2.Result;
import org.wso2.balana.xacml3.AttributeAssignment;
import org.wso2.balana.xacml3.AttributeAssignmentExpression;
import org.wso2.balana.xacml3.advice.Advice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdviceExpression {
    private URI adviceId;
    private int appliesTo;
    private List<AttributeAssignmentExpression> attributeAssignmentExpressions;

    public AdviceExpression(URI adviceId, int appliesTo, List<AttributeAssignmentExpression> attributeAssignmentExpressions) {
        this.adviceId = adviceId;
        this.appliesTo = appliesTo;
        this.attributeAssignmentExpressions = attributeAssignmentExpressions;
    }

    public static AdviceExpression getInstance(Node root, PolicyMetaData metaData) throws ParsingException {
        int appliesTo;
        String effect;
        URI adviceId;
        ArrayList<AttributeAssignmentExpression> expressions = new ArrayList<AttributeAssignmentExpression>();
        NamedNodeMap attrs = root.getAttributes();
        try {
            adviceId = new URI(attrs.getNamedItem("AdviceId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute AdviceId in AdviceExpressionType", e);
        }
        try {
            effect = attrs.getNamedItem("AppliesTo").getNodeValue();
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute AppliesTo in AdviceExpressionType", e);
        }
        if (effect.equals("Permit")) {
            appliesTo = 0;
        } else if (effect.equals("Deny")) {
            appliesTo = 1;
        } else {
            throw new ParsingException("Invalid Effect type: " + effect);
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("AttributeAssignmentExpression")) continue;
            try {
                AttributeAssignmentExpression expression = AttributeAssignmentExpression.getInstance(node, metaData);
                expressions.add(expression);
                continue;
            }
            catch (Exception e) {
                throw new ParsingException("Error parsing attribute assignments in AdviceExpressionType", e);
            }
        }
        return new AdviceExpression(adviceId, appliesTo, expressions);
    }

    public int getAppliesTo() {
        return this.appliesTo;
    }

    public URI getAdviceId() {
        return this.adviceId;
    }

    public Advice evaluate(EvaluationCtx ctx) {
        ArrayList<AttributeAssignment> assignments = new ArrayList<AttributeAssignment>();
        for (AttributeAssignmentExpression expression : this.attributeAssignmentExpressions) {
            Set<AttributeAssignment> assignmentSet = expression.evaluate(ctx);
            if (assignmentSet == null || assignmentSet.size() <= 0) continue;
            assignments.addAll(assignmentSet);
        }
        return new Advice(this.adviceId, assignments);
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(indent + "<AdviceExpression AdviceId=\"" + this.adviceId.toString() + "\" AppliesTo=\"" + Result.DECISIONS[this.appliesTo] + "\">");
        indenter.in();
        if (this.attributeAssignmentExpressions != null && this.attributeAssignmentExpressions.size() > 0) {
            for (AttributeAssignmentExpression assignment : this.attributeAssignmentExpressions) {
                assignment.encode(output, indenter);
            }
        }
        indenter.out();
        out.println(indent + "</AdviceExpression>");
    }
}

