/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml3;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.Attribute;
import org.wso2.balana.Indenter;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attributes {
    private URI category;
    private Node content;
    private Set<Attribute> attributes;
    private String id;

    public Attributes(URI category, Node content, Set<Attribute> attributes, String id) {
        this.category = category;
        this.content = content;
        this.attributes = attributes;
        this.id = id;
    }

    public static Attributes getInstance(Node root) throws ParsingException {
        URI category;
        Node content = null;
        String id = null;
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        if (!root.getNodeName().equals("Attributes")) {
            throw new ParsingException("Attributes object cannot be created with root node of type: " + root.getNodeName());
        }
        NamedNodeMap attrs = root.getAttributes();
        try {
            category = new URI(attrs.getNamedItem("Category").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute AttributeId in AttributesType", e);
        }
        try {
            Node idNode = attrs.getNamedItem("id");
            if (idNode != null) {
                id = idNode.getNodeValue();
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing optional attributes in AttributesType", e);
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("Content")) {
                if (content != null) {
                    throw new ParsingException("Too many content elements are defined.");
                }
                content = node;
                continue;
            }
            if (!node.getNodeName().equals("Attribute")) continue;
            attributes.add(Attribute.getInstance(node, new PolicyMetaData(3, 1)));
        }
        return new Attributes(category, content, attributes, id);
    }

    public URI getCategory() {
        return this.category;
    }

    public Object getContent() {
        return this.content;
    }

    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    public String getId() {
        return this.id;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        String indent = indenter.makeString();
        PrintStream out = new PrintStream(output);
        out.println(indent + "<Attributes Category=\"" + this.category.toString() + "\">");
        indenter.in();
        for (Attribute attribute : this.attributes) {
            if (!attribute.isIncludeInResult()) continue;
            attribute.encode(output, indenter);
        }
        indenter.out();
        indenter.in();
        if (this.content != null) {
            // empty if block
        }
        out.println(indent + "</Attributes>");
    }

    public void encodeWithIncludedAttributes(OutputStream output, Indenter indenter) {
        String indent = indenter.makeString();
        PrintStream out = new PrintStream(output);
        out.println(indent + "<Attributes Category=\"" + this.category.toString() + "\">");
        indenter.in();
        for (Attribute attribute : this.attributes) {
            if (!attribute.isIncludeInResult()) continue;
            attribute.encode(output, indenter);
        }
        indenter.out();
        indenter.in();
        if (this.content != null) {
            // empty if block
        }
        out.println(indent + "</Attributes>");
    }
}

