/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml3;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.wso2.balana.Indenter;
import org.wso2.balana.ParsingException;
import org.wso2.balana.attr.AttributeFactory;
import org.wso2.balana.attr.AttributeValue;

public class AttributeAssignment {
    private URI attributeId;
    private URI category;
    private String issuer;
    private AttributeValue value;

    public AttributeAssignment(URI attributeId, AttributeValue value, URI category, String issuer) {
        this.attributeId = attributeId;
        this.value = value;
        this.category = category;
        this.issuer = issuer;
    }

    public static AttributeAssignment getInstance(Node root) throws ParsingException {
        URI type;
        URI attributeId;
        URI category = null;
        String issuer = null;
        AttributeValue value = null;
        AttributeFactory attrFactory = AttributeFactory.getInstance();
        if (!root.getNodeName().equals("AttributeAssignment")) {
            throw new ParsingException("AttributeAssignment object cannot be created with root node of type: " + root.getNodeName());
        }
        NamedNodeMap nodeAttributes = root.getAttributes();
        try {
            attributeId = new URI(nodeAttributes.getNamedItem("AttributeId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required AttributeId in AttributeAssignmentType", e);
        }
        try {
            type = new URI(nodeAttributes.getNamedItem("DataType").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required AttributeId in AttributeAssignmentType", e);
        }
        try {
            Node issuerNode;
            Node categoryNode = nodeAttributes.getNamedItem("Category");
            if (categoryNode != null) {
                category = new URI(categoryNode.getNodeValue());
            }
            if ((issuerNode = nodeAttributes.getNamedItem("Issuer")) != null) {
                issuer = issuerNode.getNodeValue();
            }
            value = attrFactory.createValue(root, type);
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing optional attributes in AttributeAssignmentType", e);
        }
        return new AttributeAssignment(attributeId, value, category, issuer);
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.print("<AttributeAssignment  AttributeId=\"" + this.attributeId + "\"");
        if (this.category != null) {
            out.print(" Category=\"" + this.category + "\"");
        }
        if (this.issuer != null) {
            out.print("\" Issuer=\"" + this.issuer + "\"");
        }
        out.println(">");
        indenter.in();
        out.println(this.value.encodeWithTags(true));
        indenter.out();
        out.println(indent + "</AttributeAssignment>");
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }
}

