/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx;

import java.io.InputStream;
import org.w3c.dom.Node;
import org.wso2.balana.ParsingException;
import org.wso2.balana.ctx.AbstractRequestCtx;
import org.wso2.balana.ctx.InputParser;
import org.wso2.balana.xacml2.ctx.RequestCtx;

public class RequestCtxFactory {
    private static RequestCtxFactory factoryInstance;

    public AbstractRequestCtx getRequestCtx(Node root) throws ParsingException {
        String requestCtxNs = root.getNamespaceURI();
        if (requestCtxNs != null) {
            if ("urn:oasis:names:tc:xacml:3.0:core:schema:wd-17".equals(requestCtxNs.trim())) {
                return org.wso2.balana.xacml3.ctx.RequestCtx.getInstance(root);
            }
            return RequestCtx.getInstance(root);
        }
        throw new ParsingException("Namespace of Request cannot be null");
    }

    public AbstractRequestCtx getRequestCtx(InputStream input) throws ParsingException {
        Node root = InputParser.parseInput(input, "Request");
        String requestCtxNs = root.getNamespaceURI();
        if (requestCtxNs != null) {
            if ("urn:oasis:names:tc:xacml:3.0:core:schema:wd-17".equals(requestCtxNs.trim())) {
                return org.wso2.balana.xacml3.ctx.RequestCtx.getInstance(root);
            }
            return RequestCtx.getInstance(root);
        }
        throw new ParsingException("Namespace of Request cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RequestCtxFactory getFactory() {
        if (factoryInstance != null) return factoryInstance;
        Class<RequestCtxFactory> clazz = RequestCtxFactory.class;
        synchronized (RequestCtxFactory.class) {
            if (factoryInstance != null) return factoryInstance;
            factoryInstance = new RequestCtxFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return factoryInstance;
        }
    }
}

