/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx;

import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.wso2.balana.Indenter;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.xacml3.advice.Advice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResult {
    public static final int DECISION_PERMIT = 0;
    public static final int DECISION_DENY = 1;
    public static final int DECISION_INDETERMINATE = 2;
    public static final int DECISION_NOT_APPLICABLE = 3;
    public static final String[] DECISIONS = new String[]{"Permit", "Deny", "Indeterminate", "NotApplicable"};
    protected Set<ObligationResult> obligations;
    protected Set<Advice> advices;
    protected int decision = -1;
    protected Status status = null;

    public AbstractResult(int decision, Status status, Set<ObligationResult> obligationResults, Set<Advice> advices, EvaluationCtx evaluationCtx) throws IllegalArgumentException {
        if (decision != 0 && decision != 1 && decision != 2 && decision != 3) {
            throw new IllegalArgumentException("invalid decision value");
        }
        this.decision = decision;
        if (obligationResults != null) {
            this.obligations = obligationResults;
        }
        if (advices != null) {
            this.advices = advices;
        }
        this.status = status == null ? Status.getOkInstance() : status;
    }

    public Set<ObligationResult> getObligations() {
        if (this.obligations == null) {
            this.obligations = new HashSet<ObligationResult>();
        }
        return this.obligations;
    }

    public Set<Advice> getAdvices() {
        if (this.advices == null) {
            this.advices = new HashSet<Advice>();
        }
        return this.advices;
    }

    public int getDecision() {
        return this.decision;
    }

    public Status getStatus() {
        return this.status;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public abstract void encode(OutputStream var1, Indenter var2);
}

