/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond;

import java.net.URI;
import java.util.HashMap;
import java.util.Set;
import org.w3c.dom.Node;
import org.wso2.balana.ParsingException;
import org.wso2.balana.UnknownIdentifierException;
import org.wso2.balana.cond.Function;
import org.wso2.balana.cond.FunctionFactoryProxy;
import org.wso2.balana.cond.FunctionProxy;
import org.wso2.balana.cond.FunctionTypeException;
import org.wso2.balana.cond.StandardFunctionFactory;

public abstract class FunctionFactory {
    private static FunctionFactoryProxy defaultFactoryProxy;
    private static HashMap registeredFactories;

    protected FunctionFactory() {
    }

    public static final FunctionFactory getTargetInstance() {
        return defaultFactoryProxy.getTargetFactory();
    }

    public static final FunctionFactory getTargetInstance(String identifier) throws UnknownIdentifierException {
        return FunctionFactory.getRegisteredProxy(identifier).getTargetFactory();
    }

    public static final FunctionFactory getConditionInstance() {
        return defaultFactoryProxy.getConditionFactory();
    }

    public static final FunctionFactory getConditionInstance(String identifier) throws UnknownIdentifierException {
        return FunctionFactory.getRegisteredProxy(identifier).getConditionFactory();
    }

    public static final FunctionFactory getGeneralInstance() {
        return defaultFactoryProxy.getGeneralFactory();
    }

    public static final FunctionFactory getGeneralInstance(String identifier) throws UnknownIdentifierException {
        return FunctionFactory.getRegisteredProxy(identifier).getGeneralFactory();
    }

    public static final FunctionFactoryProxy getInstance() {
        return defaultFactoryProxy;
    }

    public static final FunctionFactoryProxy getInstance(String identifier) throws UnknownIdentifierException {
        return FunctionFactory.getRegisteredProxy(identifier);
    }

    private static FunctionFactoryProxy getRegisteredProxy(String identifier) throws UnknownIdentifierException {
        FunctionFactoryProxy proxy = (FunctionFactoryProxy)registeredFactories.get(identifier);
        if (proxy == null) {
            throw new UnknownIdentifierException("Uknown FunctionFactory identifier: " + identifier);
        }
        return proxy;
    }

    public static final void setDefaultFactory(FunctionFactoryProxy proxy) {
        defaultFactoryProxy = proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void registerFactory(String identifier, FunctionFactoryProxy proxy) throws IllegalArgumentException {
        HashMap hashMap = registeredFactories;
        synchronized (hashMap) {
            if (registeredFactories.containsKey(identifier)) {
                throw new IllegalArgumentException("Identifier is already registered as FunctionFactory: " + identifier);
            }
            registeredFactories.put(identifier, proxy);
        }
    }

    public abstract void addFunction(Function var1);

    public abstract void addAbstractFunction(FunctionProxy var1, URI var2);

    public static void addTargetFunction(Function function) {
        FunctionFactory.getTargetInstance().addFunction(function);
    }

    public static void addAbstractTargetFunction(FunctionProxy proxy, URI identity) {
        FunctionFactory.getTargetInstance().addAbstractFunction(proxy, identity);
    }

    public static void addConditionFunction(Function function) {
        FunctionFactory.getConditionInstance().addFunction(function);
    }

    public static void addAbstractConditionFunction(FunctionProxy proxy, URI identity) {
        FunctionFactory.getConditionInstance().addAbstractFunction(proxy, identity);
    }

    public static void addGeneralFunction(Function function) {
        FunctionFactory.getGeneralInstance().addFunction(function);
    }

    public static void addAbstractGeneralFunction(FunctionProxy proxy, URI identity) {
        FunctionFactory.getGeneralInstance().addAbstractFunction(proxy, identity);
    }

    public abstract Set getSupportedFunctions();

    public abstract Function createFunction(URI var1) throws UnknownIdentifierException, FunctionTypeException;

    public abstract Function createFunction(String var1) throws UnknownIdentifierException, FunctionTypeException;

    public abstract Function createAbstractFunction(URI var1, Node var2) throws UnknownIdentifierException, ParsingException, FunctionTypeException;

    public abstract Function createAbstractFunction(URI var1, Node var2, String var3) throws UnknownIdentifierException, ParsingException, FunctionTypeException;

    public abstract Function createAbstractFunction(String var1, Node var2) throws UnknownIdentifierException, ParsingException, FunctionTypeException;

    public abstract Function createAbstractFunction(String var1, Node var2, String var3) throws UnknownIdentifierException, ParsingException, FunctionTypeException;

    static {
        FunctionFactoryProxy proxy = new FunctionFactoryProxy(){

            public FunctionFactory getTargetFactory() {
                return StandardFunctionFactory.getTargetFactory();
            }

            public FunctionFactory getConditionFactory() {
                return StandardFunctionFactory.getConditionFactory();
            }

            public FunctionFactory getGeneralFactory() {
                return StandardFunctionFactory.getGeneralFactory();
            }
        };
        registeredFactories = new HashMap();
        registeredFactories.put("urn:oasis:names:tc:xacml:1.0:policy", proxy);
        registeredFactories.put("urn:oasis:names:tc:xacml:2.0:policy:schema:os", proxy);
        defaultFactoryProxy = proxy;
    }
}

