/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.wso2.balana.Indenter;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.cond.Evaluatable;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.cond.Function;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;

public abstract class FunctionBase
implements Function {
    public static final String FUNCTION_NS = "urn:oasis:names:tc:xacml:1.0:function:";
    public static final String FUNCTION_NS_2 = "urn:oasis:names:tc:xacml:2.0:function:";
    private static List processingErrList = null;
    private String functionName;
    private int functionId;
    private String returnType;
    private boolean returnsBag;
    private boolean singleType;
    private String paramType;
    private boolean paramIsBag;
    private int numParams;
    private int minParams;
    private String[] paramTypes;
    private boolean[] paramsAreBags;

    public FunctionBase(String functionName, int functionId, String paramType, boolean paramIsBag, int numParams, String returnType, boolean returnsBag) {
        this(functionName, functionId, returnType, returnsBag);
        this.singleType = true;
        this.paramType = paramType;
        this.paramIsBag = paramIsBag;
        this.numParams = numParams;
        this.minParams = 0;
    }

    public FunctionBase(String functionName, int functionId, String paramType, boolean paramIsBag, int numParams, int minParams, String returnType, boolean returnsBag) {
        this(functionName, functionId, returnType, returnsBag);
        this.singleType = true;
        this.paramType = paramType;
        this.paramIsBag = paramIsBag;
        this.numParams = numParams;
        this.minParams = minParams;
    }

    public FunctionBase(String functionName, int functionId, String[] paramTypes, boolean[] paramIsBag, String returnType, boolean returnsBag) {
        this(functionName, functionId, returnType, returnsBag);
        this.singleType = false;
        this.paramTypes = paramTypes;
        this.paramsAreBags = paramIsBag;
    }

    public FunctionBase(String functionName, int functionId, String returnType, boolean returnsBag) {
        this.functionName = functionName;
        this.functionId = functionId;
        this.returnType = returnType;
        this.returnsBag = returnsBag;
    }

    public URI getIdentifier() {
        try {
            return new URI(this.functionName);
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException("invalid URI");
        }
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public int getFunctionId() {
        return this.functionId;
    }

    public URI getType() {
        return this.getReturnType();
    }

    public URI getReturnType() {
        try {
            return new URI(this.returnType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean returnsBag() {
        return this.returnsBag;
    }

    public String getReturnTypeAsString() {
        return this.returnType;
    }

    protected static EvaluationResult makeProcessingError(String message) {
        if (processingErrList == null) {
            String[] errStrings = new String[]{"urn:oasis:names:tc:xacml:1.0:status:processing-error"};
            processingErrList = Arrays.asList(errStrings);
        }
        Status errStatus = new Status(processingErrList, message);
        EvaluationResult processingError = new EvaluationResult(errStatus);
        return processingError;
    }

    protected EvaluationResult evalArgs(List params, EvaluationCtx context, AttributeValue[] args) {
        Iterator it = params.iterator();
        int index = 0;
        while (it.hasNext()) {
            Evaluatable eval = (Evaluatable)it.next();
            EvaluationResult result = eval.evaluate(context);
            if (result.indeterminate()) {
                return result;
            }
            args[index++] = result.getAttributeValue();
        }
        return null;
    }

    public void checkInputs(List inputs) throws IllegalArgumentException {
        if (this.singleType) {
            if (this.numParams != -1) {
                if (inputs.size() != this.numParams) {
                    throw new IllegalArgumentException("wrong number of args to " + this.functionName);
                }
            } else if (inputs.size() < this.minParams) {
                throw new IllegalArgumentException("not enough args to " + this.functionName);
            }
            for (Evaluatable eval : inputs) {
                if (eval.getType().toString().equals(this.paramType) && eval.returnsBag() == this.paramIsBag) continue;
                throw new IllegalArgumentException("illegal parameter");
            }
        } else {
            if (this.paramTypes.length != inputs.size()) {
                throw new IllegalArgumentException("wrong number of args to " + this.functionName);
            }
            Iterator it = inputs.iterator();
            int i = 0;
            while (it.hasNext()) {
                Evaluatable eval = (Evaluatable)it.next();
                if (!eval.getType().toString().equals(this.paramTypes[i]) || eval.returnsBag() != this.paramsAreBags[i]) {
                    throw new IllegalArgumentException("illegal parameter");
                }
                ++i;
            }
        }
    }

    public void checkInputsNoBag(List inputs) throws IllegalArgumentException {
        if (this.singleType) {
            if (this.paramIsBag) {
                throw new IllegalArgumentException(this.functionName + "needs" + "bags on input");
            }
            if (this.numParams != -1) {
                if (inputs.size() != this.numParams) {
                    throw new IllegalArgumentException("wrong number of args to " + this.functionName);
                }
            } else if (inputs.size() < this.minParams) {
                throw new IllegalArgumentException("not enough args to " + this.functionName);
            }
            for (Evaluatable eval : inputs) {
                if (eval.getType().toString().equals(this.paramType)) continue;
                throw new IllegalArgumentException("illegal parameter");
            }
        } else {
            if (this.paramTypes.length != inputs.size()) {
                throw new IllegalArgumentException("wrong number of args to " + this.functionName);
            }
            Iterator it = inputs.iterator();
            int i = 0;
            while (it.hasNext()) {
                Evaluatable eval = (Evaluatable)it.next();
                if (!eval.getType().toString().equals(this.paramTypes[i]) || this.paramsAreBags[i]) {
                    throw new IllegalArgumentException("illegal parameter");
                }
                ++i;
            }
        }
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        out.println(indenter.makeString() + "<Function FunctionId=\"" + this.getFunctionName() + "\"/>");
    }
}

