/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.combine;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.Indenter;
import org.wso2.balana.Policy;
import org.wso2.balana.PolicyReference;
import org.wso2.balana.PolicySet;
import org.wso2.balana.combine.CombinerElement;
import org.wso2.balana.combine.CombinerParameter;

public class PolicyCombinerElement
extends CombinerElement {
    public PolicyCombinerElement(AbstractPolicy policy) {
        super(policy);
    }

    public PolicyCombinerElement(AbstractPolicy policy, List parameters) {
        super(policy, parameters);
    }

    public AbstractPolicy getPolicy() {
        return (AbstractPolicy)this.getElement();
    }

    public void encode(OutputStream output, Indenter indenter) {
        if (!this.getParameters().isEmpty()) {
            AbstractPolicy policy = this.getPolicy();
            if (policy instanceof Policy) {
                this.encodeParamaters(output, indenter, "Policy", policy.getId().toString());
            } else if (policy instanceof PolicySet) {
                this.encodeParamaters(output, indenter, "PolicySet", policy.getId().toString());
            } else {
                PolicyReference ref = (PolicyReference)policy;
                if (ref.getReferenceType() == 0) {
                    this.encodeParamaters(output, indenter, "Policy", ref.getReference().toString());
                } else {
                    this.encodeParamaters(output, indenter, "PolicySet", ref.getReference().toString());
                }
            }
        }
        this.getPolicy().encode(output, indenter);
    }

    private void encodeParamaters(OutputStream output, Indenter indenter, String prefix, String id) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        Iterator it = this.getParameters().iterator();
        out.println(indent + "<" + prefix + "CombinerParameters " + prefix + "IdRef=\"" + id + "\">");
        indenter.in();
        while (it.hasNext()) {
            CombinerParameter param = (CombinerParameter)it.next();
            param.encode(output, indenter);
        }
        out.println(indent + "</" + prefix + "CombinerParameters>");
        indenter.out();
    }
}

