/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.combine;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.MatchResult;
import org.wso2.balana.ResultFactory;
import org.wso2.balana.combine.PolicyCombinerElement;
import org.wso2.balana.combine.PolicyCombiningAlgorithm;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.ctx.EvaluationCtx;

public class FirstApplicablePolicyAlg
extends PolicyCombiningAlgorithm {
    public static final String algId = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:first-applicable";
    private static URI identifierURI;
    private static RuntimeException earlyException;

    public FirstApplicablePolicyAlg() {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
    }

    public AbstractResult combine(EvaluationCtx context, List parameters, List policyElements) {
        Iterator it = policyElements.iterator();
        while (it.hasNext()) {
            AbstractResult result;
            int effect;
            AbstractPolicy policy = ((PolicyCombinerElement)it.next()).getPolicy();
            MatchResult match = policy.match(context);
            if (match.getResult() == 2) {
                return ResultFactory.getFactory().getResult(2, match.getStatus(), context);
            }
            if (match.getResult() != 0 || (effect = (result = policy.evaluate(context)).getDecision()) == 3 || context.isSearching()) continue;
            return result;
        }
        return ResultFactory.getFactory().getResult(3, context);
    }

    static {
        try {
            identifierURI = new URI(algId);
        }
        catch (URISyntaxException se) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(se);
        }
    }
}

