/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.attr;

import java.math.BigInteger;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.dom.Node;
import org.wso2.balana.ParsingException;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.DateAttribute;

public class DayTimeDurationAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/TR/2002/WD-xquery-operators-20020816#dayTimeDuration";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private static final String patternString = "(\\-)?P((\\d+)?D)?(T((\\d+)?H)?((\\d+)?M)?((\\d+)?(.(\\d+)?)?S)?)?";
    private static final int GROUP_SIGN = 1;
    private static final int GROUP_DAYS = 3;
    private static final int GROUP_HOURS = 6;
    private static final int GROUP_MINUTES = 8;
    private static final int GROUP_SECONDS = 10;
    private static final int GROUP_NANOSECONDS = 12;
    private static BigInteger big24;
    private static BigInteger big60;
    private static BigInteger big1000;
    private static BigInteger bigMaxLong;
    private static Pattern pattern;
    private boolean negative;
    private long days;
    private long hours;
    private long minutes;
    private long seconds;
    private int nanoseconds;
    private long totalMillis;
    private String encodedValue = null;

    public DayTimeDurationAttribute(boolean negative, long days, long hours, long minutes, long seconds, int nanoseconds) throws IllegalArgumentException {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.negative = negative;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.nanoseconds = nanoseconds;
        if (days > Integer.MAX_VALUE || hours > Integer.MAX_VALUE || minutes > Integer.MAX_VALUE || seconds > Integer.MAX_VALUE) {
            BigInteger bigDays = BigInteger.valueOf(days);
            BigInteger bigHours = BigInteger.valueOf(hours);
            BigInteger bigMinutes = BigInteger.valueOf(minutes);
            BigInteger bigSeconds = BigInteger.valueOf(seconds);
            BigInteger bigTotal = bigDays.multiply(big24).add(bigHours).multiply(big60).add(bigMinutes).multiply(big60).add(bigSeconds).multiply(big1000);
            if (bigTotal.compareTo(bigMaxLong) == 1) {
                throw new IllegalArgumentException("total number of milliseconds exceeds Long.MAX_VALUE");
            }
            this.totalMillis = bigTotal.longValue();
        } else {
            this.totalMillis = (((days * 24L + hours) * 60L + minutes) * 60L + seconds) * 1000L;
        }
    }

    public static DayTimeDurationAttribute getInstance(Node root) throws ParsingException, NumberFormatException {
        return DayTimeDurationAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    private static long parseGroup(Matcher matcher, int groupNumber) throws NumberFormatException {
        long groupLong = 0L;
        if (matcher.start(groupNumber) != -1) {
            String groupString = matcher.group(groupNumber);
            groupLong = Long.parseLong(groupString);
        }
        return groupLong;
    }

    public static DayTimeDurationAttribute getInstance(String value) throws ParsingException, NumberFormatException {
        Matcher matcher;
        boolean matches;
        boolean negative = false;
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        int nanoseconds = 0;
        if (pattern == null) {
            try {
                pattern = Pattern.compile(patternString);
            }
            catch (PatternSyntaxException e) {
                throw new ParsingException("unexpected pattern match error");
            }
        }
        if (!(matches = (matcher = pattern.matcher(value)).matches())) {
            throw new ParsingException("Syntax error in dayTimeDuration");
        }
        if (matcher.start(1) != -1) {
            negative = true;
        }
        days = DayTimeDurationAttribute.parseGroup(matcher, 3);
        hours = DayTimeDurationAttribute.parseGroup(matcher, 6);
        minutes = DayTimeDurationAttribute.parseGroup(matcher, 8);
        seconds = DayTimeDurationAttribute.parseGroup(matcher, 10);
        if (matcher.start(12) != -1) {
            String nanosecondString = matcher.group(12);
            if (nanosecondString.length() < 9) {
                StringBuffer buffer = new StringBuffer(nanosecondString);
                while (buffer.length() < 9) {
                    buffer.append("0");
                }
                nanosecondString = buffer.toString();
            }
            if (nanosecondString.length() > 9) {
                nanosecondString = nanosecondString.substring(0, 9);
            }
            nanoseconds = Integer.parseInt(nanosecondString);
        }
        if (value.charAt(value.length() - 1) == 'T') {
            throw new ParsingException("'T' must be absent if alltime items are absent");
        }
        return new DayTimeDurationAttribute(negative, days, hours, minutes, seconds, nanoseconds);
    }

    public boolean isNegative() {
        return this.negative;
    }

    public long getDays() {
        return this.days;
    }

    public long getHours() {
        return this.hours;
    }

    public long getMinutes() {
        return this.minutes;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNanoseconds() {
        return this.nanoseconds;
    }

    public long getTotalSeconds() {
        return this.totalMillis;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DayTimeDurationAttribute)) {
            return false;
        }
        DayTimeDurationAttribute other = (DayTimeDurationAttribute)o;
        return this.totalMillis == other.totalMillis && this.nanoseconds == other.nanoseconds && this.negative == other.negative;
    }

    public int hashCode() {
        int hashCode = (int)this.totalMillis ^ (int)(this.totalMillis >> 32);
        hashCode = 31 * hashCode + this.nanoseconds;
        if (this.negative) {
            hashCode = -hashCode;
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DayTimeDurationAttribute: [\n");
        sb.append("  Negative: " + this.negative);
        sb.append("  Days: " + this.days);
        sb.append("  Hours: " + this.hours);
        sb.append("  Minutes: " + this.minutes);
        sb.append("  Seconds: " + this.seconds);
        sb.append("  Nanoseconds: " + this.nanoseconds);
        sb.append("  TotalSeconds: " + this.totalMillis);
        sb.append("]");
        return sb.toString();
    }

    public String encode() {
        if (this.encodedValue != null) {
            return this.encodedValue;
        }
        StringBuffer buf = new StringBuffer(10);
        if (this.negative) {
            buf.append('-');
        }
        buf.append('P');
        if (this.days != 0L) {
            buf.append(Long.toString(this.days));
            buf.append('D');
        }
        if (this.hours != 0L || this.minutes != 0L || this.seconds != 0L || this.nanoseconds != 0) {
            buf.append('T');
        } else if (this.days == 0L) {
            buf.append("0D");
        }
        if (this.hours != 0L) {
            buf.append(Long.toString(this.hours));
            buf.append('H');
        }
        if (this.minutes != 0L) {
            buf.append(Long.toString(this.minutes));
            buf.append('M');
        }
        if (this.seconds != 0L || this.nanoseconds != 0) {
            buf.append(Long.toString(this.seconds));
            if (this.nanoseconds != 0) {
                buf.append('.');
                buf.append(DateAttribute.zeroPadInt(this.nanoseconds, 9));
            }
            buf.append('S');
        }
        this.encodedValue = buf.toString();
        return this.encodedValue;
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
        big24 = BigInteger.valueOf(24L);
        big60 = BigInteger.valueOf(60L);
        big1000 = BigInteger.valueOf(1000L);
        bigMaxLong = BigInteger.valueOf(Long.MAX_VALUE);
    }
}

