/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.attr;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.wso2.balana.Indenter;
import org.wso2.balana.cond.Evaluatable;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.ctx.EvaluationCtx;

public abstract class AttributeValue
implements Evaluatable {
    private URI type;

    protected AttributeValue(URI type) {
        this.type = type;
    }

    public URI getType() {
        return this.type;
    }

    public final boolean returnsBag() {
        return this.isBag();
    }

    public final boolean evaluatesToBag() {
        return this.isBag();
    }

    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public boolean isBag() {
        return false;
    }

    public EvaluationResult evaluate(EvaluationCtx context) {
        return new EvaluationResult(this);
    }

    public abstract String encode();

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        out.println(indenter.makeString() + this.encodeWithTags(true));
    }

    public String encodeWithTags(boolean includeType) {
        if (includeType && this.type != null) {
            return "<AttributeValue DataType=\"" + this.type.toString() + "\">" + this.encode() + "</AttributeValue>";
        }
        return "<AttributeValue>" + this.encode() + "</AttributeValue>";
    }
}

