/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml2;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.AbstractObligation;
import org.wso2.balana.Indenter;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.UnknownIdentifierException;
import org.wso2.balana.attr.AttributeFactory;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.ctx.Attribute;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.xacml2.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Obligation
extends AbstractObligation
implements ObligationResult {
    private List<Attribute> assignments;

    public Obligation(URI obligationId, int fulfillOn, List<Attribute> assignments) {
        this.obligationId = obligationId;
        this.fulfillOn = fulfillOn;
        this.assignments = Collections.unmodifiableList(new ArrayList<Attribute>(assignments));
    }

    public static Obligation getInstance(Node root) throws ParsingException {
        int fulfillOn;
        String effect;
        URI id;
        ArrayList<Attribute> assignments = new ArrayList<Attribute>();
        AttributeFactory attrFactory = AttributeFactory.getInstance();
        NamedNodeMap attrs = root.getAttributes();
        try {
            id = new URI(attrs.getNamedItem("ObligationId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute ObligationId", e);
        }
        try {
            effect = attrs.getNamedItem("FulfillOn").getNodeValue();
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute FulfillOn", e);
        }
        if (effect.equals("Permit")) {
            fulfillOn = 0;
        } else if (effect.equals("Deny")) {
            fulfillOn = 1;
        } else {
            throw new ParsingException("Invalid Effect type: " + effect);
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("AttributeAssignment")) continue;
            try {
                URI attrId = new URI(node.getAttributes().getNamedItem("AttributeId").getNodeValue());
                AttributeValue attrValue = attrFactory.createValue(node);
                assignments.add(new Attribute(attrId, null, null, attrValue, 2));
                continue;
            }
            catch (URISyntaxException use) {
                throw new ParsingException("Error parsing URI", use);
            }
            catch (UnknownIdentifierException uie) {
                throw new ParsingException("Unknown AttributeId", uie);
            }
            catch (Exception e) {
                throw new ParsingException("Error parsing attribute assignments", e);
            }
        }
        return new Obligation(id, fulfillOn, assignments);
    }

    @Override
    public ObligationResult evaluate(EvaluationCtx ctx) {
        return new Obligation(this.obligationId, this.fulfillOn, this.assignments);
    }

    public URI getId() {
        return this.obligationId;
    }

    public List<Attribute> getAssignments() {
        return this.assignments;
    }

    @Override
    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(indent + "<Obligation ObligationId=\"" + this.obligationId.toString() + "\" FulfillOn=\"" + Result.DECISIONS[this.fulfillOn] + "\">");
        indenter.in();
        for (Attribute assignment : this.assignments) {
            out.println(indenter.makeString() + "<AttributeAssignment AttributeId=\"" + assignment.getId().toString() + "\" DataType=\"" + assignment.getType().toString() + "\">" + assignment.getValue().encode() + "</AttributeAssignment>");
        }
        indenter.out();
        out.println(indent + "</Obligation>");
    }
}

