/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx.xacml2;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.Indenter;
import org.wso2.balana.ParsingException;
import org.wso2.balana.ctx.AbstractRequestCtx;
import org.wso2.balana.ctx.Attribute;
import org.wso2.balana.ctx.xacml2.Subject;
import org.wso2.balana.xacml3.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestCtx
extends AbstractRequestCtx {
    private String resourceContent;
    private Set<Subject> subjects = null;
    private Set resource = null;
    private Set action = null;
    private Set environment = null;

    public RequestCtx(Set<Attributes> attributesSet, Node documentRoot) {
        this(attributesSet, documentRoot, null);
    }

    public RequestCtx(Set<Attributes> attributesSet, Node documentRoot, int version) {
        this(attributesSet, documentRoot, null);
    }

    public RequestCtx(Set<Attributes> attributesSet, String resourceContent) {
        this(attributesSet, null, resourceContent);
    }

    public RequestCtx(Set<Attributes> attributesSet, Node documentRoot, String resourceContent) throws IllegalArgumentException {
        this.attributesSet = attributesSet;
        this.documentRoot = documentRoot;
        this.resourceContent = resourceContent;
        this.xacmlVersion = 2;
    }

    public RequestCtx(Set<Subject> subjects, Set<Attribute> resource, Set<Attribute> action, Set<Attribute> environment) throws IllegalArgumentException {
        this(null, null, subjects, resource, action, environment, null);
    }

    public RequestCtx(Set<Attributes> attributesSet, Node documentRoot, Set<Subject> subjects, Set<Attribute> resource, Set<Attribute> action, Set<Attribute> environment, String resourceContent) throws IllegalArgumentException {
        this.attributesSet = attributesSet;
        this.documentRoot = documentRoot;
        this.subjects = subjects;
        this.resource = resource;
        this.action = action;
        this.environment = environment;
        this.resourceContent = resourceContent;
        this.xacmlVersion = 2;
    }

    public static RequestCtx getInstance(Node root) throws ParsingException {
        HashSet<Subject> newSubjects = new HashSet<Subject>();
        HashSet<Attributes> attributesSet = new HashSet<Attributes>();
        Node content = null;
        Set<Attribute> newResource = null;
        Set<Attribute> newAction = null;
        Set<Attribute> newEnvironment = null;
        String tagName = root.getNodeName();
        if (!tagName.equals("Request")) {
            throw new ParsingException("Request cannot be constructed using type: " + root.getNodeName());
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            String tag = node.getNodeName();
            if (tag.equals("Subject")) {
                Node catNode = node.getAttributes().getNamedItem("SubjectCategory");
                URI category = null;
                if (catNode != null) {
                    try {
                        category = new URI(catNode.getNodeValue());
                    }
                    catch (Exception e) {
                        throw new ParsingException("Invalid Category URI", e);
                    }
                }
                Set<Attribute> attributes = RequestCtx.parseAttributes(node);
                newSubjects.add(new Subject(category, attributes));
                attributesSet.add(new Attributes(category, null, attributes, null));
                if (newSubjects.size() >= 1) continue;
                throw new ParsingException("Request must a contain subject");
            }
            if (tag.equals("Resource")) {
                NodeList nodes = node.getChildNodes();
                for (int j = 0; j < nodes.getLength(); ++j) {
                    Node child = nodes.item(j);
                    if (!node.getNodeName().equals("ResourceContent")) continue;
                    if (content != null) {
                        throw new ParsingException("Too many resource content elements are defined.");
                    }
                    content = node;
                }
                newResource = RequestCtx.parseAttributes(node);
                attributesSet.add(new Attributes(null, content, newResource, null));
                continue;
            }
            if (tag.equals("Action")) {
                newAction = RequestCtx.parseAttributes(node);
                attributesSet.add(new Attributes(null, content, newAction, null));
                continue;
            }
            if (!tag.equals("Environment")) continue;
            newEnvironment = RequestCtx.parseAttributes(node);
            attributesSet.add(new Attributes(null, content, newEnvironment, null));
        }
        if (newEnvironment == null) {
            newEnvironment = new HashSet<Attribute>();
            attributesSet.add(new Attributes(null, content, newEnvironment, null));
        }
        return new RequestCtx(attributesSet, root, newSubjects, newResource, newAction, newEnvironment, null);
    }

    private static Set<Attribute> parseAttributes(Node root) throws ParsingException {
        HashSet<Attribute> set = new HashSet<Attribute>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("Attribute")) continue;
            set.add(Attribute.getInstance(node, 2));
        }
        return set;
    }

    public Set getSubjects() {
        return this.subjects;
    }

    public Set getResource() {
        return this.resource;
    }

    public Set getAction() {
        return this.action;
    }

    public Set getEnvironmentAttributes() {
        return this.environment;
    }

    @Override
    public Node getDocumentRoot() {
        return this.documentRoot;
    }

    @Override
    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String topIndent = indenter.makeString();
        out.println(topIndent + "<Request xmlns=\"" + "urn:oasis:names:tc:xacml:2.0:resource:scope" + "\" >");
        indenter.in();
        String indent = indenter.makeString();
        indenter.in();
        for (Subject subject : this.subjects) {
            out.print(indent + "<Subject SubjectCategory=\"" + subject.getCategory().toString() + "\"");
            Set subjectAttrs = subject.getAttributes();
            if (subjectAttrs.size() == 0) {
                out.println("/>");
                continue;
            }
            out.println(">");
            this.encodeAttributes(subjectAttrs, out, indenter);
            out.println(indent + "</Subject>");
        }
        if (this.resource.size() != 0 || this.resourceContent != null) {
            out.println(indent + "<Resource>");
            if (this.resourceContent != null) {
                out.println(indenter.makeString() + "<ResourceContent>" + this.resourceContent + "</ResourceContent>");
            }
            this.encodeAttributes(this.resource, out, indenter);
            out.println(indent + "</Resource>");
        } else {
            out.println(indent + "<Resource/>");
        }
        if (this.action.size() != 0) {
            out.println(indent + "<Action>");
            this.encodeAttributes(this.action, out, indenter);
            out.println(indent + "</Action>");
        } else {
            out.println(indent + "<Action/>");
        }
        if (this.environment.size() != 0) {
            out.println(indent + "<Environment>");
            this.encodeAttributes(this.environment, out, indenter);
            out.println(indent + "</Environment>");
        }
        indenter.out();
        indenter.out();
        out.println(topIndent + "</Request>");
    }

    private void encodeAttributes(Set attributes, PrintStream out, Indenter indenter) {
        for (Attribute attr : attributes) {
            attr.encode(out, indenter);
        }
    }
}

