/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx;

import java.net.URI;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.wso2.balana.PDPConfig;
import org.wso2.balana.attr.BagAttribute;
import org.wso2.balana.attr.DateAttribute;
import org.wso2.balana.attr.DateTimeAttribute;
import org.wso2.balana.attr.TimeAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.ctx.AbstractRequestCtx;
import org.wso2.balana.ctx.EvaluationCtx;

public abstract class BasicEvaluationCtx
implements EvaluationCtx {
    protected DateAttribute currentDate;
    protected TimeAttribute currentTime;
    protected DateTimeAttribute currentDateTime;
    protected boolean useCachedEnvValues = false;
    protected Node requestRoot;
    protected AbstractRequestCtx requestCtx;
    protected PDPConfig pdpConfig;
    private static Log logger = LogFactory.getLog(BasicEvaluationCtx.class);

    public Node getRequestRoot() {
        return this.requestRoot;
    }

    public boolean isSearching() {
        return false;
    }

    public synchronized TimeAttribute getCurrentTime() {
        long millis = this.dateTimeHelper();
        if (this.useCachedEnvValues) {
            return this.currentTime;
        }
        return new TimeAttribute(new Date(millis));
    }

    public synchronized DateAttribute getCurrentDate() {
        long millis = this.dateTimeHelper();
        if (this.useCachedEnvValues) {
            return this.currentDate;
        }
        return new DateAttribute(new Date(millis));
    }

    public synchronized DateTimeAttribute getCurrentDateTime() {
        long millis = this.dateTimeHelper();
        if (this.useCachedEnvValues) {
            return this.currentDateTime;
        }
        return new DateTimeAttribute(new Date(millis));
    }

    public AbstractRequestCtx getRequestCtx() {
        return this.requestCtx;
    }

    public EvaluationResult getAttribute(String contextPath, Node namespaceNode, URI type, String xpathVersion) {
        return null;
    }

    private long dateTimeHelper() {
        if (this.currentTime != null) {
            return -1L;
        }
        Date time = new Date();
        long millis = time.getTime();
        if (!this.useCachedEnvValues) {
            return millis;
        }
        this.currentTime = new TimeAttribute(time);
        this.currentDate = new DateAttribute(new Date(millis));
        this.currentDateTime = new DateTimeAttribute(new Date(millis));
        return -1L;
    }

    protected EvaluationResult callHelper(URI type, URI id, String issuer, URI category) {
        if (this.pdpConfig.getAttributeFinder() != null) {
            return this.pdpConfig.getAttributeFinder().findAttribute(type, id, issuer, category, this);
        }
        if (logger.isWarnEnabled()) {
            logger.warn((Object)"Context tried to invoke AttributeFinder but was not configured with one");
        }
        return new EvaluationResult(BagAttribute.createEmptyBag(type));
    }
}

