/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.cond.BaseFunctionFactory;
import org.wso2.balana.cond.BasicFunctionFactoryProxy;
import org.wso2.balana.cond.Function;
import org.wso2.balana.cond.FunctionFactoryProxy;
import org.wso2.balana.cond.FunctionProxy;
import org.wso2.balana.cond.MapFunctionProxy;
import org.wso2.balana.cond.TimeInRangeFunction;
import org.wso2.balana.cond.cluster.AbsFunctionCluster;
import org.wso2.balana.cond.cluster.AddFunctionCluster;
import org.wso2.balana.cond.cluster.ComparisonFunctionCluster;
import org.wso2.balana.cond.cluster.ConditionBagFunctionCluster;
import org.wso2.balana.cond.cluster.ConditionSetFunctionCluster;
import org.wso2.balana.cond.cluster.DateMathFunctionCluster;
import org.wso2.balana.cond.cluster.DivideFunctionCluster;
import org.wso2.balana.cond.cluster.EqualFunctionCluster;
import org.wso2.balana.cond.cluster.FloorFunctionCluster;
import org.wso2.balana.cond.cluster.GeneralBagFunctionCluster;
import org.wso2.balana.cond.cluster.GeneralSetFunctionCluster;
import org.wso2.balana.cond.cluster.HigherOrderFunctionCluster;
import org.wso2.balana.cond.cluster.LogicalFunctionCluster;
import org.wso2.balana.cond.cluster.MatchFunctionCluster;
import org.wso2.balana.cond.cluster.ModFunctionCluster;
import org.wso2.balana.cond.cluster.MultiplyFunctionCluster;
import org.wso2.balana.cond.cluster.NOfFunctionCluster;
import org.wso2.balana.cond.cluster.NotFunctionCluster;
import org.wso2.balana.cond.cluster.NumericConvertFunctionCluster;
import org.wso2.balana.cond.cluster.RoundFunctionCluster;
import org.wso2.balana.cond.cluster.StringComparingFunctionCluster;
import org.wso2.balana.cond.cluster.StringFunctionCluster;
import org.wso2.balana.cond.cluster.StringNormalizeFunctionCluster;
import org.wso2.balana.cond.cluster.SubtractFunctionCluster;

public class StandardFunctionFactory
extends BaseFunctionFactory {
    private static StandardFunctionFactory targetFactory = null;
    private static StandardFunctionFactory conditionFactory = null;
    private static StandardFunctionFactory generalFactory = null;
    private static Set<Function> targetFunctions = null;
    private static Set<Function> conditionFunctions = null;
    private static Set<Function> generalFunctions = null;
    private static Map<URI, FunctionProxy> targetAbstractFunctions = null;
    private static Map<URI, FunctionProxy> conditionAbstractFunctions = null;
    private static Map<URI, FunctionProxy> generalAbstractFunctions = null;
    private static Set supportedV1Functions;
    private static Set supportedV2Functions;
    private Set supportedFunctions = null;
    private Map supportedAbstractFunctions = null;
    private static Log logger;

    private StandardFunctionFactory(Set supportedFunctions, Map supportedAbstractFunctions) {
        super(supportedFunctions, supportedAbstractFunctions);
        this.supportedFunctions = supportedFunctions;
        this.supportedAbstractFunctions = supportedAbstractFunctions;
    }

    private static void initTargetFunctions() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing standard Target functions");
        }
        targetFunctions = new HashSet<Function>();
        targetFunctions.addAll(new EqualFunctionCluster().getSupportedFunctions());
        targetFunctions.addAll(new LogicalFunctionCluster().getSupportedFunctions());
        targetFunctions.addAll(new NOfFunctionCluster().getSupportedFunctions());
        targetFunctions.addAll(new NotFunctionCluster().getSupportedFunctions());
        targetFunctions.addAll(new ComparisonFunctionCluster().getSupportedFunctions());
        targetFunctions.addAll(new MatchFunctionCluster().getSupportedFunctions());
        targetAbstractFunctions = new HashMap<URI, FunctionProxy>();
    }

    private static void initConditionFunctions() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing standard Condition functions");
        }
        if (targetFunctions == null) {
            StandardFunctionFactory.initTargetFunctions();
        }
        conditionFunctions = new HashSet<Function>(targetFunctions);
        conditionFunctions.add(new TimeInRangeFunction());
        conditionFunctions.addAll(new ConditionBagFunctionCluster().getSupportedFunctions());
        conditionFunctions.addAll(new ConditionSetFunctionCluster().getSupportedFunctions());
        conditionFunctions.addAll(new HigherOrderFunctionCluster().getSupportedFunctions());
        conditionAbstractFunctions = new HashMap<URI, FunctionProxy>(targetAbstractFunctions);
    }

    private static void initGeneralFunctions() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing standard General functions");
        }
        if (conditionFunctions == null) {
            StandardFunctionFactory.initConditionFunctions();
        }
        generalFunctions = new HashSet<Function>(conditionFunctions);
        generalFunctions.addAll(new AddFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new SubtractFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new MultiplyFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new DivideFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new ModFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new AbsFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new RoundFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new FloorFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new DateMathFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new GeneralBagFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new NumericConvertFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new StringNormalizeFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new GeneralSetFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new StringFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new StringComparingFunctionCluster().getSupportedFunctions());
        generalAbstractFunctions = new HashMap<URI, FunctionProxy>(conditionAbstractFunctions);
        try {
            generalAbstractFunctions.put(new URI("urn:oasis:names:tc:xacml:1.0:function:map"), new MapFunctionProxy());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("invalid function name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StandardFunctionFactory getTargetFactory() {
        if (targetFactory != null) return targetFactory;
        Class<StandardFunctionFactory> clazz = StandardFunctionFactory.class;
        synchronized (StandardFunctionFactory.class) {
            if (targetFunctions == null) {
                StandardFunctionFactory.initTargetFunctions();
            }
            if (targetFactory != null) return targetFactory;
            targetFactory = new StandardFunctionFactory(targetFunctions, targetAbstractFunctions);
            // ** MonitorExit[var0] (shouldn't be in output)
            return targetFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StandardFunctionFactory getConditionFactory() {
        if (conditionFactory != null) return conditionFactory;
        Class<StandardFunctionFactory> clazz = StandardFunctionFactory.class;
        synchronized (StandardFunctionFactory.class) {
            if (conditionFunctions == null) {
                StandardFunctionFactory.initConditionFunctions();
            }
            if (conditionFactory != null) return conditionFactory;
            conditionFactory = new StandardFunctionFactory(conditionFunctions, conditionAbstractFunctions);
            // ** MonitorExit[var0] (shouldn't be in output)
            return conditionFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StandardFunctionFactory getGeneralFactory() {
        if (generalFactory != null) return generalFactory;
        Class<StandardFunctionFactory> clazz = StandardFunctionFactory.class;
        synchronized (StandardFunctionFactory.class) {
            if (generalFunctions != null) return generalFactory;
            StandardFunctionFactory.initGeneralFunctions();
            generalFactory = new StandardFunctionFactory(generalFunctions, generalAbstractFunctions);
            // ** MonitorExit[var0] (shouldn't be in output)
            return generalFactory;
        }
    }

    public static Set getStandardFunctions(String xacmlVersion) {
        throw new RuntimeException("This method isn't implemented yet.");
    }

    public static Map getStandardAbstractFunctions(String xacmlVersion) {
        throw new RuntimeException("This method isn't implemented yet.");
    }

    public static FunctionFactoryProxy getNewFactoryProxy() {
        StandardFunctionFactory.getGeneralFactory();
        BaseFunctionFactory newGeneral = new BaseFunctionFactory(generalFunctions, generalAbstractFunctions);
        BaseFunctionFactory newCondition = new BaseFunctionFactory(newGeneral, conditionFunctions, conditionAbstractFunctions);
        BaseFunctionFactory newTarget = new BaseFunctionFactory(newCondition, targetFunctions, targetAbstractFunctions);
        return new BasicFunctionFactoryProxy(newTarget, newCondition, newGeneral);
    }

    public void addFunction(Function function) throws IllegalArgumentException {
        throw new UnsupportedOperationException("a standard factory cannot support new functions");
    }

    public void addAbstractFunction(FunctionProxy proxy, URI identity) throws IllegalArgumentException {
        throw new UnsupportedOperationException("a standard factory cannot support new functions");
    }

    static {
        logger = LogFactory.getLog(StandardFunctionFactory.class);
    }
}

