/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.combine.xacml3;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.ResultFactory;
import org.wso2.balana.Rule;
import org.wso2.balana.combine.RuleCombinerElement;
import org.wso2.balana.combine.RuleCombiningAlgorithm;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.xacml3.Advice;

public class PermitUnlessDenyRuleAlg
extends RuleCombiningAlgorithm {
    public static final String algId = "urn:oasis:names:tc:xacml:3.0:rule-combining-algorithm:permit-unless-deny";
    private static URI identifierURI;
    private static RuntimeException earlyException;

    public PermitUnlessDenyRuleAlg() {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
    }

    public PermitUnlessDenyRuleAlg(URI identifier) {
        super(identifier);
    }

    public AbstractResult combine(EvaluationCtx context, List parameters, List ruleElements) {
        HashSet<ObligationResult> permitObligations = new HashSet<ObligationResult>();
        HashSet<Advice> permitAdvices = new HashSet<Advice>();
        for (Object ruleElement : ruleElements) {
            Rule rule = ((RuleCombinerElement)ruleElement).getRule();
            AbstractResult result = rule.evaluate(context);
            int value = result.getDecision();
            if (value == 1) {
                return result;
            }
            if (value != 0) continue;
            permitObligations.addAll(result.getObligations());
            permitAdvices.addAll(result.getAdvices());
        }
        return ResultFactory.getFactory().getResult(0, permitObligations, permitAdvices, context);
    }

    static {
        try {
            identifierURI = new URI(algId);
        }
        catch (URISyntaxException se) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(se);
        }
    }
}

