/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.combine.xacml3;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.ResultFactory;
import org.wso2.balana.combine.PolicyCombinerElement;
import org.wso2.balana.combine.PolicyCombiningAlgorithm;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.xacml3.Advice;

public class DenyUnlessPermitPolicyAlg
extends PolicyCombiningAlgorithm {
    public static final String algId = "urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:deny-unless-permit";
    private static URI identifierURI;
    private static RuntimeException earlyException;

    public DenyUnlessPermitPolicyAlg() {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
    }

    public AbstractResult combine(EvaluationCtx context, List parameters, List policyElements) {
        HashSet<ObligationResult> denyObligations = new HashSet<ObligationResult>();
        HashSet<Advice> denyAdvices = new HashSet<Advice>();
        for (Object policyElement : policyElements) {
            AbstractPolicy policy = ((PolicyCombinerElement)policyElement).getPolicy();
            AbstractResult result = policy.evaluate(context);
            int value = result.getDecision();
            if (value == 0) {
                return result;
            }
            if (value != 1) continue;
            denyObligations.addAll(result.getObligations());
            denyAdvices.addAll(result.getAdvices());
        }
        return ResultFactory.getFactory().getResult(1, denyObligations, denyAdvices, context);
    }

    static {
        try {
            identifierURI = new URI(algId);
        }
        catch (URISyntaxException se) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(se);
        }
    }
}

