/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.attr;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.wso2.balana.ParsingException;
import org.wso2.balana.UnknownIdentifierException;
import org.wso2.balana.attr.AttributeFactory;
import org.wso2.balana.attr.AttributeProxy;
import org.wso2.balana.attr.AttributeValue;

public class BaseAttributeFactory
extends AttributeFactory {
    private HashMap attributeMap = new HashMap();

    public BaseAttributeFactory() {
    }

    public BaseAttributeFactory(Map attributes) {
        Iterator it = attributes.keySet().iterator();
        while (it.hasNext()) {
            try {
                String id = it.next().toString();
                AttributeProxy proxy = (AttributeProxy)attributes.get(id);
                this.attributeMap.put(id, proxy);
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("an element of the map was not an instance of AttributeProxy");
            }
        }
    }

    public void addDatatype(String id, AttributeProxy proxy) {
        if (this.attributeMap.containsKey(id)) {
            throw new IllegalArgumentException("datatype already exists");
        }
        this.attributeMap.put(id, proxy);
    }

    public Set getSupportedDatatypes() {
        return Collections.unmodifiableSet(this.attributeMap.keySet());
    }

    public AttributeValue createValue(Node root) throws UnknownIdentifierException, ParsingException {
        Node node = root.getAttributes().getNamedItem("DataType");
        return this.createValue(root, node.getNodeValue());
    }

    public AttributeValue createValue(Node root, URI dataType) throws UnknownIdentifierException, ParsingException {
        return this.createValue(root, dataType.toString());
    }

    public AttributeValue createValue(Node root, String type) throws UnknownIdentifierException, ParsingException {
        AttributeProxy proxy = (AttributeProxy)this.attributeMap.get(type);
        if (proxy != null) {
            try {
                return proxy.getInstance(root);
            }
            catch (Exception e) {
                throw new ParsingException("couldn't create " + type + " attribute based on DOM node");
            }
        }
        throw new UnknownIdentifierException("Attributes of type " + type + " aren't supported.");
    }

    public AttributeValue createValue(URI dataType, String value) throws UnknownIdentifierException, ParsingException {
        String type = dataType.toString();
        AttributeProxy proxy = (AttributeProxy)this.attributeMap.get(type);
        if (proxy != null) {
            try {
                return proxy.getInstance(value);
            }
            catch (Exception e) {
                throw new ParsingException("couldn't create " + type + " attribute from input: " + value);
            }
        }
        throw new UnknownIdentifierException("Attributes of type " + type + " aren't supported.");
    }
}

