/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.thrift;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TException;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.entitlement.EntitlementService;
import org.wso2.carbon.identity.entitlement.thrift.EntitlementException;
import org.wso2.carbon.identity.entitlement.thrift.EntitlementService;
import org.wso2.carbon.identity.thrift.authentication.ThriftAuthenticatorService;
import org.wso2.carbon.utils.ThriftSession;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;

public class ThriftEntitlementServiceImpl
extends AbstractAdmin
implements EntitlementService.Iface {
    private static Log log = LogFactory.getLog(ThriftEntitlementServiceImpl.class);
    private static ThriftAuthenticatorService thriftAuthenticatorService;
    private static EntitlementService entitlementService;

    public static void init(ThriftAuthenticatorService authenticatorService) {
        thriftAuthenticatorService = authenticatorService;
        entitlementService = new EntitlementService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getDecision(String request, String sessionId) throws EntitlementException, TException {
        try {
            if (thriftAuthenticatorService != null && entitlementService != null) {
                if (!thriftAuthenticatorService.isAuthenticated(sessionId)) {
                    String authErrorMsg = "User is not authenticated. Please login first.";
                    log.error((Object)authErrorMsg);
                    throw new EntitlementException(authErrorMsg);
                }
                ThriftSession currentSession = thriftAuthenticatorService.getSessionInfo(sessionId);
                CarbonContextHolder carbonContextHolder = CarbonContextHolder.getCurrentCarbonContextHolder();
                carbonContextHolder.startTenantFlow();
                try {
                    this.populateCurrentCarbonContextFromAuthSession(carbonContextHolder, currentSession);
                    String string = entitlementService.getDecision(request);
                    return string;
                }
                finally {
                    carbonContextHolder.endTenantFlow();
                }
            }
            String initErrorMsg = "Thrift Authenticator service or Entitlement service is not initialized.";
            log.error((Object)initErrorMsg);
            throw new EntitlementException(initErrorMsg);
        }
        catch (Exception e) {
            String errorMsg = "Error occurred when invoking the Thrift based Entitlement Service.";
            log.error((Object)errorMsg, (Throwable)e);
            throw new EntitlementException(errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getDecisionByAttributes(String subject, String resource, String action, List<String> environment, String sessionID) throws EntitlementException, TException {
        try {
            if (thriftAuthenticatorService != null && entitlementService != null) {
                if (!thriftAuthenticatorService.isAuthenticated(sessionID)) {
                    String authErrorMsg = "User is not authenticated. Please login first.";
                    log.error((Object)authErrorMsg);
                    throw new EntitlementException(authErrorMsg);
                }
                ThriftSession currentSession = thriftAuthenticatorService.getSessionInfo(sessionID);
                CarbonContextHolder carbonContextHolder = CarbonContextHolder.getCurrentCarbonContextHolder();
                carbonContextHolder.startTenantFlow();
                try {
                    this.populateCurrentCarbonContextFromAuthSession(carbonContextHolder, currentSession);
                    String string = entitlementService.getDecisionByAttributes(subject, resource, action, environment.toArray(new String[environment.size()]));
                    return string;
                }
                finally {
                    carbonContextHolder.endTenantFlow();
                }
            }
            String initErrorMsg = "Thrift Authenticator service or Entitlement service is not initialized.";
            log.error((Object)initErrorMsg);
            throw new EntitlementException(initErrorMsg);
        }
        catch (Exception e) {
            String errorMsg = "Error occurred when invoking the Thrift based Entitlement Service.";
            log.error((Object)errorMsg, (Throwable)e);
            throw new EntitlementException(errorMsg);
        }
    }

    private void populateCurrentCarbonContextFromAuthSession(CarbonContextHolder carbonContextHolder, ThriftSession authSession) {
        CarbonContextHolder storedCarbonCtxHolder = authSession.getSessionCarbonContextHolder();
        carbonContextHolder.setUsername(storedCarbonCtxHolder.getUsername());
        carbonContextHolder.setTenantDomain(storedCarbonCtxHolder.getTenantDomain());
        carbonContextHolder.setTenantId(storedCarbonCtxHolder.getTenantId());
        carbonContextHolder.setProperty("configSystemRegistry", storedCarbonCtxHolder.getProperty("configSystemRegistry"));
        carbonContextHolder.setProperty("governanceSystemRegistry", storedCarbonCtxHolder.getProperty("governanceSystemRegistry"));
        carbonContextHolder.setProperty("configUserRegistry", storedCarbonCtxHolder.getProperty("configUserRegistry"));
        carbonContextHolder.setProperty("governanceUserRegistry", storedCarbonCtxHolder.getProperty("governanceUserRegistry"));
        carbonContextHolder.setProperty("userRealm", storedCarbonCtxHolder.getProperty("userRealm"));
    }
}

