/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.internal;

import java.io.ByteArrayInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class EntitlementServiceInitializer {
    private static Log log = LogFactory.getLog(EntitlementServiceInitializer.class);
    RegistryService registryService;

    public EntitlementServiceInitializer(RegistryService registryService) {
        this.registryService = registryService;
    }

    public void putEntitlementPolicyResourcesToRegistry() throws IdentityException {
        String resourcePath = "/repository/identity/Entitlement/resources/";
        try {
            ByteArrayInputStream inputStream;
            UserRegistry registry = this.registryService.getGovernanceSystemRegistry(-1234);
            Collection policyResourceCollection = registry.newCollection();
            registry.put(resourcePath, (Resource)policyResourceCollection);
            if (!registry.resourceExists(resourcePath + "ruleCombiningAlgorithms")) {
                Resource ruleCombiningAlgorithm = registry.newResource();
                String ruleCombiningAlgorithms = "deny-overrides\npermit-overrides\nfirst-applicable\n";
                inputStream = new ByteArrayInputStream(ruleCombiningAlgorithms.getBytes());
                ruleCombiningAlgorithm.setContent((Object)inputStream);
                registry.put(resourcePath + "ruleCombiningAlgorithms", ruleCombiningAlgorithm);
            }
            if (!registry.resourceExists(resourcePath + "policyCombiningAlgorithms")) {
                Resource policyCombiningAlgorithm = registry.newResource();
                String policyCombiningAlgorithms = "deny-overrides\npermit-overrides\nfirst-applicable\nordered-deny-overrides\nordered-permit-overrides\nonly-one-applicable";
                inputStream = new ByteArrayInputStream(policyCombiningAlgorithms.getBytes());
                policyCombiningAlgorithm.setContent((Object)inputStream);
                registry.put(resourcePath + "policyCombiningAlgorithms", policyCombiningAlgorithm);
            }
            if (!registry.resourceExists(resourcePath + "targetFunctionId")) {
                Resource targetFunctionId = registry.newResource();
                String targetFunctionIds = "matching-with\nat-least-one-matching-with\nat-least-one-matching-reg-ex-with\nmatching-set-with\nmatching-reg-ex-set-with";
                inputStream = new ByteArrayInputStream(targetFunctionIds.getBytes());
                targetFunctionId.setContent((Object)inputStream);
                registry.put(resourcePath + "targetFunctionId", targetFunctionId);
            }
            if (!registry.resourceExists(resourcePath + "ruleFunctionId")) {
                Resource ruleFunctionId = registry.newResource();
                String ruleFunctionIds = "is-in\nat-least-one-member-of\nat-least-one-matching-reg-ex-with\nmatching-set-with\nmatching-reg-ex-set-with";
                inputStream = new ByteArrayInputStream(ruleFunctionIds.getBytes());
                ruleFunctionId.setContent((Object)inputStream);
                registry.put(resourcePath + "ruleFunctionId", ruleFunctionId);
            }
            if (!registry.resourceExists(resourcePath + "functionId")) {
                Resource functionId = registry.newResource();
                String functionIds = "urn:oasis:names:tc:xacml:1.0:function:string-equal\nurn:oasis:names:tc:xacml:1.0:function:string-intersection\nurn:oasis:names:tc:xacml:1.0:function:string-at-least-one-member-of\nurn:oasis:names:tc:xacml:1.0:function:string-union\nurn:oasis:names:tc:xacml:1.0:function:string-subset\nurn:oasis:names:tc:xacml:1.0:function:string-set-equals\nurn:oasis:names:tc:xacml:1.0:function:string-normalize-space\nurn:oasis:names:tc:xacml:1.0:function:string-normalize-to-lower-case\nurn:oasis:names:tc:xacml:1.0:function:string-greater-than\nurn:oasis:names:tc:xacml:1.0:function:string-greater-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:string-less-than\nurn:oasis:names:tc:xacml:1.0:function:string-less-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:string-one-and-only\nurn:oasis:names:tc:xacml:1.0:function:string-bag-size\nurn:oasis:names:tc:xacml:1.0:function:string-is-in\nurn:oasis:names:tc:xacml:1.0:function:string-bag\nurn:oasis:names:tc:xacml:1.0:function:string-regexp-match\nurn:oasis:names:tc:xacml:1.0:function:boolean-equal\nurn:oasis:names:tc:xacml:1.0:function:boolean-one-and-only\nurn:oasis:names:tc:xacml:1.0:function:boolean-bag-size\nurn:oasis:names:tc:xacml:1.0:function:boolean-is-in\nurn:oasis:names:tc:xacml:1.0:function:boolean-bag\nurn:oasis:names:tc:xacml:1.0:function:boolean-intersection\nurn:oasis:names:tc:xacml:1.0:function:boolean-at-least-one-member-of\nurn:oasis:names:tc:xacml:1.0:function:boolean-union\nurn:oasis:names:tc:xacml:1.0:function:boolean-subset\nurn:oasis:names:tc:xacml:1.0:function:boolean-set-equals\nrn:oasis:names:tc:xacml:1.0:function:integer-equal\nurn:oasis:names:tc:xacml:1.0:function:integer-mod\nurn:oasis:names:tc:xacml:1.0:function:integer-abs\nurn:oasis:names:tc:xacml:1.0:function:integer-add\nurn:oasis:names:tc:xacml:1.0:function:integer-divide\nurn:oasis:names:tc:xacml:1.0:function:integer-multiply\nurn:oasis:names:tc:xacml:1.0:function:integer-subtract\nurn:oasis:names:tc:xacml:1.0:function:double-to-integer\nurn:oasis:names:tc:xacml:1.0:function:integer-to-double\nurn:oasis:names:tc:xacml:1.0:function:integer-greater-than\nurn:oasis:names:tc:xacml:1.0:function:integer-greater-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:integer-less-than\nurn:oasis:names:tc:xacml:1.0:function:integer-less-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:integer-one-and-only\nurn:oasis:names:tc:xacml:1.0:function:integer-bag-size\nurn:oasis:names:tc:xacml:1.0:function:integer-is-in\nurn:oasis:names:tc:xacml:1.0:function:integer-bag\nurn:oasis:names:tc:xacml:1.0:function:double-equal\nurn:oasis:names:tc:xacml:1.0:function:date-equal\nurn:oasis:names:tc:xacml:1.0:function:time-equal\nurn:oasis:names:tc:xacml:1.0:function:dateTime-equal\nurn:oasis:names:tc:xacml:1.0:function:dayTimeDuration-equal\nurn:oasis:names:tc:xacml:1.0:function:yearMonthDuration-equal\nurn:oasis:names:tc:xacml:1.0:function:anyURI-equal\nurn:oasis:names:tc:xacml:1.0:function:x500Name-equal\nurn:oasis:names:tc:xacml:1.0:function:rfc822Name-equal\nurn:oasis:names:tc:xacml:1.0:function:hexBinary-equal\nurn:oasis:names:tc:xacml:1.0:function:base64Binary-equal\nurn:oasis:names:tc:xacml:1.0:function:double-add\nurn:oasis:names:tc:xacml:1.0:function:double-subtract\nurn:oasis:names:tc:xacml:1.0:function:double-multiply\nurn:oasis:names:tc:xacml:1.0:function:double-divide\nurn:oasis:names:tc:xacml:1.0:function:double-abs\nurn:oasis:names:tc:xacml:1.0:function:round\nurn:oasis:names:tc:xacml:1.0:function:floor\nurn:oasis:names:tc:xacml:1.0:function:or\nurn:oasis:names:tc:xacml:1.0:function:and\nurn:oasis:names:tc:xacml:1.0:function:n-of\nurn:oasis:names:tc:xacml:1.0:function:not\nurn:oasis:names:tc:xacml:1.0:function:double-greater-than\nurn:oasis:names:tc:xacml:1.0:function:double-greater-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:double-less-than\nurn:oasis:names:tc:xacml:1.0:function:double-less-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:dateTime-add-dayTimeDuration\nurn:oasis:names:tc:xacml:1.0:function:dateTime-add-yearMonthDuration\nurn:oasis:names:tc:xacml:1.0:function:dateTime-subtract-dayTimeDuration\nurn:oasis:names:tc:xacml:1.0:function:dateTime-subtract-\nyearMonthDuration\nurn:oasis:names:tc:xacml:1.0:function:date-add-yearMonthDuration\nurn:oasis:names:tc:xacml:1.0:function:date-subtract-yearMonthDuration\nurn:oasis:names:tc:xacml:1.0:function:time-greater-than\nurn:oasis:names:tc:xacml:1.0:function:time-greater-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:time-less-than\nurn:oasis:names:tc:xacml:1.0:function:time-less-than-or-equal\nurn:oasis:names:tc:xacml:2.0:function:time-in-range\nurn:oasis:names:tc:xacml:1.0:function:dateTime-greater-than\nurn:oasis:names:tc:xacml:1.0:function:dateTime-greater-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:dateTime-less-than\nurn:oasis:names:tc:xacml:1.0:function:dateTime-less-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:date-greater-than\nurn:oasis:names:tc:xacml:1.0:function:date-greater-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:date-less-than\nurn:oasis:names:tc:xacml:1.0:function:date-less-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:double-one-and-only\nurn:oasis:names:tc:xacml:1.0:function:double-bag-size\nurn:oasis:names:tc:xacml:1.0:function:double-is-in\nurn:oasis:names:tc:xacml:1.0:function:double-bag\nurn:oasis:names:tc:xacml:1.0:function:time-one-and-only\nurn:oasis:names:tc:xacml:1.0:function:time-bag-size\nurn:oasis:names:tc:xacml:1.0:function:time-is-in\nurn:oasis:names:tc:xacml:1.0:function:time-bag\nurn:oasis:names:tc:xacml:1.0:function:date-one-and-only\nurn:oasis:names:tc:xacml:1.0:function:date-bag-size\nurn:oasis:names:tc:xacml:1.0:function:date-is-in\nurn:oasis:names:tc:xacml:1.0:function:date-bag\nurn:oasis:names:tc:xacml:1.0:function:dateTime-one-and-only\nurn:oasis:names:tc:xacml:1.0:function:dateTime-bag-size\nurn:oasis:names:tc:xacml:1.0:function:dateTime-is-in\nurn:oasis:names:tc:xacml:1.0:function:dateTime-bag\nurn:oasis:names:tc:xacml:1.0:function:anyURI-one-and-only\nurn:oasis:names:tc:xacml:1.0:function:anyURI-bag-size\nurn:oasis:names:tc:xacml:1.0:function:anyURI-is-in\nurn:oasis:names:tc:xacml:1.0:function:anyURI-bag\nurn:oasis:names:tc:xacml:1.0:function:hexBinary-one-and-only\nurn:oasis:names:tc:xacml:1.0:function:hexBinary-bag-size\nurn:oasis:names:tc:xacml:1.0:function:hexBinary-is-in\nurn:oasis:names:tc:xacml:1.0:function:hexBinary-bag\nurn:oasis:names:tc:xacml:1.0:function:base64Binary-one-and-only\nurn:oasis:names:tc:xacml:1.0:function:base64Binary-bag-size\nurn:oasis:names:tc:xacml:1.0:function:base64Binary-is-in\nurn:oasis:names:tc:xacml:1.0:function:base64Binary-bag\nurn:oasis:names:tc:xacml:1.0:function:dayTimeDuration-one-and-only\nurn:oasis:names:tc:xacml:1.0:function:dayTimeDuration-bag-size\nurn:oasis:names:tc:xacml:1.0:function:dayTimeDuration-is-in\nurn:oasis:names:tc:xacml:1.0:function:dayTimeDuration-bag\nurn:oasis:names:tc:xacml:1.0:function:yearMonthDuration-one-and-only\nurn:oasis:names:tc:xacml:1.0:function:yearMonthDuration-bag-size\nurn:oasis:names:tc:xacml:1.0:function:yearMonthDuration-is-in\nurn:oasis:names:tc:xacml:1.0:function:yearMonthDuration-bag\nurn:oasis:names:tc:xacml:1.0:function:x500Name-one-and-only\nurn:oasis:names:tc:xacml:1.0:function:x500Name-bag-size\nurn:oasis:names:tc:xacml:1.0:function:x500Name-is-in\nurn:oasis:names:tc:xacml:1.0:function:x500Name-bag\nurn:oasis:names:tc:xacml:1.0:function:rfc822Name-one-and-only\nurn:oasis:names:tc:xacml:1.0:function:rfc822Name-bag-size\nurn:oasis:names:tc:xacml:1.0:function:rfc822Name-is-in\nurn:oasis:names:tc:xacml:1.0:function:rfc822Name-bag\nurn:oasis:names:tc:xacml:1.0:function:any-of\nurn:oasis:names:tc:xacml:1.0:function:all-of\nurn:oasis:names:tc:xacml:1.0:function:any-of-any\nurn:oasis:names:tc:xacml:1.0:function:all-of-any\nurn:oasis:names:tc:xacml:1.0:function:any-of-all\nurn:oasis:names:tc:xacml:1.0:function:all-of-all\nurn:oasis:names:tc:xacml:1.0:function:map\nurn:oasis:names:tc:xacml:1.0:function:x500Name-match\nurn:oasis:names:tc:xacml:1.0:function:rfc822Name-match\nurn:oasis:names:tc:xacml:2.0:function:anyURI-regexp-match\nurn:oasis:names:tc:xacml:2.0:function:ipAddress-regexp-match\nurn:oasis:names:tc:xacml:2.0:function:dnsName-regexp-match\nurn:oasis:names:tc:xacml:2.0:function:rfc822Name-regexp-match\nurn:oasis:names:tc:xacml:2.0:function:x500Name-regexp-match\nurn:oasis:names:tc:xacml:1.0:function:xpath-node-count\nurn:oasis:names:tc:xacml:1.0:function:xpath-node-equal\nurn:oasis:names:tc:xacml:1.0:function:xpath-node-match\nurn:oasis:names:tc:xacml:1.0:function:integer-intersection\nurn:oasis:names:tc:xacml:1.0:function:integer-at-least-one-member-of\nurn:oasis:names:tc:xacml:1.0:function:integer-union\nurn:oasis:names:tc:xacml:1.0:function:integer-subset\nurn:oasis:names:tc:xacml:1.0:function:integer-set-equals\nurn:oasis:names:tc:xacml:1.0:function:double-intersection\nurn:oasis:names:tc:xacml:1.0:function:double-at-least-one-member-of\nurn:oasis:names:tc:xacml:1.0:function:double-union\nurn:oasis:names:tc:xacml:1.0:function:double-subset\nurn:oasis:names:tc:xacml:1.0:function:double-set-equals\nurn:oasis:names:tc:xacml:1.0:function:time-intersection\nurn:oasis:names:tc:xacml:1.0:function:time-at-least-one-member-of\nurn:oasis:names:tc:xacml:1.0:function:time-union\nurn:oasis:names:tc:xacml:1.0:function:time-subset\nurn:oasis:names:tc:xacml:1.0:function:time-set-equals\nurn:oasis:names:tc:xacml:1.0:function:date-intersection\nurn:oasis:names:tc:xacml:1.0:function:date-at-least-one-member-of\nurn:oasis:names:tc:xacml:1.0:function:date-union\nurn:oasis:names:tc:xacml:1.0:function:date-subset\nurn:oasis:names:tc:xacml:1.0:function:date-set-equals\nurn:oasis:names:tc:xacml:1.0:function:dateTime-intersection\nurn:oasis:names:tc:xacml:1.0:function:dateTime-at-least-one-member-of\nurn:oasis:names:tc:xacml:1.0:function:dateTime-union\nurn:oasis:names:tc:xacml:1.0:function:dateTime-subset\nurn:oasis:names:tc:xacml:1.0:function:dateTime-set-equals\nurn:oasis:names:tc:xacml:1.0:function:anyURI-intersection\nurn:oasis:names:tc:xacml:1.0:function:anyURI-at-least-one-member-of\nurn:oasis:names:tc:xacml:1.0:function:anyURI-union\nurn:oasis:names:tc:xacml:1.0:function:anyURI-subset\nurn:oasis:names:tc:xacml:1.0:function:anyURI-set-equals\nurn:oasis:names:tc:xacml:1.0:function:hexBinary-intersection\nurn:oasis:names:tc:xacml:1.0:function:hexBinary-at-least-one-member-of\nurn:oasis:names:tc:xacml:1.0:function:hexBinary-union\nurn:oasis:names:tc:xacml:1.0:function:hexBinary-subset\nurn:oasis:names:tc:xacml:1.0:function:hexBinary-set-equals\nurn:oasis:names:tc:xacml:1.0:function:base64Binary-intersection\nurn:oasis:names:tc:xacml:1.0:function:base64Binary-at-least-one-member-\nof\nurn:oasis:names:tc:xacml:1.0:function:base64Binary-union\nurn:oasis:names:tc:xacml:1.0:function:base64Binary-subset\nurn:oasis:names:tc:xacml:1.0:function:base64Binary-set-equals\nurn:oasis:names:tc:xacml:1.0:function:dayTimeDuration-intersection\nurn:oasis:names:tc:xacml:1.0:function:dayTimeDuration-at-least-one-\nmember-of\nurn:oasis:names:tc:xacml:1.0:function:dayTimeDuration-union\nurn:oasis:names:tc:xacml:1.0:function:dayTimeDuration-subset\nurn:oasis:names:tc:xacml:1.0:function:dayTimeDuration-set-equals\nurn:oasis:names:tc:xacml:1.0:function:yearMonthDuration-intersection\nurn:oasis:names:tc:xacml:1.0:function:yearMonthDuration-at-least-one-\nmember-of\nurn:oasis:names:tc:xacml:1.0:function:yearMonthDuration-union\nurn:oasis:names:tc:xacml:1.0:function:yearMonthDuration-subset\nurn:oasis:names:tc:xacml:1.0:function:yearMonthDuration-set-equals\nurn:oasis:names:tc:xacml:1.0:function:x500Name-intersection\nurn:oasis:names:tc:xacml:1.0:function:x500Name-at-least-one-member-of\nurn:oasis:names:tc:xacml:1.0:function:x500Name-union\nurn:oasis:names:tc:xacml:1.0:function:x500Name-subset\nurn:oasis:names:tc:xacml:1.0:function:x500Name-set-equals\nurn:oasis:names:tc:xacml:1.0:function:rfc822Name-intersection\nurn:oasis:names:tc:xacml:1.0:function:rfc822Name-at-least-one-member-of\nurn:oasis:names:tc:xacml:1.0:function:rfc822Name-union\nurn:oasis:names:tc:xacml:1.0:function:rfc822Name-subset\nurn:oasis:names:tc:xacml:1.0:function:rfc822Name-set-equals";
                inputStream = new ByteArrayInputStream(functionIds.getBytes());
                functionId.setContent((Object)inputStream);
                registry.put(resourcePath + "functionId", functionId);
            }
            if (!registry.resourceExists(resourcePath + "matchId")) {
                Resource matchId = registry.newResource();
                String matchIds = "urn:oasis:names:tc:xacml:1.0:function:string-equal\nurn:oasis:names:tc:xacml:1.0:function:integer-equal\nurn:oasis:names:tc:xacml:1.0:function:double-equal\nurn:oasis:names:tc:xacml:1.0:function:date-equal\nurn:oasis:names:tc:xacml:1.0:function:time-equal\nurn:oasis:names:tc:xacml:1.0:function:dateTime-equal\nurn:oasis:names:tc:xacml:1.0:function:dayTimeDuration-equal\nurn:oasis:names:tc:xacml:1.0:function:yearMonthDuration-equal\nurn:oasis:names:tc:xacml:1.0:function:anyURI-equal\nurn:oasis:names:tc:xacml:1.0:function:x500Name-equal\nurn:oasis:names:tc:xacml:1.0:function:rfc822Name-equal\nurn:oasis:names:tc:xacml:1.0:function:hexBinary-equal\nurn:oasis:names:tc:xacml:1.0:function:base64Binary-equal\nurn:oasis:names:tc:xacml:1.0:function:boolean-equal\nurn:oasis:names:tc:xacml:1.0:function:string-regexp-match\nurn:oasis:names:tc:xacml:1.0:function:x500Name-match\nurn:oasis:names:tc:xacml:1.0:function:rfc822Name-match\nurn:oasis:names:tc:xacml:2.0:function:anyURI-regexp-match\nurn:oasis:names:tc:xacml:2.0:function:ipAddress-regexp-match\nurn:oasis:names:tc:xacml:2.0:function:dnsName-regexp-match\nurn:oasis:names:tc:xacml:2.0:function:rfc822Name-regexp-match\nurn:oasis:names:tc:xacml:2.0:function:x500Name-regexp-match\nurn:oasis:names:tc:xacml:1.0:function:xpath-node-match\nurn:oasis:names:tc:xacml:1.0:function:string-less-than\nurn:oasis:names:tc:xacml:1.0:function:string-less-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:integer-less-than\nurn:oasis:names:tc:xacml:1.0:function:integer-less-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:double-less-than\nurn:oasis:names:tc:xacml:1.0:function:double-less-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:time-less-than\nurn:oasis:names:tc:xacml:1.0:function:time-less-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:dateTime-less-than\nurn:oasis:names:tc:xacml:1.0:function:dateTime-less-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:date-less-than\nurn:oasis:names:tc:xacml:1.0:function:date-less-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:string-greater-than\nurn:oasis:names:tc:xacml:1.0:function:string-greater-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:integer-greater-than\nurn:oasis:names:tc:xacml:1.0:function:integer-greater-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:double-greater-than\nurn:oasis:names:tc:xacml:1.0:function:double-greater-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:time-greater-than\nurn:oasis:names:tc:xacml:1.0:function:time-greater-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:dateTime-greater-than\nurn:oasis:names:tc:xacml:1.0:function:dateTime-greater-than-or-equal\nurn:oasis:names:tc:xacml:1.0:function:date-greater-than\nurn:oasis:names:tc:xacml:1.0:function:date-greater-than-or-equal";
                inputStream = new ByteArrayInputStream(matchIds.getBytes());
                matchId.setContent((Object)inputStream);
                registry.put(resourcePath + "matchId", matchId);
            }
            if (!registry.resourceExists(resourcePath + "dataType")) {
                Resource dataType = registry.newResource();
                String dataTypes = "http://www.w3.org/2001/XMLSchema#string\nhttp://www.w3.org/2001/XMLSchema#boolean\nhttp://www.w3.org/2001/XMLSchema#integer\nhttp://www.w3.org/2001/XMLSchema#double\nhttp://www.w3.org/2001/XMLSchema#time\nhttp://www.w3.org/2001/XMLSchema#date\nhttp://www.w3.org/2001/XMLSchema#dateTime\nhttp://www.w3.org/TR/2002/WD-xquery-operators-20020816#dayTimeDuration\nhttp://www.w3.org/TR/2002/WD-xquery-operators-20020816#yearMonthDuration\nhttp://www.w3.org/2001/XMLSchema#anyURI\nhttp://www.w3.org/2001/XMLSchema#hexBinary\nhttp://www.w3.org/2001/XMLSchema#base64Binary\nurn:oasis:names:tc:xacml:1.0:data-type:rfc822Name\nurn:oasis:names:tc:xacml:1.0:data-type:x500Name";
                inputStream = new ByteArrayInputStream(dataTypes.getBytes());
                dataType.setContent((Object)inputStream);
                registry.put(resourcePath + "dataType", dataType);
            }
            if (!registry.resourceExists(resourcePath + "mustBePresent")) {
                Resource mustBePresent = registry.newResource();
                String mustBePresents = "true\nfalse";
                inputStream = new ByteArrayInputStream(mustBePresents.getBytes());
                mustBePresent.setContent((Object)inputStream);
                registry.put(resourcePath + "mustBePresent", mustBePresent);
            }
            if (!registry.resourceExists(resourcePath + "ruleEffect")) {
                Resource ruleEffect = registry.newResource();
                String ruleEffects = "Permit\nDeny";
                inputStream = new ByteArrayInputStream(ruleEffects.getBytes());
                ruleEffect.setContent((Object)inputStream);
                registry.put(resourcePath + "ruleEffect", ruleEffect);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while adding entitlement policy resource", (Throwable)e);
            throw new IdentityException("Error while adding entitlement policy resource", (Throwable)e);
        }
    }
}

