/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.balana.ParsingException;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.BooleanAttribute;
import org.wso2.balana.attr.DateAttribute;
import org.wso2.balana.attr.DateTimeAttribute;
import org.wso2.balana.attr.DoubleAttribute;
import org.wso2.balana.attr.HexBinaryAttribute;
import org.wso2.balana.attr.IntegerAttribute;
import org.wso2.balana.attr.StringAttribute;
import org.wso2.balana.attr.TimeAttribute;
import org.wso2.balana.ctx.Attribute;
import org.wso2.balana.ctx.xacml2.RequestCtx;
import org.wso2.balana.ctx.xacml2.Subject;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.entitlement.dto.AttributeValueDTO;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EntitlementUtil {
    private static Log log = LogFactory.getLog(EntitlementUtil.class);

    public static RequestCtx createXACMLRequestFromAttributes(String subjectName, String subjectId, String resource, String action, String environment) throws Exception {
        HashSet<Subject> subjects = null;
        HashSet<Attribute> resources = null;
        HashSet<Attribute> actions = null;
        HashSet<Attribute> environments = null;
        try {
            subjects = new HashSet<Subject>();
            resources = new HashSet<Attribute>();
            actions = new HashSet<Attribute>();
            environments = new HashSet<Attribute>();
            if (subjectName != null) {
                if (subjectId != null && !"".equals(subjectId)) {
                    subjects.add(new Subject(EntitlementUtil.getAttributes(subjectId, "http://www.w3.org/2001/XMLSchema#string", subjectName)));
                } else {
                    subjects.add(new Subject(EntitlementUtil.getAttributes("urn:oasis:names:tc:xacml:1.0:subject:subject-id", "http://www.w3.org/2001/XMLSchema#string", subjectName)));
                }
            }
            if (resource != null) {
                resources.add(EntitlementUtil.getAttribute("urn:oasis:names:tc:xacml:1.0:resource:resource-id", "http://www.w3.org/2001/XMLSchema#string", resource));
            }
            if (action != null) {
                actions.add(EntitlementUtil.getAttribute("urn:oasis:names:tc:xacml:1.0:action:action-id", "http://www.w3.org/2001/XMLSchema#string", action));
            }
            if (environment != null) {
                environments.add(EntitlementUtil.getAttribute("urn:oasis:names:tc:xacml:1.0:environment:environment-id", "http://www.w3.org/2001/XMLSchema#string", environment));
            }
            return new RequestCtx(subjects, resources, actions, environments);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while building XACML request", (Throwable)e);
            throw new Exception("Error occurred while building XACML request");
        }
    }

    public static String createXACMLRequestAsString(String subjectName, String subjectId, String resource, String action, String environment) throws Exception {
        try {
            RequestCtx request = EntitlementUtil.createXACMLRequestFromAttributes(subjectName, subjectId, resource, action, environment);
            ByteArrayOutputStream requestOut = new ByteArrayOutputStream();
            request.encode((OutputStream)requestOut);
            return requestOut.toString();
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while building XACML request", (Throwable)e);
            throw new Exception("Error occurred while building XACML request");
        }
    }

    private static Set<Attribute> getAttributes(String uri, String type, final String value) throws URISyntaxException {
        HashSet<Attribute> attrs = new HashSet<Attribute>();
        AttributeValue attrValues = new AttributeValue(new URI(type)){

            public String encode() {
                return value;
            }
        };
        Attribute attribute = new Attribute(new URI(uri), null, null, attrValues, 1);
        attrs.add(attribute);
        return attrs;
    }

    private static Attribute getAttribute(String uri, String type, final String value) throws URISyntaxException {
        AttributeValue attrValues = new AttributeValue(new URI(type)){

            public String encode() {
                return value;
            }
        };
        return new Attribute(new URI(uri), null, null, attrValues, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cache getCommonCache(String name) {
        CarbonContextHolder currentContext = CarbonContextHolder.getCurrentCarbonContextHolder();
        currentContext.startTenantFlow();
        try {
            currentContext.setTenantId(-1234);
            Cache cache = CacheManager.getInstance().getCache(name);
            return cache;
        }
        finally {
            currentContext.endTenantFlow();
        }
    }

    public static AttributeValue getAttributeValue(final String value, String type) throws IdentityException {
        try {
            if ("http://www.w3.org/2001/XMLSchema#string".equals(type)) {
                return new StringAttribute(value);
            }
            if ("http://www.w3.org/2001/XMLSchema#integer".equals(type)) {
                return new IntegerAttribute(Long.parseLong(value));
            }
            if ("http://www.w3.org/2001/XMLSchema#boolean".equals(type)) {
                return BooleanAttribute.getInstance((String)value);
            }
            if ("http://www.w3.org/2001/XMLSchema#double".equals(type)) {
                return new DoubleAttribute(Double.parseDouble(value));
            }
            if ("http://www.w3.org/2001/XMLSchema#date".equals(type)) {
                return new DateAttribute(DateFormat.getDateInstance().parse(value));
            }
            if ("http://www.w3.org/2001/XMLSchema#dateTime".equals(type)) {
                return new DateTimeAttribute(DateFormat.getDateInstance().parse(value));
            }
            if ("http://www.w3.org/2001/XMLSchema#time".equals(type)) {
                return TimeAttribute.getInstance((String)value);
            }
            if ("http://www.w3.org/2001/XMLSchema#hexBinary".equals(type)) {
                return new HexBinaryAttribute(value.getBytes());
            }
            return new AttributeValue(new URI(type)){

                public String encode() {
                    return value;
                }
            };
        }
        catch (ParsingException e) {
            throw new IdentityException("Error while creating AttributeValue object for given string value and data type");
        }
        catch (ParseException e) {
            throw new IdentityException("Error while creating AttributeValue object for given string value and data type");
        }
        catch (URISyntaxException e) {
            throw new IdentityException("Error while creating AttributeValue object for given string value and data type");
        }
    }

    public static Document createRequestElement(List<AttributeValueDTO> attributeValueDTOs) throws IdentityException {
        Document doc = EntitlementUtil.createNewDocument();
        Element requestElement = doc.createElement("Request");
        requestElement.setAttribute("xmlns", "urn:oasis:names:tc:xacml:2.0:context:schema:os");
        requestElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        Element resourceElement = doc.createElement("Resource");
        Element subjectElement = doc.createElement("Subject");
        Element actionElement = doc.createElement("Action");
        Element enviornementElement = doc.createElement("Environment");
        if (attributeValueDTOs != null) {
            for (AttributeValueDTO attributeValueDTO : attributeValueDTOs) {
                if ("Resource".equals(attributeValueDTO.getAttributeType())) {
                    resourceElement.appendChild(EntitlementUtil.createRequestAttributeElement(attributeValueDTO, doc));
                }
                if ("Action".equals(attributeValueDTO.getAttributeType())) {
                    actionElement.appendChild(EntitlementUtil.createRequestAttributeElement(attributeValueDTO, doc));
                }
                if ("Subject".equals(attributeValueDTO.getAttributeType())) {
                    subjectElement.appendChild(EntitlementUtil.createRequestAttributeElement(attributeValueDTO, doc));
                }
                if (!"Environment".equals(attributeValueDTO.getAttributeType())) continue;
                enviornementElement.appendChild(EntitlementUtil.createRequestAttributeElement(attributeValueDTO, doc));
            }
        }
        requestElement.appendChild(resourceElement);
        requestElement.appendChild(subjectElement);
        requestElement.appendChild(actionElement);
        requestElement.appendChild(enviornementElement);
        doc.appendChild(requestElement);
        return doc;
    }

    public static Element createRequestAttributeElement(AttributeValueDTO attributeValueDTO, Document doc) {
        Element attributeElement = doc.createElement("Attribute");
        String attributeValue = attributeValueDTO.getAttribute();
        if (attributeValue != null) {
            attributeElement.setAttribute("AttributeId", attributeValueDTO.getAttributeId());
            attributeElement.setAttribute("DataType", attributeValueDTO.getAttributeDataType());
            Element attributeValueElement = doc.createElement("AttributeValue");
            attributeValueElement.setTextContent(attributeValue.trim());
            attributeElement.appendChild(attributeValueElement);
        }
        return attributeElement;
    }

    private static Document createNewDocument() throws IdentityException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilder = docFactory.newDocumentBuilder();
            doc = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IdentityException("While creating Document Object", (Throwable)e);
        }
        return doc;
    }

    public static String getStringFromDocument(Document doc) throws IdentityException {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString().substring(writer.toString().indexOf(62) + 1);
        }
        catch (TransformerException e) {
            throw new IdentityException("While transforming policy element to String", (Throwable)e);
        }
    }

    public static void validatePolicy(PolicyDTO policy) throws IdentityException {
        block7: {
            try {
                if (policy.getPolicy() == null || policy.getPolicy().trim().length() < 1) {
                    return;
                }
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                InputSource inputSource = new InputSource();
                inputSource.setCharacterStream(new StringReader(policy.getPolicy()));
                Document doc = documentBuilder.parse(inputSource);
                Element policyElement = doc.getDocumentElement();
                String policyXMLNS = policyElement.getNamespaceURI();
                Map<String, Schema> schemaMap = EntitlementServiceComponent.getEntitlementConfig().getPolicySchemaMap();
                Schema schema = schemaMap.get(policyXMLNS);
                if (schema != null) {
                    DOMSource domSource = new DOMSource(doc);
                    DOMResult domResult = new DOMResult();
                    Validator validator = schema.newValidator();
                    validator.validate(domSource, domResult);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"XACML Policy validation succeeded with the Schema");
                    }
                    break block7;
                }
                log.error((Object)"Invalid Namespace in policy");
                throw new IdentityException("Invalid Namespace in policy");
            }
            catch (SAXException e) {
                log.error((Object)("XACML Policy validation failed :" + e.getMessage()));
                throw new IdentityException("Invalid policy : " + e.getMessage());
            }
            catch (IOException e) {
                throw new IdentityException(e.getMessage());
            }
            catch (ParserConfigurationException e) {
                throw new IdentityException(e.getMessage());
            }
        }
    }
}

