/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authentication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.authentication.AuthenticationException;
import org.wso2.carbon.identity.authentication.AuthenticationService;
import org.wso2.carbon.identity.authentication.SharedKeyAccessService;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserRealmService;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class AuthenticationServiceImpl
implements AuthenticationService {
    private static Log log = LogFactory.getLog(AuthenticationServiceImpl.class);
    private final SharedKeyAccessService sharedKeyAccessService;
    private final UserRealmService realmService;

    public AuthenticationServiceImpl(SharedKeyAccessService sharedKeyAccessService, UserRealmService realmService) {
        this.sharedKeyAccessService = sharedKeyAccessService;
        this.realmService = realmService;
    }

    @Override
    public boolean authenticate(String username, String password) throws AuthenticationException {
        String tenantLessUsername = MultitenantUtils.getTenantAwareUsername((String)username);
        try {
            UserRealm userRealm;
            int tenantID = -1234;
            if (username.contains("@")) {
                tenantID = this.realmService.getTenantManager().getTenantId(username.substring(username.lastIndexOf("@") + 1));
            }
            if (!(userRealm = this.realmService.getTenantUserRealm(tenantID)).getUserStoreManager().isExistingUser(tenantLessUsername)) {
                throw new AuthenticationException("Invalid User : " + tenantLessUsername, log);
            }
            if (password.equals(this.sharedKeyAccessService.getSharedKey())) {
                return true;
            }
            return userRealm.getUserStoreManager().authenticate(tenantLessUsername, (Object)password);
        }
        catch (UserStoreException e) {
            throw new AuthenticationException("User not authenticated for the given username : " + tenantLessUsername, log);
        }
    }
}

