/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy.finder;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jsr107cache.Cache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.AbstractTarget;
import org.wso2.balana.MatchResult;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.VersionConstraints;
import org.wso2.balana.combine.PolicyCombiningAlgorithm;
import org.wso2.balana.combine.xacml2.DenyOverridesPolicyAlg;
import org.wso2.balana.combine.xacml2.FirstApplicablePolicyAlg;
import org.wso2.balana.combine.xacml2.OnlyOneApplicablePolicyAlg;
import org.wso2.balana.combine.xacml2.OrderedDenyOverridesPolicyAlg;
import org.wso2.balana.combine.xacml2.OrderedPermitOverridesPolicyAlg;
import org.wso2.balana.combine.xacml2.PermitOverridesPolicyAlg;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.finder.PolicyFinder;
import org.wso2.balana.finder.PolicyFinderModule;
import org.wso2.balana.finder.PolicyFinderResult;
import org.wso2.carbon.caching.core.identity.IdentityCacheEntry;
import org.wso2.carbon.caching.core.identity.IdentityCacheKey;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.EntitlementUtil;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pdp.EntitlementEngine;
import org.wso2.carbon.identity.entitlement.policy.PolicyCollection;
import org.wso2.carbon.identity.entitlement.policy.PolicyStoreReader;
import org.wso2.carbon.identity.entitlement.policy.PolicyTarget;

public class RegistryBasedPolicyFinder
extends PolicyFinderModule {
    private static final String DENY_OVERRIDE = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:deny-overrides";
    private static final String PERMIT_OVERRIDE = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:permit-overrides";
    private static final String FIRST_APPLICABLE = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:first-applicable";
    private static final String ONLY_ONE_APPLICABLE = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:only-one-applicable";
    private static final String ORDERED_DENY_OVERRIDE = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:ordered-deny-overrides";
    private static final String ORDERED_PERMIT_OVERRIDE = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:ordered-permit-overrides";
    private static final String DEFAULT_POLICY_COMBINING_ALGO = "deny-overrides";
    private static final String POLICY_COMBINING_ALGO = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:";
    private PolicyStoreReader policyReader;
    private PolicyCollection policies;
    private File schemaFile = null;
    private IdentityCacheKey cacheKey;
    private int tenantId;
    private PolicyTarget[] policyTargets;
    private int cacheValue;
    private int maxInMemoryPolicies;
    private Properties cachingProperties;
    private static Cache entitlementPolicyCache = EntitlementUtil.getCommonCache("ENTITLEMENT_POLICY_CACHE");
    private String globalPolicyCombiningAlgorithm;
    private static Log log = LogFactory.getLog(RegistryBasedPolicyFinder.class);

    public RegistryBasedPolicyFinder(PolicyStoreReader policyReader, int tenantId) {
        this.policyReader = policyReader;
        this.cacheKey = new IdentityCacheKey(tenantId, "");
        this.tenantId = tenantId;
        String schemaName = System.getProperty("com.sun.xacml.PolicySchema");
        if (schemaName != null) {
            this.schemaFile = new File(schemaName);
        }
    }

    public RegistryBasedPolicyFinder(PolicyStoreReader policyReader, int tenantId, String schemaName) {
        this.policyReader = policyReader;
        this.cacheKey = new IdentityCacheKey(tenantId, "");
        this.tenantId = tenantId;
        if (schemaName != null) {
            this.schemaFile = new File(schemaName);
        }
    }

    public boolean isIdReferenceSupported() {
        return true;
    }

    public boolean isRequestSupported() {
        return true;
    }

    public void init(PolicyFinder finder) {
        this.cachingProperties = EntitlementServiceComponent.getEntitlementConfig().getCachingProperties();
        try {
            this.globalPolicyCombiningAlgorithm = this.findPolicyCombiningAlgorithm();
            if (this.globalPolicyCombiningAlgorithm == null) {
                this.globalPolicyCombiningAlgorithm = DEFAULT_POLICY_COMBINING_ALGO;
            }
            PolicyCombiningAlgorithm algorithm = this.getPolicyCombiningAlgorithm(this.globalPolicyCombiningAlgorithm);
            if ("true".equals(this.cachingProperties.getProperty("OnDemandPolicyLoading.Enable"))) {
                this.policyTargets = this.policyReader.readTargets();
                this.maxInMemoryPolicies = 100;
                String maxInMemoryPoliciesValue = this.cachingProperties.getProperty("OnDemandPolicyLoading.MaxPolicyEntries");
                if (maxInMemoryPoliciesValue != null && !"".equals(maxInMemoryPoliciesValue)) {
                    this.maxInMemoryPolicies = Integer.parseInt(maxInMemoryPoliciesValue);
                }
                this.policies = new PolicyCollection(algorithm, this.maxInMemoryPolicies);
            } else {
                AbstractPolicy[] policies = this.policyReader.readPolicies();
                this.policies = new PolicyCollection(algorithm);
                for (AbstractPolicy policy : policies) {
                    if (policy == null || this.policies.addPolicy(policy) || !log.isWarnEnabled()) continue;
                    log.warn((Object)(" Trying to load the same policy multiple times: " + policy.getId()));
                }
            }
            IdentityCacheEntry cacheEntry = (IdentityCacheEntry)entitlementPolicyCache.get((Object)this.cacheKey);
            if (cacheEntry != null) {
                this.cacheValue = cacheEntry.getHashEntry();
            }
            ++this.cacheValue;
            if (this.cacheValue == Integer.MAX_VALUE) {
                this.cacheValue = 0;
            }
            cacheEntry = new IdentityCacheEntry(this.cacheValue);
            entitlementPolicyCache.put((Object)this.cacheKey, (Object)cacheEntry);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Global XACML policy combining algorithm used " + this.globalPolicyCombiningAlgorithm));
            }
        }
        catch (IdentityException e) {
            log.error((Object)"Error while initializing RegistryBasedPolicyFinder", (Throwable)e);
        }
    }

    public PolicyFinderResult findPolicy(URI idReference, int type, VersionConstraints constraints, PolicyMetaData parentMetaData) {
        AbstractPolicy policy;
        IdentityCacheEntry cacheEntry = (IdentityCacheEntry)entitlementPolicyCache.get((Object)this.cacheKey);
        if (cacheEntry != null && cacheEntry.getHashEntry() != this.cacheValue) {
            this.init(new PolicyFinder());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entitlement Policy cache is updated for tenant " + this.tenantId));
            }
            try {
                EntitlementEngine.getInstance(null, this.tenantId).clearDecisionCache(false);
            }
            catch (IdentityException e) {
                log.error((Object)"Decision Cache can not be cleared when Entitlement Policy cache is updated");
            }
            this.cacheValue = cacheEntry.getHashEntry();
        }
        if ((policy = this.policies.getPolicy(idReference.toString(), type, constraints)) == null) {
            return new PolicyFinderResult();
        }
        return new PolicyFinderResult(policy);
    }

    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        try {
            AbstractPolicy policy;
            IdentityCacheEntry cacheEntry = (IdentityCacheEntry)entitlementPolicyCache.get((Object)this.cacheKey);
            if (cacheEntry != null && cacheEntry.getHashEntry() != this.cacheValue) {
                this.init(new PolicyFinder());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Entitlement Policy cache is updated for tenant " + this.tenantId));
                }
                try {
                    EntitlementEngine.getInstance(null, this.tenantId).clearDecisionCache(false);
                }
                catch (IdentityException e) {
                    log.error((Object)"Decision Cache can not be cleared when Entitlement Policy cache is updated");
                }
                this.cacheValue = cacheEntry.getHashEntry();
            }
            if ((policy = "true".equals(this.cachingProperties.getProperty("OnDemandPolicyLoading.Enable")) ? this.findPolicyUsingTarget(context) : this.policies.getPolicy(context)) == null) {
                return new PolicyFinderResult();
            }
            return new PolicyFinderResult(policy);
        }
        catch (EntitlementException e) {
            return new PolicyFinderResult(e.getStatus());
        }
    }

    private AbstractPolicy findPolicyUsingTarget(EvaluationCtx context) throws EntitlementException {
        ArrayList<AbstractPolicy> list = new ArrayList<AbstractPolicy>(this.maxInMemoryPolicies);
        for (PolicyTarget policyTarget : this.policyTargets) {
            if (policyTarget == null) continue;
            if (list.size() >= this.maxInMemoryPolicies) break;
            AbstractTarget target = policyTarget.getTarget();
            MatchResult matchResult = target.match(context);
            int result = matchResult.getResult();
            if (result == 2) {
                log.error((Object)("Error occurred while processing the XACML policy " + policyTarget.getPolicyId()));
                throw new EntitlementException(matchResult.getStatus());
            }
            if (result != 0) continue;
            AbstractPolicy policy = this.policies.getPolicy(policyTarget.getPolicyId());
            if (policy != null) {
                list.add(policy);
            } else {
                try {
                    policy = this.policyReader.readPolicy(policyTarget.getPolicyId());
                }
                catch (IdentityException e) {
                    log.error((Object)("Error occurred while reading XACML Policy " + policyTarget.getPolicyId()));
                }
                if (policy != null) {
                    this.policies.addPolicy(policy);
                    list.add(policy);
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Matching XACML policy found " + policyTarget.getPolicyId()));
        }
        return this.policies.getPolicy(list);
    }

    public List<String> getMatchingPolicies(EvaluationCtx ctx) {
        ArrayList<String> policyIds = new ArrayList<String>();
        ArrayList<PolicyTarget> policyTargets = new ArrayList<PolicyTarget>();
        if (this.policyTargets != null && this.policyTargets.length > 0) {
            policyTargets.addAll(Arrays.asList(this.policyTargets));
        } else {
            LinkedHashMap<String, TreeSet<AbstractPolicy>> policies = this.policies.getPolicies();
            if (policies != null && policies.size() > 0) {
                Set<Map.Entry<String, TreeSet<AbstractPolicy>>> entrySet = policies.entrySet();
                for (Map.Entry<String, TreeSet<AbstractPolicy>> entry : entrySet) {
                    AbstractPolicy policy = entry.getValue().first();
                    PolicyTarget policyTarget = new PolicyTarget();
                    policyTarget.setPolicyId(policy.getId().toString());
                    policyTarget.setTarget(policy.getTarget());
                    policyTargets.add(policyTarget);
                }
            }
        }
        for (PolicyTarget target : policyTargets) {
            MatchResult matchResult = target.getTarget().match(ctx);
            int result = matchResult.getResult();
            if (result != 0) continue;
            policyIds.add(target.getPolicyId());
        }
        return policyIds;
    }

    private PolicyCombiningAlgorithm getPolicyCombiningAlgorithm(String uri) throws IdentityException {
        if (FIRST_APPLICABLE.equals(POLICY_COMBINING_ALGO + uri)) {
            return new FirstApplicablePolicyAlg();
        }
        if (DENY_OVERRIDE.equals(POLICY_COMBINING_ALGO + uri)) {
            return new DenyOverridesPolicyAlg();
        }
        if (PERMIT_OVERRIDE.equals(POLICY_COMBINING_ALGO + uri)) {
            return new PermitOverridesPolicyAlg();
        }
        if (ONLY_ONE_APPLICABLE.equals(POLICY_COMBINING_ALGO + uri)) {
            return new OnlyOneApplicablePolicyAlg();
        }
        if (ORDERED_DENY_OVERRIDE.equals(POLICY_COMBINING_ALGO + uri)) {
            return new OrderedDenyOverridesPolicyAlg();
        }
        if (ORDERED_PERMIT_OVERRIDE.equals(POLICY_COMBINING_ALGO + uri)) {
            return new OrderedPermitOverridesPolicyAlg();
        }
        throw new IdentityException("Unsupported policy algorithm " + uri);
    }

    public String findPolicyCombiningAlgorithm() {
        try {
            return this.policyReader.readPolicyCombiningAlgorithm();
        }
        catch (IdentityException e) {
            log.warn((Object)"Error occurs while finding policy combining algorithm");
            return null;
        }
    }

    public String getGlobalPolicyCombiningAlgorithm() {
        return this.globalPolicyCombiningAlgorithm;
    }
}

