/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.wso2.balana.ParsingException;
import org.wso2.balana.ctx.AbstractRequestCtx;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.EvaluationCtxFactory;
import org.wso2.balana.ctx.RequestCtxFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.entitlement.EntitlementService;
import org.wso2.carbon.identity.entitlement.EntitlementUtil;
import org.wso2.carbon.identity.entitlement.dto.AttributeValueDTO;
import org.wso2.carbon.identity.entitlement.dto.EntitledAttributesDTO;
import org.wso2.carbon.identity.entitlement.dto.EntitledResultSetDTO;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pdp.EntitlementEngine;
import org.wso2.carbon.identity.entitlement.policy.PolicyStore;
import org.wso2.carbon.identity.entitlement.policy.PolicyStoreReader;
import org.wso2.carbon.identity.entitlement.policy.finder.RegistryBasedPolicyFinder;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class PolicySearch {
    private static Log log = LogFactory.getLog(PolicySearch.class);

    public EntitledResultSetDTO getEntitledAttributes(String subjectName, String resourceName, String subjectId, String action, boolean enableChildSearch, boolean useApplicablePolices) throws IdentityException {
        AttributeValueDTO subjectAttributeDTO;
        PolicyStoreReader policyStoreReader;
        ArrayList<PolicyDTO> policyDTOs = new ArrayList<PolicyDTO>();
        boolean hierarchicalResource = false;
        EntitledResultSetDTO resultSetDTO = new EntitledResultSetDTO();
        HashSet<EntitledAttributesDTO> resultSet = new HashSet<EntitledAttributesDTO>();
        EntitlementService entitlementService = new EntitlementService();
        try {
            policyStoreReader = new PolicyStoreReader(new PolicyStore((Registry)EntitlementServiceComponent.getRegistryService().getGovernanceSystemRegistry()));
        }
        catch (RegistryException e) {
            throw new IdentityException("Error while initializing policy store");
        }
        if (useApplicablePolices) {
            List<String> matchingPolicyIds = this.getMatchPolicyIds(subjectName, resourceName, subjectId, action);
            if (matchingPolicyIds != null && matchingPolicyIds.size() > 0) {
                for (String policyId : matchingPolicyIds) {
                    policyDTOs.add(policyStoreReader.readPolicyDTO(policyId));
                }
            } else {
                log.warn((Object)"Matching policies can not be found. Therefore all the policies are evaluated");
                policyDTOs.addAll(Arrays.asList(policyStoreReader.readAllLightPolicyDTOs()));
            }
        } else {
            policyDTOs.addAll(Arrays.asList(policyStoreReader.readAllLightPolicyDTOs()));
        }
        if (subjectName != null && subjectName.trim().length() > 0) {
            subjectAttributeDTO = new AttributeValueDTO();
            subjectAttributeDTO.setAttributeType("Subject");
            subjectAttributeDTO.setAttribute(subjectName);
            subjectAttributeDTO.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
            if (subjectId != null && subjectId.trim().length() > 0) {
                subjectAttributeDTO.setAttributeId(subjectId);
            } else {
                subjectAttributeDTO.setAttributeId("urn:oasis:names:tc:xacml:1.0:subject:subject-id");
            }
        } else {
            throw new IdentityException("Error : subject value can not be null");
        }
        for (PolicyDTO policyDTO : policyDTOs) {
            PolicyDTO dto;
            if (!policyDTO.isActive()) continue;
            PolicyDTO metaDataPolicyDTO = policyStoreReader.readMetaDataPolicyDTO(policyDTO.getPolicyId());
            List<AttributeValueDTO> attributeValueDTOs = Arrays.asList(metaDataPolicyDTO.getPolicyMetaData());
            String[] policyIdRef = policyDTO.getPolicyIdReferences();
            String[] policySetIdRef = policyDTO.getPolicySetIdReferences();
            for (String policyId : policyIdRef) {
                dto = policyStoreReader.readMetaDataPolicyDTO(policyId);
                attributeValueDTOs.addAll(Arrays.asList(dto.getPolicyMetaData()));
            }
            for (String policySetId : policySetIdRef) {
                dto = policyStoreReader.readMetaDataPolicyDTO(policySetId);
                attributeValueDTOs.addAll(Arrays.asList(dto.getPolicyMetaData()));
            }
            if (attributeValueDTOs == null) continue;
            String response = null;
            ArrayList<AttributeValueDTO> actions = new ArrayList<AttributeValueDTO>();
            ArrayList<AttributeValueDTO> resources = new ArrayList<AttributeValueDTO>();
            ArrayList<AttributeValueDTO> requestAttributes = new ArrayList<AttributeValueDTO>();
            if (resourceName != null && resourceName.trim().length() > 0) {
                AttributeValueDTO resourceAttribute = new AttributeValueDTO();
                resourceAttribute.setAttribute(resourceName);
                resourceAttribute.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
                resourceAttribute.setAttributeId("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
                resourceAttribute.setAttributeType("Resource");
                resources.add(resourceAttribute);
                hierarchicalResource = true;
            }
            AttributeValueDTO resourceScopeAttribute = new AttributeValueDTO();
            resourceScopeAttribute.setAttribute("Descendants");
            resourceScopeAttribute.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
            resourceScopeAttribute.setAttributeId("urn:oasis:names:tc:xacml:1.0:resource:scope");
            resourceScopeAttribute.setAttributeType("Resource");
            for (AttributeValueDTO attributeValueDTO : attributeValueDTOs) {
                if ("Environment".equals(attributeValueDTO.getAttributeType())) {
                    requestAttributes.add(attributeValueDTO);
                    attributeValueDTO.setAttributeId("urn:oasis:names:tc:xacml:1.0:environment:environment-id");
                    requestAttributes.add(attributeValueDTO);
                    continue;
                }
                if ("Action".equals(attributeValueDTO.getAttributeType())) {
                    if (action != null && action.trim().length() > 0) {
                        attributeValueDTO.setAttribute(action);
                    }
                    actions.add(attributeValueDTO);
                    attributeValueDTO.setAttributeId("urn:oasis:names:tc:xacml:1.0:action:action-id");
                    actions.add(attributeValueDTO);
                    continue;
                }
                if (!"Resource".equals(attributeValueDTO.getAttributeType()) || hierarchicalResource) continue;
                attributeValueDTO.setAttributeId("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
                resources.add(attributeValueDTO);
            }
            if (resultSetDTO.getMessage() != null) continue;
            for (AttributeValueDTO resource : resources) {
                if (!"Resource".equals(resource.getAttributeType())) continue;
                for (AttributeValueDTO actionAttributeDTO : actions) {
                    int noOfRequests = 1;
                    if (enableChildSearch) {
                        noOfRequests = 0;
                    }
                    while (noOfRequests < 2) {
                        ArrayList<AttributeValueDTO> currentRequestAttributes = new ArrayList<AttributeValueDTO>();
                        for (AttributeValueDTO dto2 : requestAttributes) {
                            currentRequestAttributes.add(dto2);
                        }
                        if (noOfRequests < 1) {
                            currentRequestAttributes.add(resourceScopeAttribute);
                        }
                        currentRequestAttributes.add(subjectAttributeDTO);
                        currentRequestAttributes.add(resource);
                        currentRequestAttributes.add(actionAttributeDTO);
                        Document doc = EntitlementUtil.createRequestElement(currentRequestAttributes);
                        if (doc != null) {
                            String request = EntitlementUtil.getStringFromDocument(doc);
                            try {
                                response = entitlementService.getDecision(request);
                            }
                            catch (Exception e) {
                                throw new IdentityException("Error while searching entitled resources");
                            }
                        }
                        if (response != null) {
                            OMElement omResponse = null;
                            OMElement result = null;
                            OMElement decision = null;
                            try {
                                omResponse = AXIOMUtil.stringToOM((String)response);
                            }
                            catch (XMLStreamException e) {
                                throw new IdentityException("Error while evaluating XACML policy");
                            }
                            if (omResponse != null) {
                                Iterator results = omResponse.getChildrenWithName(new QName("Result"));
                                while (results.hasNext()) {
                                    result = (OMElement)results.next();
                                    if (result == null || (decision = result.getFirstChildWithName(new QName("Decision"))) == null || !"Permit".equals(decision.getText())) continue;
                                    EntitledAttributesDTO dto3 = new EntitledAttributesDTO();
                                    String decisionResource = result.getAttributeValue(new QName("ResourceId"));
                                    dto3.setResourceName(decisionResource);
                                    dto3.setAction(actionAttributeDTO.getAttribute());
                                    resultSet.add(dto3);
                                }
                            }
                        }
                        ++noOfRequests;
                    }
                }
            }
        }
        resultSetDTO.setEntitledAttributesDTOs(resultSet.toArray(new EntitledAttributesDTO[resultSet.size()]));
        return resultSetDTO;
    }

    private List<String> getMatchPolicyIds(String subjectName, String resourceName, String subjectId, String actionName) throws IdentityException {
        Document doc;
        PolicyDTO[] policyDTOs;
        PolicyStoreReader policyStoreReader;
        EntitlementEngine entitlementEngine = null;
        boolean oneAction = false;
        boolean oneResource = false;
        List<String> result = null;
        ArrayList<AttributeValueDTO> requestAttributes = new ArrayList<AttributeValueDTO>();
        ArrayList<AttributeValueDTO> attributeValueDTOs = new ArrayList<AttributeValueDTO>();
        try {
            policyStoreReader = new PolicyStoreReader(new PolicyStore((Registry)EntitlementServiceComponent.getRegistryService().getGovernanceSystemRegistry()));
        }
        catch (RegistryException e) {
            throw new IdentityException("Error while initializing policy store");
        }
        AttributeValueDTO subject = new AttributeValueDTO();
        subject.setAttributeId(subjectId);
        subject.setAttribute(subjectName);
        subject.setAttributeType("Subject");
        subject.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
        requestAttributes.add(subject);
        AttributeValueDTO resource = new AttributeValueDTO();
        resource.setAttributeId("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
        resource.setAttributeType("Resource");
        resource.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
        if (resourceName != null && resourceName.trim().length() > 0) {
            resource.setAttribute(resourceName);
        } else {
            resource.setAttribute("  ");
        }
        requestAttributes.add(resource);
        if (actionName != null && actionName.trim().length() > 0) {
            AttributeValueDTO action = new AttributeValueDTO();
            action.setAttributeId("urn:oasis:names:tc:xacml:1.0:action:action-id");
            action.setAttribute(actionName);
            action.setAttributeType("Action");
            action.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
            requestAttributes.add(action);
            oneAction = true;
        }
        for (PolicyDTO policyDTO : policyDTOs = policyStoreReader.readAllLightPolicyDTOs()) {
            PolicyDTO dto;
            if (!policyDTO.isActive()) continue;
            PolicyDTO metaDataPolicyDTO = policyStoreReader.readMetaDataPolicyDTO(policyDTO.getPolicyId());
            attributeValueDTOs.addAll(Arrays.asList(metaDataPolicyDTO.getPolicyMetaData()));
            String[] policyIdRef = policyDTO.getPolicyIdReferences();
            String[] policySetIdRef = policyDTO.getPolicySetIdReferences();
            for (String policyId : policyIdRef) {
                dto = policyStoreReader.readMetaDataPolicyDTO(policyId);
                attributeValueDTOs.addAll(Arrays.asList(dto.getPolicyMetaData()));
            }
            for (String policySetId : policySetIdRef) {
                dto = policyStoreReader.readMetaDataPolicyDTO(policySetId);
                attributeValueDTOs.addAll(Arrays.asList(dto.getPolicyMetaData()));
            }
        }
        for (AttributeValueDTO dto : attributeValueDTOs) {
            if (!oneAction && "Action".equals(dto.getAttributeType())) {
                dto.setAttributeId("urn:oasis:names:tc:xacml:1.0:action:action-id");
                dto.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
                requestAttributes.add(dto);
            }
            if (!"Environment".equals(dto.getAttributeType())) continue;
            dto.setAttributeId("urn:oasis:names:tc:xacml:1.0:environment:environment-id");
            dto.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
            requestAttributes.add(dto);
        }
        try {
            entitlementEngine = EntitlementEngine.getInstance((Registry)EntitlementServiceComponent.getRegistryService().getGovernanceSystemRegistry(CarbonContext.getCurrentContext().getTenantId()), CarbonContext.getCurrentContext().getTenantId());
        }
        catch (RegistryException e) {
            throw new IdentityException("Entitlement Engine can not be initialized", (Throwable)e);
        }
        RegistryBasedPolicyFinder policyFinder = entitlementEngine.getRegistryModule();
        if (policyFinder != null && (doc = EntitlementUtil.createRequestElement(requestAttributes)) != null) {
            try {
                AbstractRequestCtx requestCtx = RequestCtxFactory.getFactory().getRequestCtx((Node)doc.getDocumentElement());
                EvaluationCtx ctx = EvaluationCtxFactory.getFactory().getEvaluationCtx(requestCtx, entitlementEngine.getPdpConfig());
                result = policyFinder.getMatchingPolicies(ctx);
            }
            catch (ParsingException e) {
                throw new IdentityException("Error while creating XACML Request context", (Throwable)e);
            }
        }
        return result;
    }
}

