/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.entitlement.dto.AttributeValueTreeNodeDTO;
import org.wso2.carbon.identity.entitlement.dto.PolicyAttributeDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.policy.PolicyMetaDataFinderModule;

public class PolicyMetaDataFinder {
    private static Log log = LogFactory.getLog(PolicyMetaDataFinder.class);
    Set<PolicyMetaDataFinderModule> metaDataFinderModules = new HashSet<PolicyMetaDataFinderModule>();
    int tenantId;

    public PolicyMetaDataFinder(int tenantId) {
        this.tenantId = tenantId;
    }

    public void init() {
        Map<PolicyMetaDataFinderModule, Properties> metaDataFinderConfigs = EntitlementServiceComponent.getEntitlementConfig().getPolicyMetaDataFinderModules();
        if (metaDataFinderConfigs != null && !metaDataFinderConfigs.isEmpty()) {
            this.metaDataFinderModules = metaDataFinderConfigs.keySet();
        }
    }

    public Set<PolicyAttributeDTO> getPolicyAttributeValues() {
        HashSet<PolicyAttributeDTO> policyAttributeDTOs = new HashSet<PolicyAttributeDTO>();
        for (PolicyMetaDataFinderModule module : this.metaDataFinderModules) {
            Set<String> preFunctions;
            Map<String, String> ruleFunctionMap;
            PolicyAttributeDTO policyAttributeDTO = new PolicyAttributeDTO();
            Map<String, String> categoryMap = module.getSupportedCategories();
            Set<Map.Entry<String, String>> categories = categoryMap.entrySet();
            for (Map.Entry<String, String> categoryEntry : categories) {
                String message;
                AttributeValueTreeNodeDTO node = null;
                String category = categoryEntry.getKey();
                try {
                    node = module.getAttributeValueData(category);
                }
                catch (Exception e) {
                    message = "Error occurs while finding policy attribute value using module " + module;
                    log.error((Object)message, (Throwable)e);
                }
                if (node == null) continue;
                node.setFullPathSupported(module.isFullPathSupported());
                node.setHierarchicalTree(module.isHierarchicalTree());
                node.setModuleName(module.getModuleName());
                node.setCategoryId(category);
                node.setCategoryUri(categoryEntry.getValue());
                node.setDefaultAttributeDataType(module.getDefaultAttributeDataType(category));
                node.setDefaultAttributeId(module.getDefaultAttributeId(category));
                try {
                    Set<String> dataTypes = module.getAttributeDataTypes(category);
                    if (dataTypes != null) {
                        node.setAttributeDataTypes(dataTypes.toArray(new String[dataTypes.size()]));
                    }
                }
                catch (Exception e) {
                    message = "Error occurs while finding policy attribute data types using module " + module.getModuleName();
                    log.error((Object)message, (Throwable)e);
                }
                try {
                    Set<String> attributeIds = module.getSupportedAttributeIds(category);
                    if (attributeIds != null) {
                        node.setSupportedAttributeIds(attributeIds.toArray(new String[attributeIds.size()]));
                    }
                }
                catch (Exception e) {
                    message = "Error occurs while finding policy attribute Ids using module " + module.getModuleName();
                    log.error((Object)message, (Throwable)e);
                }
                policyAttributeDTO.addNodeDTO(node);
            }
            ArrayList<String> categoryList = new ArrayList<String>();
            for (Map.Entry<String, String> entry : categoryMap.entrySet()) {
                categoryList.add(entry.getKey());
                categoryList.add(entry.getValue());
            }
            policyAttributeDTO.addSupportedCategories(categoryList);
            Map<String, String> targetFunctionMap = module.getSupportedTargetFunctions();
            if (targetFunctionMap != null) {
                ArrayList<String> targetFunctionList = new ArrayList<String>();
                for (Map.Entry<String, String> entry : targetFunctionMap.entrySet()) {
                    targetFunctionList.add(entry.getKey());
                    targetFunctionList.add(entry.getValue());
                }
                policyAttributeDTO.addSupportedTargetFunctions(targetFunctionList);
            }
            if ((ruleFunctionMap = module.getSupportedRuleFunctions()) != null) {
                ArrayList<String> ruleFunctionList = new ArrayList<String>();
                for (Map.Entry<String, String> entry : ruleFunctionMap.entrySet()) {
                    ruleFunctionList.add(entry.getKey());
                    ruleFunctionList.add(entry.getValue());
                }
                policyAttributeDTO.addSupportedRuleFunctions(ruleFunctionList);
            }
            if ((preFunctions = module.getSupportedPreFunctions()) != null) {
                policyAttributeDTO.setSupportedPreFunctions(preFunctions.toArray(new String[preFunctions.size()]));
            }
            policyAttributeDTOs.add(policyAttributeDTO);
        }
        return policyAttributeDTOs;
    }
}

