/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.entitlement.dto.AttributeValueTreeNodeDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.policy.AbstractPolicyMetaDataFinder;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.user.api.UserStoreManager;

public class CarbonPolicyMetaDataFinder
extends AbstractPolicyMetaDataFinder {
    public static final String MODULE_NAME = "Carbon Attribute Finder Module";
    private Registry registry;
    private String[] defaultActions = new String[]{"read", "write", "delete", "edit"};

    @Override
    public void init(Properties properties) throws Exception {
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public AttributeValueTreeNodeDTO getAttributeValueData(String categoryId) throws Exception {
        this.registry = EntitlementServiceComponent.getRegistryService().getSystemRegistry(CarbonContext.getCurrentContext().getTenantId());
        if ("Resource".equals(categoryId)) {
            AttributeValueTreeNodeDTO nodeDTO = new AttributeValueTreeNodeDTO("/");
            this.getChildResources(nodeDTO, "_system");
            return nodeDTO;
        }
        if ("Action".equals(categoryId)) {
            AttributeValueTreeNodeDTO nodeDTO = new AttributeValueTreeNodeDTO("");
            for (String action : this.defaultActions) {
                AttributeValueTreeNodeDTO childNode = new AttributeValueTreeNodeDTO(action);
                nodeDTO.addChildNode(childNode);
            }
            return nodeDTO;
        }
        if ("Subject".equals(categoryId)) {
            AttributeValueTreeNodeDTO nodeDTO = new AttributeValueTreeNodeDTO("");
            int tenantId = CarbonContext.getCurrentContext().getTenantId();
            UserStoreManager userStoreManager = EntitlementServiceComponent.getRealmservice().getTenantUserRealm(tenantId).getUserStoreManager();
            for (String role : userStoreManager.getRoleNames()) {
                if ("wso2.anonymous.role".equals(role)) continue;
                AttributeValueTreeNodeDTO childNode = new AttributeValueTreeNodeDTO(role);
                nodeDTO.addChildNode(childNode);
            }
            return nodeDTO;
        }
        return null;
    }

    private AttributeValueTreeNodeDTO getChildResources(AttributeValueTreeNodeDTO node, String parentResource) throws RegistryException {
        if (this.registry.resourceExists(parentResource)) {
            String[] resourcePath = parentResource.split("/");
            AttributeValueTreeNodeDTO childNode = new AttributeValueTreeNodeDTO(resourcePath[resourcePath.length - 1]);
            node.addChildNode(childNode);
            Resource root = this.registry.get(parentResource);
            if (root instanceof Collection) {
                String[] resources;
                Collection collection = (Collection)root;
                for (String resource : resources = collection.getChildren()) {
                    this.getChildResources(childNode, resource);
                }
            }
        }
        return node;
    }

    @Override
    public boolean isHierarchicalTree() {
        return true;
    }

    @Override
    public Set<String> getSupportedAttributeIds(String category) throws Exception {
        HashSet<String> values = new HashSet<String>();
        if ("Subject".equals(category)) {
            values.add("http://wso2.org/claims/role");
        }
        return values;
    }

    @Override
    public Map<String, String> getSupportedRuleFunctions() {
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.put("greater-than-or-equal-and-less-than-or-equal to", "greater-than-or-equal-and-less-than-or-equal");
        newMap.put("greater-than-and-less-than-or-equal to", "greater-than-and-less-than-or-equal");
        newMap.put("greater-than-or-equal-and-less-than to", "greater-than-or-equal-and-less-than");
        newMap.put("greater-than-and-less-than to", "greater-than-and-less-than");
        newMap.put("greater-than to", "greater-than");
        newMap.put("greater-than-or-equal to", "greater-than-or-equal");
        newMap.put("less-than to", "less-than");
        newMap.put("less-than-or-equal to", "less-than-or-equal");
        newMap.put("equal to", "equal");
        newMap.put("regexp equal to", "regexp-match");
        newMap.put("equal with at least one of", "at-least-one-member-of");
        newMap.put("in", "is-in");
        newMap.put("equal with all of", "set-equals");
        return newMap;
    }

    @Override
    public Map<String, String> getSupportedTargetFunctions() {
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.put("matching to", "equal");
        newMap.put("regexp matching to", "regexp-match");
        return newMap;
    }

    @Override
    public Set<String> getSupportedPreFunctions() {
        HashSet<String> values = new HashSet<String>();
        values.add("is");
        values.add("is not");
        return values;
    }

    @Override
    public Set<String> getAttributeDataTypes(String attributeType) throws Exception {
        HashSet<String> values = new HashSet<String>();
        values.add("http://www.w3.org/2001/XMLSchema#string");
        values.add("http://www.w3.org/2001/XMLSchema#boolean");
        values.add("http://www.w3.org/2001/XMLSchema#integer");
        values.add("http://www.w3.org/2001/XMLSchema#double");
        values.add("http://www.w3.org/2001/XMLSchema#time");
        values.add("http://www.w3.org/2001/XMLSchema#date");
        values.add("urn:oasis:names:tc:xacml:1.0:data-type:x500Name");
        values.add("urn:oasis:names:tc:xacml:2.0:data-type:ipAddress");
        return values;
    }
}

