/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.pdp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsr107cache.Cache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.balana.PDP;
import org.wso2.balana.PDPConfig;
import org.wso2.balana.ParsingException;
import org.wso2.balana.ctx.AbstractRequestCtx;
import org.wso2.balana.ctx.RequestCtxFactory;
import org.wso2.balana.ctx.ResponseCtx;
import org.wso2.balana.ctx.xacml2.RequestCtx;
import org.wso2.balana.finder.AttributeFinder;
import org.wso2.balana.finder.PolicyFinder;
import org.wso2.balana.finder.ResourceFinder;
import org.wso2.balana.finder.impl.CurrentEnvModule;
import org.wso2.balana.finder.impl.SelectorModule;
import org.wso2.carbon.caching.core.identity.IdentityCacheEntry;
import org.wso2.carbon.caching.core.identity.IdentityCacheKey;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.entitlement.EntitlementUtil;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pdp.PolicyDecision;
import org.wso2.carbon.identity.entitlement.pip.CarbonAttributeFinder;
import org.wso2.carbon.identity.entitlement.pip.CarbonResourceFinder;
import org.wso2.carbon.identity.entitlement.pip.PIPExtension;
import org.wso2.carbon.identity.entitlement.policy.PolicyMetaDataFinder;
import org.wso2.carbon.identity.entitlement.policy.PolicyReader;
import org.wso2.carbon.identity.entitlement.policy.PolicyRequestBuilder;
import org.wso2.carbon.identity.entitlement.policy.PolicyResponseBuilder;
import org.wso2.carbon.identity.entitlement.policy.PolicyStore;
import org.wso2.carbon.identity.entitlement.policy.PolicyStoreReader;
import org.wso2.carbon.identity.entitlement.policy.finder.RegistryBasedPolicyFinder;
import org.wso2.carbon.registry.core.Registry;

public class EntitlementEngine {
    private RegistryBasedPolicyFinder registryModule;
    private CarbonAttributeFinder carbonAttributeFinder;
    private CarbonResourceFinder carbonResourceFinder;
    private PolicyMetaDataFinder metaDataFinder;
    private PDP pdp;
    private PDPConfig pdpConfig;
    private int tenantId;
    private int cacheClearingNode = 0;
    private static volatile EntitlementEngine engine;
    private static final Object lock;
    private int pdpDecisionCachingInterval = 60000;
    private static ConcurrentHashMap<String, EntitlementEngine> entitlementEngines;
    private Map<String, PolicyDecision> decisionCache = new ConcurrentHashMap<String, PolicyDecision>();
    private Map<String, PolicyDecision> simpleDecisionCache = new ConcurrentHashMap<String, PolicyDecision>();
    private Cache decisionClearingCache = EntitlementUtil.getCommonCache("XACML_DECISION_CACHE");
    private static Log log;

    public static EntitlementEngine getInstance(Registry registry, int tenantId) throws IdentityException {
        if (!entitlementEngines.containsKey(Integer.toString(tenantId))) {
            entitlementEngines.put(Integer.toString(tenantId), new EntitlementEngine(registry, tenantId));
        }
        return entitlementEngines.get(Integer.toString(tenantId));
    }

    private EntitlementEngine(Registry registry, int tenantId) throws IdentityException {
        PolicyFinder policyFinder = null;
        ResourceFinder resourceFinder = null;
        HashSet<RegistryBasedPolicyFinder> policyModules = null;
        this.tenantId = tenantId;
        policyFinder = new PolicyFinder();
        this.registryModule = new RegistryBasedPolicyFinder(new PolicyStoreReader(new PolicyStore(registry)), tenantId);
        policyModules = new HashSet<RegistryBasedPolicyFinder>();
        policyModules.add(this.registryModule);
        policyFinder.setModules(policyModules);
        resourceFinder = new ResourceFinder();
        PolicyReader.getInstance(null, policyFinder);
        CurrentEnvModule envAttributeModule = new CurrentEnvModule();
        SelectorModule selectorAttributeModule = new SelectorModule();
        AttributeFinder attributeFinder = new AttributeFinder();
        ArrayList<Object> attributeModules = new ArrayList<Object>();
        attributeModules.add(envAttributeModule);
        attributeModules.add(selectorAttributeModule);
        this.carbonAttributeFinder = new CarbonAttributeFinder(tenantId);
        this.carbonAttributeFinder.init();
        attributeModules.add((Object)this.carbonAttributeFinder);
        attributeFinder.setModules(attributeModules);
        this.carbonResourceFinder = new CarbonResourceFinder(tenantId);
        this.carbonResourceFinder.init();
        this.metaDataFinder = new PolicyMetaDataFinder(tenantId);
        this.metaDataFinder.init();
        ArrayList<CarbonResourceFinder> resourceModuleList = new ArrayList<CarbonResourceFinder>();
        resourceModuleList.add(this.carbonResourceFinder);
        resourceFinder.setModules(resourceModuleList);
        Properties properties = EntitlementServiceComponent.getEntitlementConfig().getCachingProperties();
        String cacheEnable = properties.getProperty("DecisionCaching.Enable");
        if ("true".equals(cacheEnable)) {
            String cacheInterval = properties.getProperty("DecisionCaching.CachingInterval");
            if (cacheInterval != null) {
                this.pdpDecisionCachingInterval = Integer.parseInt(cacheInterval);
            }
        } else {
            this.pdpDecisionCachingInterval = -1;
        }
        this.pdpConfig = new PDPConfig(attributeFinder, policyFinder, resourceFinder, true);
        this.pdp = new PDP(this.pdpConfig);
    }

    public String evaluate(Element xamlRequest) throws ParsingException {
        RequestCtx requestCtx = RequestCtx.getInstance((Node)xamlRequest);
        ByteArrayOutputStream responseOutXml = new ByteArrayOutputStream();
        ByteArrayOutputStream requestOutXml = new ByteArrayOutputStream();
        requestCtx.encode((OutputStream)requestOutXml);
        String request = ((Object)requestOutXml).toString();
        try {
            ((OutputStream)requestOutXml).close();
        }
        catch (IOException e) {
            log.error((Object)"Error while closing out put stream of XACML request");
        }
        String response = this.getFromCache(request, false);
        if (response != null) {
            return response;
        }
        ResponseCtx responseCtx = this.pdp.evaluate((AbstractRequestCtx)requestCtx);
        responseCtx.encode((OutputStream)responseOutXml);
        response = ((Object)responseOutXml).toString();
        try {
            ((OutputStream)responseOutXml).close();
        }
        catch (IOException e) {
            log.error((Object)"Error while closing out put stream of XACML response");
        }
        this.addToCache(request, response, false);
        return response;
    }

    public String evaluate(String xacmlRequest) throws IdentityException, ParsingException {
        String xacmlResponse = this.getFromCache(xacmlRequest, false);
        if (xacmlResponse != null) {
            return xacmlResponse;
        }
        Map<PIPExtension, Properties> extensions = EntitlementServiceComponent.getEntitlementConfig().getExtensions();
        if (extensions != null && !extensions.isEmpty()) {
            PolicyRequestBuilder policyRequestBuilder = new PolicyRequestBuilder();
            PolicyResponseBuilder policyResponseBuilder = new PolicyResponseBuilder();
            Element xacmlRequestElement = policyRequestBuilder.getXacmlRequest(xacmlRequest);
            AbstractRequestCtx requestCtx = RequestCtxFactory.getFactory().getRequestCtx((Node)xacmlRequestElement);
            Set<PIPExtension> pipExtensions = extensions.keySet();
            for (PIPExtension pipExtension : pipExtensions) {
                pipExtension.update(requestCtx);
            }
            ResponseCtx responseCtx = this.pdp.evaluate(requestCtx);
            xacmlResponse = policyResponseBuilder.getXacmlResponse(responseCtx);
        } else {
            xacmlResponse = this.pdp.evaluate(xacmlRequest);
        }
        this.addToCache(xacmlRequest, xacmlResponse, false);
        return xacmlResponse;
    }

    public String evaluate(String subject, String resource, String action, String environment) throws Exception {
        String request = (subject != null ? subject : "") + (resource != null ? resource : "") + (action != null ? action : "") + (environment != null ? environment : "");
        String response = this.getFromCache(request, true);
        if (response != null) {
            return response;
        }
        ByteArrayOutputStream requestOut = new ByteArrayOutputStream();
        RequestCtx requestCtx = EntitlementUtil.createXACMLRequestFromAttributes(subject, null, resource, action, environment);
        requestCtx.encode((OutputStream)requestOut);
        response = this.evaluate(requestOut.toString());
        this.addToCache(request, response, true);
        return response;
    }

    public RegistryBasedPolicyFinder getRegistryModule() {
        return this.registryModule;
    }

    public CarbonAttributeFinder getCarbonAttributeFinder() {
        return this.carbonAttributeFinder;
    }

    public PolicyMetaDataFinder getMetaDataFinder() {
        return this.metaDataFinder;
    }

    public CarbonResourceFinder getCarbonResourceFinder() {
        return this.carbonResourceFinder;
    }

    public PDPConfig getPdpConfig() {
        return this.pdpConfig;
    }

    private String getFromCache(String request, boolean simpleCache) {
        if (this.pdpDecisionCachingInterval > 0) {
            IdentityCacheEntry cacheEntry = (IdentityCacheEntry)this.decisionClearingCache.get((Object)new IdentityCacheKey(this.tenantId, ""));
            if (cacheEntry != null && cacheEntry.getHashEntry() != this.cacheClearingNode) {
                this.decisionCache.clear();
                this.simpleDecisionCache.clear();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Decision Cache is cleared for tenant " + this.tenantId));
                }
                this.cacheClearingNode = cacheEntry.getHashEntry();
                return null;
            }
            PolicyDecision decision = simpleCache ? this.simpleDecisionCache.get(request) : this.decisionCache.get(request);
            if (decision != null && decision.getCachedTime() + (long)this.pdpDecisionCachingInterval > Calendar.getInstance().getTimeInMillis()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"PDP Decision Cache Hit");
                }
                return decision.getResponse();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"PDP Decision Cache Miss");
            }
            if (simpleCache) {
                this.simpleDecisionCache.remove(request);
            } else {
                this.decisionCache.remove(request);
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"PDP Decision Caching Disabled");
        }
        return null;
    }

    private void addToCache(String request, String response, boolean simpleCache) {
        if (this.pdpDecisionCachingInterval > 0) {
            PolicyDecision decision = new PolicyDecision();
            decision.setCachedTime(Calendar.getInstance().getTimeInMillis());
            decision.setResponse(response);
            if (simpleCache) {
                this.simpleDecisionCache.put(request, decision);
            } else {
                this.decisionCache.put(request, decision);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"PDP Decision Cache Updated");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"PDP Decision Caching Disabled");
        }
    }

    public void clearDecisionCache(boolean updateAllNodes) {
        this.decisionCache.clear();
        this.simpleDecisionCache.clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Decision Cache is cleared for tenant " + this.tenantId));
        }
        if (updateAllNodes) {
            IdentityCacheKey cacheKey = new IdentityCacheKey(this.tenantId, "");
            IdentityCacheEntry cacheEntry = (IdentityCacheEntry)this.decisionClearingCache.get((Object)cacheKey);
            if (cacheEntry != null) {
                this.cacheClearingNode = cacheEntry.getHashEntry();
            }
            ++this.cacheClearingNode;
            if (this.cacheClearingNode == Integer.MAX_VALUE) {
                this.cacheClearingNode = 0;
            }
            cacheEntry = new IdentityCacheEntry(this.cacheClearingNode);
            this.decisionClearingCache.put((Object)cacheKey, (Object)cacheEntry);
        }
    }

    static {
        lock = new Object();
        entitlementEngines = new ConcurrentHashMap();
        log = LogFactory.getLog(EntitlementEngine.class);
    }
}

