/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.AbstractPolicy;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.entitlement.EntitlementUtil;
import org.wso2.carbon.identity.entitlement.dto.AttributeValueDTO;
import org.wso2.carbon.identity.entitlement.dto.EntitledResultSetDTO;
import org.wso2.carbon.identity.entitlement.dto.PaginatedPolicySetDTO;
import org.wso2.carbon.identity.entitlement.dto.PolicyAttributeDTO;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pdp.EntitlementEngine;
import org.wso2.carbon.identity.entitlement.pip.AbstractPIPAttributeFinder;
import org.wso2.carbon.identity.entitlement.pip.CarbonAttributeFinder;
import org.wso2.carbon.identity.entitlement.pip.CarbonResourceFinder;
import org.wso2.carbon.identity.entitlement.pip.PIPAttributeFinder;
import org.wso2.carbon.identity.entitlement.pip.PIPResourceFinder;
import org.wso2.carbon.identity.entitlement.policy.PolicyAdmin;
import org.wso2.carbon.identity.entitlement.policy.PolicyMetaDataFinder;
import org.wso2.carbon.identity.entitlement.policy.PolicyReader;
import org.wso2.carbon.identity.entitlement.policy.PolicySearch;
import org.wso2.carbon.identity.entitlement.policy.PolicyStore;
import org.wso2.carbon.identity.entitlement.policy.PolicyStoreReader;
import org.wso2.carbon.identity.entitlement.policy.finder.RegistryBasedPolicyFinder;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class EntitlementPolicyAdminService
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(EntitlementPolicyAdminService.class);

    public void addPolicy(PolicyDTO policy) throws IdentityException {
        PolicyAdmin policyAdmin;
        EntitlementEngine entitlementEngine = EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId());
        EntitlementUtil.validatePolicy(policy);
        AbstractPolicy policyObj = PolicyReader.getInstance(null, null).getPolicy(policy.getPolicy());
        if (policyObj != null) {
            policyAdmin = new PolicyAdmin(new PolicyStore(this.getGovernanceUserRegistry()));
            policy.setPolicyId(policyObj.getId().toASCIIString());
            policy.setActive(policy.isActive());
            if (this.getPolicy(policy.getPolicyId()) != null) {
                throw new IdentityException("An Entitlement Policy with the given ID already exists");
            }
        } else {
            throw new IdentityException("Invalid Entitlement Policy");
        }
        policyAdmin.addOrUpdatePolicy(policy);
        entitlementEngine.getRegistryModule().init(null);
        entitlementEngine.clearDecisionCache(true);
    }

    public void addPolicies(PolicyDTO[] policies) throws IdentityException {
        if (policies != null && policies.length > 0) {
            EntitlementEngine entitlementEngine = EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId());
            PolicyAdmin policyAdmin = new PolicyAdmin(new PolicyStore(this.getGovernanceUserRegistry()));
            for (int i = 0; i < policies.length; ++i) {
                PolicyDTO policy = policies[i];
                EntitlementUtil.validatePolicy(policy);
                AbstractPolicy policyObj = PolicyReader.getInstance(null, null).getPolicy(policy.getPolicy());
                if (policyObj != null) {
                    policy.setPolicyId(policyObj.getId().toASCIIString());
                    policy.setActive(policy.isActive());
                    if (this.getPolicy(policy.getPolicyId()) != null) {
                        throw new IdentityException("An Entitlement Policy with the given ID already exists");
                    }
                } else {
                    throw new IdentityException("Invalid Entitlement Policy");
                }
                policyAdmin.addOrUpdatePolicy(policy);
                entitlementEngine.getRegistryModule().init(null);
                entitlementEngine.clearDecisionCache(true);
            }
        } else {
            throw new IdentityException("No valid Entitlement policies provided.");
        }
    }

    public void importPolicyFromRegistry(String policyRegistryPath) throws IdentityException {
        PolicyDTO policyDTO = new PolicyDTO();
        String policy = "";
        BufferedReader bufferedReader = null;
        InputStream inputStream = null;
        String resourceUri = policyRegistryPath.substring(policyRegistryPath.lastIndexOf(58) + 1);
        String registryIdentifier = policyRegistryPath.substring(0, policyRegistryPath.lastIndexOf(58));
        Registry registry = "conf".equals(registryIdentifier) ? this.getConfigSystemRegistry() : this.getGovernanceUserRegistry();
        try {
            String stringLine;
            Resource resource = registry.get(resourceUri);
            inputStream = resource.getContentStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer buffer = new StringBuffer(policy);
            while ((stringLine = bufferedReader.readLine()) != null) {
                buffer.append(stringLine);
            }
            policy = buffer.toString();
            policyDTO.setPolicy(policy.replaceAll(">\\s+<", "><"));
            this.addPolicy(policyDTO);
        }
        catch (RegistryException e) {
            throw new IdentityException("Registry Error occurs while reading policy from registry");
        }
        catch (IOException e) {
            throw new IdentityException("I/O Error occurs while reading policy from registry");
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error occurs while closing inputStream", (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error occurs while closing inputStream", (Throwable)e);
                }
            }
        }
    }

    public PaginatedPolicySetDTO getAllPolicies(String policyTypeFilter, String policySearchString, int pageNumber) throws IdentityException {
        PolicyDTO[] policyDTOs;
        ArrayList<PolicyDTO> policyDTOList = new ArrayList<PolicyDTO>();
        EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId());
        PolicyStoreReader policyReader = new PolicyStoreReader(new PolicyStore(this.getGovernanceUserRegistry()));
        for (PolicyDTO policyDTO : policyDTOs = policyReader.readAllLightPolicyDTOs()) {
            boolean useAttributeFiler = false;
            if (!policyTypeFilter.equals("ALL") && !policyTypeFilter.equals(policyDTO.getPolicyType())) continue;
            if (policySearchString != null && policySearchString.trim().length() > 0) {
                AttributeValueDTO[] attributeValueDTOs;
                PolicyDTO metaDataPolicyDTO = policyReader.readMetaDataPolicyDTO(policyDTO.getPolicyId());
                for (AttributeValueDTO attributeValueDTO : attributeValueDTOs = metaDataPolicyDTO.getPolicyMetaData()) {
                    if (!policySearchString.equals(attributeValueDTO.getAttribute())) continue;
                    useAttributeFiler = true;
                    break;
                }
                if (!useAttributeFiler && policySearchString != null && policySearchString.trim().length() > 0 && policyDTO.getPolicyId().toLowerCase().indexOf(policySearchString.toLowerCase()) == -1) continue;
            }
            policyDTOList.add(policyDTO);
        }
        return this.doPaging(pageNumber, policyDTOList.toArray(new PolicyDTO[policyDTOList.size()]));
    }

    public PolicyDTO getPolicy(String policyId) throws IdentityException {
        PolicyStoreReader policyReader = null;
        EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId());
        policyReader = new PolicyStoreReader(new PolicyStore(this.getGovernanceUserRegistry()));
        return policyReader.readPolicyDTO(policyId);
    }

    public PolicyDTO getLightPolicy(String policyId) throws IdentityException {
        PolicyStoreReader policyReader = null;
        EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId());
        policyReader = new PolicyStoreReader(new PolicyStore(this.getGovernanceUserRegistry()));
        return policyReader.readLightPolicyDTO(policyId);
    }

    public PolicyDTO getMetaDataPolicy(String policyId) throws IdentityException {
        PolicyStoreReader policyReader = null;
        EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId());
        policyReader = new PolicyStoreReader(new PolicyStore(this.getGovernanceUserRegistry()));
        return policyReader.readMetaDataPolicyDTO(policyId);
    }

    public void removePolicy(PolicyDTO policy) throws IdentityException {
        EntitlementEngine entitlementEngine = EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId());
        PolicyAdmin policyAdmin = new PolicyAdmin(new PolicyStore(this.getGovernanceUserRegistry()));
        policyAdmin.removePolicy(policy);
        entitlementEngine.getRegistryModule().init(null);
        entitlementEngine.clearDecisionCache(true);
    }

    public void updatePolicy(PolicyDTO policy) throws IdentityException {
        EntitlementEngine entitlementEngine = EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId());
        EntitlementUtil.validatePolicy(policy);
        PolicyAdmin policyAdmin = new PolicyAdmin(new PolicyStore(this.getGovernanceUserRegistry()));
        if (policy.getPolicyId() != null && policy.getPolicy() == null) {
            policyAdmin.addOrUpdatePolicy(policy);
        } else {
            AbstractPolicy policyObj = PolicyReader.getInstance(null, null).getPolicy(policy.getPolicy());
            if (policyObj == null) {
                throw new IdentityException("Invalid Entitlement Policy");
            }
            policy.setPolicyId(policyObj.getId().toASCIIString());
            policyAdmin.addOrUpdatePolicy(policy);
        }
        entitlementEngine.getRegistryModule().init(null);
        entitlementEngine.clearDecisionCache(true);
    }

    public PolicyAttributeDTO[] getPolicyAttributeValues() throws IdentityException {
        Set<PolicyAttributeDTO> policyAttributeDTOSet = null;
        PolicyMetaDataFinder metaDataFinder = EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId()).getMetaDataFinder();
        policyAttributeDTOSet = metaDataFinder.getPolicyAttributeValues();
        if (policyAttributeDTOSet != null) {
            return policyAttributeDTOSet.toArray(new PolicyAttributeDTO[policyAttributeDTOSet.size()]);
        }
        return null;
    }

    public String[] getEntitlementPolicyDataFromRegistry(String resourceName) throws IdentityException {
        ArrayList<String> entitlementPolicyResources = new ArrayList<String>();
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String stringLine;
            PolicyStore policyStoreAdmin = new PolicyStore((Registry)EntitlementServiceComponent.getRegistryService().getGovernanceSystemRegistry());
            Resource resource = policyStoreAdmin.getEntitlementPolicyResources(resourceName);
            inputStream = resource.getContentStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((stringLine = bufferedReader.readLine()) != null) {
                entitlementPolicyResources.add(stringLine.trim());
            }
        }
        catch (IOException e) {
            throw new IdentityException("Error occurs while reading resource content", (Throwable)e);
        }
        catch (RegistryException e) {
            throw new IdentityException("Error occurs while creating inputStream from registry resource", (Throwable)e);
        }
        catch (IdentityException e) {
            throw new IdentityException("Error occurs while initializing PolicyStore", (Throwable)e);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error occurs while closing inputStream", (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error occurs while closing inputStream", (Throwable)e);
                }
            }
        }
        return entitlementPolicyResources.toArray(new String[entitlementPolicyResources.size()]);
    }

    public String[] getAllPolicyIds() throws IdentityException {
        ArrayList<String> policyIds = new ArrayList<String>();
        PolicyStoreReader policyReader = new PolicyStoreReader(new PolicyStore(this.getGovernanceUserRegistry()));
        for (PolicyDTO policyDTO : policyReader.readAllLightPolicyDTOs()) {
            policyIds.add(policyDTO.getPolicyId());
        }
        return policyIds.toArray(new String[policyIds.size()]);
    }

    public void clearDecisionCache() throws IdentityException {
        EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId()).clearDecisionCache(true);
    }

    public void clearAllAttributeCaches() throws IdentityException {
        CarbonAttributeFinder finder = EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId()).getCarbonAttributeFinder();
        if (finder == null) {
            throw new IdentityException("Can not clear all attribute caches - Carbon Attribute Finder is not initialized");
        }
        finder.clearAttributeCache();
        this.clearDecisionCache();
        Map<PIPAttributeFinder, Properties> designators = EntitlementServiceComponent.getEntitlementConfig().getDesignators();
        if (designators != null && !designators.isEmpty()) {
            Set<PIPAttributeFinder> pipAttributeFinders = designators.keySet();
            for (PIPAttributeFinder pipAttributeFinder : pipAttributeFinders) {
                pipAttributeFinder.clearCache();
            }
        }
    }

    public void clearCarbonAttributeCache() throws IdentityException {
        CarbonAttributeFinder finder = EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId()).getCarbonAttributeFinder();
        if (finder == null) {
            throw new IdentityException("Can not clear attribute cache - Carbon Attribute Finder is not initialized");
        }
        finder.clearAttributeCache();
        this.clearDecisionCache();
        Map<PIPAttributeFinder, Properties> designators = EntitlementServiceComponent.getEntitlementConfig().getDesignators();
        if (designators != null && !designators.isEmpty()) {
            Set<PIPAttributeFinder> pipAttributeFinders = designators.keySet();
            for (PIPAttributeFinder pipAttributeFinder : pipAttributeFinders) {
                if (!(pipAttributeFinder instanceof AbstractPIPAttributeFinder)) continue;
                pipAttributeFinder.clearCache();
            }
        }
    }

    public void clearAttributeFinderCache(String attributeFinder) {
        Map<PIPAttributeFinder, Properties> designators = EntitlementServiceComponent.getEntitlementConfig().getDesignators();
        if (designators != null && !designators.isEmpty()) {
            Set<PIPAttributeFinder> pipAttributeFinders = designators.keySet();
            for (PIPAttributeFinder pipAttributeFinder : pipAttributeFinders) {
                if (!(pipAttributeFinder instanceof AbstractPIPAttributeFinder) || !pipAttributeFinder.getClass().getCanonicalName().equals(attributeFinder)) continue;
                pipAttributeFinder.clearCache();
                break;
            }
        }
    }

    public void clearAttributeFinderCacheByAttributes(String attributeFinder, String[] attributeIds) {
        Map<PIPAttributeFinder, Properties> designators = EntitlementServiceComponent.getEntitlementConfig().getDesignators();
        if (designators != null && !designators.isEmpty()) {
            Set<PIPAttributeFinder> pipAttributeFinders = designators.keySet();
            for (PIPAttributeFinder pipAttributeFinder : pipAttributeFinders) {
                if (!pipAttributeFinder.getClass().getCanonicalName().equals(attributeFinder)) continue;
                pipAttributeFinder.clearCache(attributeIds);
                break;
            }
        }
    }

    public void clearAllResourceCaches() throws IdentityException {
        CarbonResourceFinder finder = EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId()).getCarbonResourceFinder();
        if (finder == null) {
            throw new IdentityException("Can not clear attribute cache - Carbon Attribute Finder is not initialized");
        }
        finder.clearAttributeCache();
        this.clearDecisionCache();
    }

    public void clearCarbonResourceCache() throws IdentityException {
        CarbonResourceFinder finder = EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId()).getCarbonResourceFinder();
        if (finder == null) {
            throw new IdentityException("Can not clear attribute cache - Carbon Attribute Finder is not initialized");
        }
        finder.clearAttributeCache();
        this.clearDecisionCache();
        Map<PIPResourceFinder, Properties> resourceConfigs = EntitlementServiceComponent.getEntitlementConfig().getResourceFinders();
        if (resourceConfigs != null && !resourceConfigs.isEmpty()) {
            Set<PIPResourceFinder> resourceFinders = resourceConfigs.keySet();
            for (PIPResourceFinder pipResourceFinder : resourceFinders) {
                pipResourceFinder.clearCache();
            }
        }
    }

    public void clearResourceFinderCache(String resourceFinder) {
        Map<PIPResourceFinder, Properties> resourceConfigs = EntitlementServiceComponent.getEntitlementConfig().getResourceFinders();
        if (resourceConfigs != null && !resourceConfigs.isEmpty()) {
            Set<PIPResourceFinder> resourceFinders = resourceConfigs.keySet();
            for (PIPResourceFinder pipResourceFinder : resourceFinders) {
                if (!resourceFinder.getClass().getCanonicalName().equals(resourceFinder)) continue;
                pipResourceFinder.clearCache();
                break;
            }
        }
    }

    public void refreshAttributeFinder(String attributeFinder) throws IdentityException {
        Map<PIPAttributeFinder, Properties> designators = EntitlementServiceComponent.getEntitlementConfig().getDesignators();
        if (designators != null && !designators.isEmpty()) {
            Set<Map.Entry<PIPAttributeFinder, Properties>> pipAttributeFinders = designators.entrySet();
            for (Map.Entry<PIPAttributeFinder, Properties> pipAttributeFinder : pipAttributeFinders) {
                if (!pipAttributeFinder.getClass().getCanonicalName().equals(attributeFinder)) continue;
                try {
                    pipAttributeFinder.getKey().init(pipAttributeFinder.getValue());
                    pipAttributeFinder.getKey().clearCache();
                    CarbonAttributeFinder carbonAttributeFinder = EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId()).getCarbonAttributeFinder();
                    carbonAttributeFinder.init();
                    break;
                }
                catch (Exception e) {
                    throw new IdentityException("Error while refreshing attribute finder - " + attributeFinder);
                }
            }
        }
    }

    public void setGlobalPolicyAlgorithm(String policyCombiningAlgorithm) throws IdentityException {
        EntitlementEngine entitlementEngine = EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId());
        PolicyStore policyStore = new PolicyStore(this.getGovernanceUserRegistry());
        policyStore.addPolicyCombiningAlgorithm(policyCombiningAlgorithm);
        entitlementEngine.getRegistryModule().init(null);
        entitlementEngine.clearDecisionCache(true);
    }

    public String getGlobalPolicyAlgorithm() throws IdentityException {
        RegistryBasedPolicyFinder policyFinder = EntitlementEngine.getInstance(this.getGovernanceUserRegistry(), CarbonContext.getCurrentContext().getTenantId()).getRegistryModule();
        if (policyFinder != null) {
            return policyFinder.getGlobalPolicyCombiningAlgorithm();
        }
        return null;
    }

    public EntitledResultSetDTO getEntitledAttributes(String subjectName, String resourceName, String subjectId, String action, boolean enableChildSearch, boolean useApplicablePolices) throws IdentityException {
        if (subjectName == null) {
            throw new IdentityException("Invalid input data - either the userName or roleName should be non-null");
        }
        PolicySearch policySearch = new PolicySearch();
        return policySearch.getEntitledAttributes(subjectName, resourceName, subjectId, action, enableChildSearch, useApplicablePolices);
    }

    private PaginatedPolicySetDTO doPaging(int pageNumber, PolicyDTO[] policySet) {
        int numberOfPages;
        PaginatedPolicySetDTO paginatedPolicySet = new PaginatedPolicySetDTO();
        if (policySet.length == 0) {
            paginatedPolicySet.setPolicySet(new PolicyDTO[0]);
            return paginatedPolicySet;
        }
        String itemsPerPage = ServerConfiguration.getInstance().getFirstProperty("ItemsPerPage");
        int itemsPerPageInt = 50;
        if (itemsPerPage != null) {
            itemsPerPageInt = Integer.parseInt(itemsPerPage);
        }
        if (pageNumber > (numberOfPages = (int)Math.ceil((double)policySet.length / (double)itemsPerPageInt)) - 1) {
            pageNumber = numberOfPages - 1;
        }
        int startIndex = pageNumber * itemsPerPageInt;
        int endIndex = (pageNumber + 1) * itemsPerPageInt;
        PolicyDTO[] returnedPolicySet = new PolicyDTO[itemsPerPageInt];
        int i = startIndex;
        int j = 0;
        while (i < endIndex && i < policySet.length) {
            returnedPolicySet[j] = policySet[i];
            ++i;
            ++j;
        }
        paginatedPolicySet.setPolicySet(returnedPolicySet);
        paginatedPolicySet.setNumberOfPages(numberOfPages);
        return paginatedPolicySet;
    }
}

