/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml3;

import java.io.OutputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.Indenter;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.BagAttribute;
import org.wso2.balana.cond.Evaluatable;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.cond.Expression;
import org.wso2.balana.cond.ExpressionHandler;
import org.wso2.balana.ctx.AttributeAssignment;
import org.wso2.balana.ctx.EvaluationCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeAssignmentExpression {
    private URI attributeId;
    private URI category;
    private String issuer;
    private Expression expression;

    public AttributeAssignmentExpression(URI attributeId, URI category, Expression expression, String issuer) {
        this.attributeId = attributeId;
        this.category = category;
        this.expression = expression;
        this.issuer = issuer;
    }

    public static AttributeAssignmentExpression getInstance(Node root, PolicyMetaData metaData) throws ParsingException {
        URI attributeId;
        URI category = null;
        String issuer = null;
        Expression expression = null;
        if (!root.getNodeName().equals("AttributeAssignmentExpression")) {
            throw new ParsingException("ObligationExpression object cannot be created with root node of type: " + root.getNodeName());
        }
        NamedNodeMap nodeAttributes = root.getAttributes();
        try {
            attributeId = new URI(nodeAttributes.getNamedItem("AttributeId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required AttributeId in AttributeAssignmentExpressionType", e);
        }
        try {
            Node issuerNode;
            Node categoryNode = nodeAttributes.getNamedItem("Category");
            if (categoryNode != null) {
                category = new URI(categoryNode.getNodeValue());
            }
            if ((issuerNode = nodeAttributes.getNamedItem("Issuer")) != null) {
                issuer = issuerNode.getNodeValue();
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing optional attributes in AttributeAssignmentExpressionType", e);
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            expression = ExpressionHandler.parseExpression(children.item(i), metaData, null);
            break;
        }
        if (expression == null) {
            throw new ParsingException("AttributeAssignmentExpression must contain at least one Expression Type");
        }
        return new AttributeAssignmentExpression(attributeId, category, expression, issuer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<AttributeAssignment> evaluate(EvaluationCtx ctx) {
        HashSet<AttributeAssignment> values = new HashSet<AttributeAssignment>();
        EvaluationResult result = ((Evaluatable)this.expression).evaluate(ctx);
        if (result == null || result.indeterminate()) {
            return null;
        }
        AttributeValue attributeValue = result.getAttributeValue();
        if (attributeValue == null) return values;
        if (attributeValue.isBag()) {
            if (((BagAttribute)attributeValue).size() <= 0) return null;
            Iterator iterator = ((BagAttribute)attributeValue).iterator();
            while (iterator.hasNext()) {
                AttributeValue bagValue = (AttributeValue)iterator.next();
                AttributeAssignment assignment = new AttributeAssignment(this.attributeId, bagValue.getType(), this.category, bagValue.encode(), this.issuer);
                values.add(assignment);
            }
            return values;
        } else {
            AttributeAssignment assignment = new AttributeAssignment(this.attributeId, attributeValue.getType(), this.category, attributeValue.encode(), this.issuer);
            values.add(assignment);
        }
        return values;
    }

    public void encode(OutputStream output, Indenter indenter) {
    }
}

