/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx.xacml3;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.Indenter;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyReference;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.xacml3.Advice;
import org.wso2.balana.xacml3.Attributes;
import org.wso2.balana.xacml3.Obligation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result
extends AbstractResult {
    Set<PolicyReference> policyReferences;
    Set<Attributes> attributes;

    public Result(int decision, Status status, Set<ObligationResult> obligationResults, Set<Advice> advices, EvaluationCtx evaluationCtx) throws IllegalArgumentException {
        super(decision, status, obligationResults, advices, evaluationCtx);
    }

    public Result(int decision, Status status, Set<ObligationResult> obligationResults, Set<Advice> advices, Set<PolicyReference> policyReferences, Set<Attributes> attributes) throws IllegalArgumentException {
        super(decision, status, obligationResults, advices, null);
        this.policyReferences = policyReferences;
        this.attributes = attributes;
    }

    public static AbstractResult getInstance(Node root) throws ParsingException {
        int decision = -1;
        Status status = null;
        Set<ObligationResult> obligations = null;
        Set<Advice> advices = null;
        Set<PolicyReference> policyReferences = null;
        HashSet<Attributes> attributes = null;
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("Decision")) {
                String type = node.getFirstChild().getNodeValue();
                for (int j = 0; j < DECISIONS.length; ++j) {
                    if (!DECISIONS[j].equals(type)) continue;
                    decision = j;
                    break;
                }
                if (decision != -1) continue;
                throw new ParsingException("Unknown Decision: " + type);
            }
            if (name.equals("Status")) {
                if (status == null) {
                    status = Status.getInstance(node);
                    continue;
                }
                throw new ParsingException("More than one StatusType defined");
            }
            if (name.equals("Obligations")) {
                if (obligations == null) {
                    obligations = Result.parseObligations(node);
                    continue;
                }
                throw new ParsingException("More than one ObligationsType defined");
            }
            if (name.equals("AssociatedAdvice")) {
                if (advices == null) {
                    advices = Result.parseAdvices(node);
                    continue;
                }
                throw new ParsingException("More than one AssociatedAdviceType defined");
            }
            if (name.equals("PolicyIdentifierList")) {
                if (policyReferences == null) {
                    policyReferences = Result.parsePolicyReferences(node);
                    continue;
                }
                throw new ParsingException("More than one PolicyIdentifierListType defined");
            }
            if (!name.equals("Attributes")) continue;
            if (attributes == null) {
                attributes = new HashSet<Attributes>();
            }
            attributes.add(Attributes.getInstance(node));
        }
        return new Result(decision, status, obligations, advices, policyReferences, attributes);
    }

    private static Set<ObligationResult> parseObligations(Node root) throws ParsingException {
        HashSet<ObligationResult> set = new HashSet<ObligationResult>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("Obligation")) continue;
            set.add(Obligation.getInstance(node));
        }
        if (set.size() == 0) {
            throw new ParsingException("ObligationsType must not be empty");
        }
        return set;
    }

    private static Set<Advice> parseAdvices(Node root) throws ParsingException {
        HashSet<Advice> set = new HashSet<Advice>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("Advice")) continue;
            set.add(Advice.getInstance(node));
        }
        if (set.size() == 0) {
            throw new ParsingException("AssociatedAdviceType must not be empty");
        }
        return set;
    }

    private static Set<PolicyReference> parsePolicyReferences(Node root) throws ParsingException {
        HashSet<PolicyReference> set = new HashSet<PolicyReference>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            set.add(PolicyReference.getInstance(node, null, null));
        }
        return set;
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        indenter.in();
        String indentNext = indenter.makeString();
        out.println(indent + "<Result>");
        if (this.decision == 4 || this.decision == 5 || this.decision == 6) {
            out.println(indentNext + "<Decision>" + DECISIONS[2] + "</Decision>");
        } else {
            out.println(indentNext + "<Decision>" + DECISIONS[this.decision] + "</Decision>");
        }
        if (this.status != null) {
            this.status.encode(output, indenter);
        }
        if (this.obligations != null && this.obligations.size() != 0) {
            out.println(indentNext + "<Obligations>");
            Iterator it = this.obligations.iterator();
            indenter.in();
            while (it.hasNext()) {
                Obligation obligation = (Obligation)it.next();
                obligation.encode(output, indenter);
            }
            indenter.out();
            out.println(indentNext + "</Obligations>");
        }
        indenter.out();
        out.println(indent + "</Result>");
    }
}

