/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx.xacml3;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.Indenter;
import org.wso2.balana.ParsingException;
import org.wso2.balana.ctx.AbstractRequestCtx;
import org.wso2.balana.xacml3.Attributes;
import org.wso2.balana.xacml3.MultiRequests;
import org.wso2.balana.xacml3.RequestDefaults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestCtx
extends AbstractRequestCtx {
    private boolean returnPolicyIdList;
    private boolean combinedDecision;
    private MultiRequests multiRequests;
    private RequestDefaults defaults;

    public RequestCtx(Set<Attributes> attributesSet, Node documentRoot) {
        this(documentRoot, attributesSet, false, false, null, null);
    }

    public RequestCtx(Node documentRoot, Set<Attributes> attributesSet, boolean returnPolicyIdList, boolean combinedDecision, MultiRequests multiRequests, RequestDefaults defaults) throws IllegalArgumentException {
        this.xacmlVersion = 3;
        this.documentRoot = documentRoot;
        this.attributesSet = attributesSet;
        this.returnPolicyIdList = returnPolicyIdList;
        this.combinedDecision = combinedDecision;
        this.multiRequests = multiRequests;
        this.defaults = defaults;
    }

    public static RequestCtx getInstance(Node root) throws ParsingException {
        String attributeValue;
        boolean returnPolicyIdList = false;
        boolean combinedDecision = false;
        MultiRequests multiRequests = null;
        RequestDefaults defaults = null;
        String tagName = root.getNodeName();
        if (!tagName.equals("Request")) {
            throw new ParsingException("Request cannot be constructed using type: " + root.getNodeName());
        }
        NamedNodeMap attrs = root.getAttributes();
        try {
            attributeValue = attrs.getNamedItem("ReturnPolicyIdList").getNodeValue();
            if ("true".equals(attributeValue)) {
                returnPolicyIdList = true;
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute ReturnPolicyIdList in RequestType", e);
        }
        try {
            attributeValue = attrs.getNamedItem("CombinedDecision").getNodeValue();
            if ("true".equals(attributeValue)) {
                combinedDecision = true;
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute CombinedDecision in RequestType", e);
        }
        HashSet<Attributes> attributesElements = new HashSet<Attributes>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            String tag = node.getNodeName();
            if (tag.equals("Attributes")) {
                Attributes attributes = Attributes.getInstance(node);
                attributesElements.add(attributes);
            }
            if (tag.equals("MultiRequests")) {
                if (multiRequests != null) {
                    throw new ParsingException("Too many MultiRequests elements are defined.");
                }
                multiRequests = MultiRequests.getInstance(node);
            }
            if (!tag.equals("RequestDefaults")) continue;
            if (multiRequests != null) {
                throw new ParsingException("Too many RequestDefaults elements are defined.");
            }
            defaults = RequestDefaults.getInstance(node);
        }
        if (attributesElements.isEmpty()) {
            throw new ParsingException("Request must contain at least one AttributesType");
        }
        return new RequestCtx(root, attributesElements, returnPolicyIdList, combinedDecision, multiRequests, defaults);
    }

    public boolean isCombinedDecision() {
        return this.combinedDecision;
    }

    public boolean isReturnPolicyIdList() {
        return this.returnPolicyIdList;
    }

    public MultiRequests getMultiRequests() {
        return this.multiRequests;
    }

    public RequestDefaults getDefaults() {
        return this.defaults;
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        String indent = indenter.makeString();
        PrintStream out = new PrintStream(output);
        out.println(indent + "<Request ReturnPolicyIdList=\"" + this.returnPolicyIdList + "\" CombinedDecision=\"" + this.combinedDecision + "\" >");
        indenter.in();
        for (Attributes attributes : this.attributesSet) {
            attributes.encode(output, indenter);
        }
        if (this.defaults != null) {
            this.defaults.encode(output, indenter);
        }
        if (this.multiRequests != null) {
            // empty if block
        }
        indenter.out();
        out.println(indent + "</Request>");
    }

    @Override
    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }
}

