/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx.xacml2;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.Indenter;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.xacml2.Obligation;
import org.wso2.balana.xacml3.Advice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result
extends AbstractResult {
    private String resourceId = null;

    public Result(int decision, Status status, Set<ObligationResult> obligationResults, Set<Advice> advices, EvaluationCtx evaluationCtx) throws IllegalArgumentException {
        super(decision, status, obligationResults, advices, evaluationCtx);
    }

    public Result(int decision, Status status, Set<ObligationResult> obligationResults, String resourceId) throws IllegalArgumentException {
        super(decision, status, obligationResults, null, null);
        this.resourceId = resourceId;
    }

    public static AbstractResult getInstance(Node root) throws ParsingException {
        int decision = -1;
        Status status = null;
        String resource = null;
        Set<ObligationResult> obligations = null;
        NamedNodeMap attrs = root.getAttributes();
        Node resourceAttr = attrs.getNamedItem("ResourceId");
        if (resourceAttr != null) {
            resource = resourceAttr.getNodeValue();
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("Decision")) {
                String type = node.getFirstChild().getNodeValue();
                for (int j = 0; j < DECISIONS.length; ++j) {
                    if (!DECISIONS[j].equals(type)) continue;
                    decision = j;
                    break;
                }
                if (decision != -1) continue;
                throw new ParsingException("Unknown Decision: " + type);
            }
            if (name.equals("Status")) {
                if (status == null) {
                    status = Status.getInstance(node);
                    continue;
                }
                throw new ParsingException("More than one StatusType defined");
            }
            if (!name.equals("Obligations")) continue;
            if (obligations == null) {
                obligations = Result.parseObligations(node);
                continue;
            }
            throw new ParsingException("More than one ObligationsType defined");
        }
        return new Result(decision, status, obligations, resource);
    }

    private static Set<ObligationResult> parseObligations(Node root) throws ParsingException {
        HashSet<ObligationResult> set = new HashSet<ObligationResult>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("Obligation")) continue;
            set.add(Obligation.getInstance(node));
        }
        if (set.size() == 0) {
            throw new ParsingException("ObligationsType must not be empty");
        }
        return set;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public boolean setResource(String resource) {
        if (this.resourceId != null) {
            return false;
        }
        this.resourceId = resource;
        return true;
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        indenter.in();
        String indentNext = indenter.makeString();
        if (this.resourceId == null) {
            out.println(indent + "<Result>");
        } else {
            out.println(indent + "<Result ResourceId=\"" + this.resourceId + "\">");
        }
        out.println(indentNext + "<Decision>" + DECISIONS[this.decision] + "</Decision>");
        if (this.status != null) {
            this.status.encode(output, indenter);
        }
        if (this.obligations != null && this.obligations.size() != 0) {
            out.println(indentNext + "<Obligations>");
            Iterator it = this.obligations.iterator();
            indenter.in();
            while (it.hasNext()) {
                ObligationResult obligation = (ObligationResult)it.next();
                obligation.encode(output, indenter);
            }
            indenter.out();
            out.println(indentNext + "</Obligations>");
        }
        indenter.out();
        out.println(indent + "</Result>");
    }
}

