/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.ctx;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.wso2.balana.Indenter;
import org.wso2.balana.ParsingException;
import org.wso2.balana.attr.AttributeValue;

public class AttributeAssignment
extends AttributeValue {
    private URI attributeId;
    private URI category;
    private String issuer;
    private String content;

    public AttributeAssignment(URI attributeId, URI dataType, URI category, String content, String issuer) {
        super(dataType);
        this.attributeId = attributeId;
        this.category = category;
        this.issuer = issuer;
        this.content = content;
    }

    public static AttributeAssignment getInstance(Node root) throws ParsingException {
        URI type;
        URI attributeId;
        URI category = null;
        String issuer = null;
        String content = null;
        if (!root.getNodeName().equals("AttributeAssignment")) {
            throw new ParsingException("AttributeAssignment object cannot be created with root node of type: " + root.getNodeName());
        }
        NamedNodeMap nodeAttributes = root.getAttributes();
        try {
            attributeId = new URI(nodeAttributes.getNamedItem("AttributeId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required AttributeId in AttributeAssignmentType", e);
        }
        try {
            type = new URI(nodeAttributes.getNamedItem("DataType").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required AttributeId in AttributeAssignmentType", e);
        }
        try {
            Node issuerNode;
            Node categoryNode = nodeAttributes.getNamedItem("Category");
            if (categoryNode != null) {
                category = new URI(categoryNode.getNodeValue());
            }
            if ((issuerNode = nodeAttributes.getNamedItem("Issuer")) != null) {
                issuer = issuerNode.getNodeValue();
            }
            content = root.getTextContent();
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing optional attributes in AttributeAssignmentType", e);
        }
        return new AttributeAssignment(attributeId, type, category, content, issuer);
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        out.print("<AttributeAssignment  AttributeId=\"" + this.attributeId + "\"");
        out.print(" DataType=\"" + this.getType() + "\"");
        if (this.category != null) {
            out.print(" Category=\"" + this.category + "\"");
        }
        if (this.issuer != null) {
            out.print("\" Issuer=\"" + this.issuer + "\"");
        }
        out.println(">");
        if (this.content != null) {
            out.print(this.content);
        }
        out.print("</AttributeAssignment>");
    }

    public String encode() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.encode(stream);
        return ((Object)stream).toString();
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }
}

