/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.cond;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.StringAttribute;
import org.wso2.balana.cond.Evaluatable;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.cond.FunctionBase;
import org.wso2.balana.ctx.EvaluationCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringFunction
extends FunctionBase {
    public static final String NAME_STRING_CONCATENATE = "urn:oasis:names:tc:xacml:2.0:function:string-concatenate";
    private static final int ID_STRING_CONCATENATE = 0;

    public StringFunction(String functionName) {
        super(functionName, 0, "http://www.w3.org/2001/XMLSchema#string", false, -1, 2, "http://www.w3.org/2001/XMLSchema#string", false);
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_STRING_CONCATENATE);
        return set;
    }

    @Override
    public EvaluationResult evaluate(List<Evaluatable> inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        switch (this.getFunctionId()) {
            case 0: {
                String str = ((StringAttribute)argValues[0]).getValue();
                StringBuffer buffer = new StringBuffer(str);
                for (int i = 1; i < argValues.length; ++i) {
                    buffer.append(((StringAttribute)argValues[i]).getValue());
                }
                result = new EvaluationResult(new StringAttribute(buffer.toString()));
            }
        }
        return result;
    }
}

