/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.combine;

import java.net.URI;
import java.util.HashMap;
import java.util.Set;
import org.wso2.balana.UnknownIdentifierException;
import org.wso2.balana.combine.CombiningAlgFactoryProxy;
import org.wso2.balana.combine.CombiningAlgorithm;
import org.wso2.balana.combine.StandardCombiningAlgFactory;

public abstract class CombiningAlgFactory {
    private static CombiningAlgFactoryProxy defaultFactoryProxy;
    private static HashMap<String, CombiningAlgFactoryProxy> registeredFactories;

    protected CombiningAlgFactory() {
    }

    public static final CombiningAlgFactory getInstance() {
        return defaultFactoryProxy.getFactory();
    }

    public static final CombiningAlgFactory getInstance(String identifier) throws UnknownIdentifierException {
        CombiningAlgFactoryProxy proxy = registeredFactories.get(identifier);
        if (proxy == null) {
            throw new UnknownIdentifierException("Unknown CombiningAlgFactory identifier: " + identifier);
        }
        return proxy.getFactory();
    }

    public static final void setDefaultFactory(CombiningAlgFactoryProxy proxy) {
        defaultFactoryProxy = proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void registerFactory(String identifier, CombiningAlgFactoryProxy proxy) throws IllegalArgumentException {
        HashMap<String, CombiningAlgFactoryProxy> hashMap = registeredFactories;
        synchronized (hashMap) {
            if (registeredFactories.containsKey(identifier)) {
                throw new IllegalArgumentException("Identifier is already registered as CombiningAlgFactory: " + identifier);
            }
            registeredFactories.put(identifier, proxy);
        }
    }

    public abstract void addAlgorithm(CombiningAlgorithm var1);

    public static void addCombiningAlg(CombiningAlgorithm alg) {
        CombiningAlgFactory.getInstance().addAlgorithm(alg);
    }

    public abstract Set getSupportedAlgorithms();

    public abstract CombiningAlgorithm createAlgorithm(URI var1) throws UnknownIdentifierException;

    public static CombiningAlgorithm createCombiningAlg(URI algId) throws UnknownIdentifierException {
        return CombiningAlgFactory.getInstance().createAlgorithm(algId);
    }

    static {
        CombiningAlgFactoryProxy proxy = new CombiningAlgFactoryProxy(){

            public CombiningAlgFactory getFactory() {
                return StandardCombiningAlgFactory.getFactory();
            }
        };
        registeredFactories = new HashMap();
        registeredFactories.put("urn:oasis:names:tc:xacml:1.0:policy", proxy);
        registeredFactories.put("urn:oasis:names:tc:xacml:2.0:policy:schema:os", proxy);
        registeredFactories.put("urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", proxy);
        defaultFactoryProxy = proxy;
    }
}

