/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.AbstractObligation;
import org.wso2.balana.AbstractTarget;
import org.wso2.balana.Indenter;
import org.wso2.balana.MatchResult;
import org.wso2.balana.ObligationFactory;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.PolicyTreeElement;
import org.wso2.balana.ResultFactory;
import org.wso2.balana.TargetFactory;
import org.wso2.balana.attr.BooleanAttribute;
import org.wso2.balana.cond.Apply;
import org.wso2.balana.cond.Condition;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.cond.VariableManager;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.ctx.xacml2.Result;
import org.wso2.balana.xacml3.Advice;
import org.wso2.balana.xacml3.AdviceExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule
implements PolicyTreeElement {
    private URI idAttr;
    private int effectAttr;
    private Set<AbstractObligation> obligationExpressions;
    private Set<AdviceExpression> adviceExpressions;
    private String description = null;
    private AbstractTarget target = null;
    private Condition condition = null;
    private int xacmlVersion;

    public Rule(URI id, int effect, String description, AbstractTarget target, Condition condition, Set<AbstractObligation> obligationExpressions, Set<AdviceExpression> adviceExpressions, int xacmlVersion) {
        this.idAttr = id;
        this.effectAttr = effect;
        this.description = description;
        this.target = target;
        this.condition = condition;
        this.adviceExpressions = adviceExpressions;
        this.obligationExpressions = obligationExpressions;
        this.xacmlVersion = xacmlVersion;
    }

    public Rule(URI id, int effect, String description, AbstractTarget target, Apply condition, int xacmlVersion) {
        this.idAttr = id;
        this.effectAttr = effect;
        this.description = description;
        this.target = target;
        this.condition = new Condition(condition.getFunction(), condition.getChildren());
        this.xacmlVersion = xacmlVersion;
    }

    public Rule(URI id, int effect, String description, AbstractTarget target, Condition condition) {
        this.idAttr = id;
        this.effectAttr = effect;
        this.description = description;
        this.target = target;
        this.condition = new Condition(condition.getFunction(), condition.getChildren());
    }

    public static Rule getInstance(Node root, String xpathVersion) throws ParsingException {
        return Rule.getInstance(root, new PolicyMetaData("urn:oasis:names:tc:xacml:1.0:policy", xpathVersion), null);
    }

    public static Rule getInstance(Node root, PolicyMetaData metaData, VariableManager manager) throws ParsingException {
        URI id = null;
        Object name = null;
        int effect = 0;
        String description = null;
        AbstractTarget target = null;
        Condition condition = null;
        HashSet<AbstractObligation> obligationExpressions = new HashSet<AbstractObligation>();
        HashSet<AdviceExpression> adviceExpressions = new HashSet<AdviceExpression>();
        NamedNodeMap attrs = root.getAttributes();
        try {
            id = new URI(attrs.getNamedItem("RuleId").getNodeValue());
        }
        catch (URISyntaxException use) {
            throw new ParsingException("Error parsing required attribute RuleId", use);
        }
        String str = attrs.getNamedItem("Effect").getNodeValue();
        if (str.equals("Permit")) {
            effect = 0;
        } else if (str.equals("Deny")) {
            effect = 1;
        } else {
            throw new ParsingException("Invalid Effect: " + effect);
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node;
            int j;
            NodeList nodes;
            Node child = children.item(i);
            String cname = child.getNodeName();
            if (cname.equals("Description")) {
                description = child.getFirstChild().getNodeValue();
                continue;
            }
            if (cname.equals("Target")) {
                target = TargetFactory.getFactory().getTarget(child, metaData);
                continue;
            }
            if (cname.equals("Condition")) {
                condition = Condition.getInstance(child, metaData, manager);
                continue;
            }
            if ("ObligationExpressions".equals(cname)) {
                nodes = child.getChildNodes();
                for (j = 0; j < nodes.getLength(); ++j) {
                    node = nodes.item(j);
                    if (!"ObligationExpression".equals(node.getNodeName())) continue;
                    obligationExpressions.add(ObligationFactory.getFactory().getObligation(node, metaData));
                }
                continue;
            }
            if (!"AdviceExpressions".equals(cname)) continue;
            nodes = child.getChildNodes();
            for (j = 0; j < nodes.getLength(); ++j) {
                node = nodes.item(j);
                if (!"AdviceExpression".equals(node.getNodeName())) continue;
                adviceExpressions.add(AdviceExpression.getInstance(node, metaData));
            }
        }
        return new Rule(id, effect, description, target, condition, obligationExpressions, adviceExpressions, metaData.getXACMLVersion());
    }

    public int getEffect() {
        return this.effectAttr;
    }

    @Override
    public URI getId() {
        return this.idAttr;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public AbstractTarget getTarget() {
        return this.target;
    }

    @Override
    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public MatchResult match(EvaluationCtx context) {
        if (this.target == null) {
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
            Status status = new Status(code, "no target available for matching a rule");
            return new MatchResult(2, status);
        }
        return this.target.match(context);
    }

    @Override
    public AbstractResult evaluate(EvaluationCtx context) {
        MatchResult match = null;
        if (this.target != null) {
            match = this.target.match(context);
            int result = match.getResult();
            if (result == 1) {
                return ResultFactory.getFactory().getResult(3, context);
            }
            if (result == 2) {
                if (this.xacmlVersion == 3) {
                    if (this.effectAttr == 0) {
                        return ResultFactory.getFactory().getResult(5, match.getStatus(), context);
                    }
                    return ResultFactory.getFactory().getResult(4, match.getStatus(), context);
                }
                return ResultFactory.getFactory().getResult(2, match.getStatus(), context);
            }
        }
        if (this.condition == null) {
            return ResultFactory.getFactory().getResult(this.effectAttr, this.processObligations(context), this.processAdvices(context), context);
        }
        EvaluationResult result = this.condition.evaluate(context);
        if (result.indeterminate()) {
            if (this.xacmlVersion == 3) {
                if (this.effectAttr == 0) {
                    return ResultFactory.getFactory().getResult(5, result.getStatus(), context);
                }
                return ResultFactory.getFactory().getResult(4, result.getStatus(), context);
            }
            return ResultFactory.getFactory().getResult(2, result.getStatus(), context);
        }
        BooleanAttribute bool = (BooleanAttribute)result.getAttributeValue();
        if (bool.getValue()) {
            return ResultFactory.getFactory().getResult(this.effectAttr, this.processObligations(context), this.processAdvices(context), context);
        }
        return ResultFactory.getFactory().getResult(3, context);
    }

    private Set<ObligationResult> processObligations(EvaluationCtx evaluationCtx) {
        if (this.obligationExpressions != null && this.obligationExpressions.size() > 0) {
            HashSet<ObligationResult> results = new HashSet<ObligationResult>();
            for (AbstractObligation obligationExpression : this.obligationExpressions) {
                if (obligationExpression.getFulfillOn() != this.effectAttr) continue;
                results.add(obligationExpression.evaluate(evaluationCtx));
            }
            return results;
        }
        return null;
    }

    private Set<Advice> processAdvices(EvaluationCtx evaluationCtx) {
        if (this.adviceExpressions != null && this.adviceExpressions.size() > 0) {
            HashSet<Advice> advices = new HashSet<Advice>();
            for (AdviceExpression adviceExpression : this.adviceExpressions) {
                if (adviceExpression.getAppliesTo() != this.effectAttr) continue;
                advices.add(adviceExpression.evaluate(evaluationCtx));
            }
            return advices;
        }
        return null;
    }

    @Override
    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.print(indent + "<Rule RuleId=\"" + this.idAttr.toString() + "\" Effect=\"" + Result.DECISIONS[this.effectAttr] + "\"");
        if (this.description != null || this.target != null || this.condition != null) {
            out.println(">");
            indenter.in();
            String nextIndent = indenter.makeString();
            if (this.description != null) {
                out.println(nextIndent + "<Description>" + this.description + "</Description>");
            }
            if (this.condition != null) {
                this.condition.encode(output, indenter);
            }
            indenter.out();
            out.println(indent + "</Rule>");
        } else {
            out.println("/>");
        }
    }
}

