/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.pip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.identity.entitlement.pip.PIPAttributeFinder;
import org.wso2.carbon.identity.entitlement.pip.PIPConfigHolder;
import org.wso2.carbon.identity.entitlement.pip.PIPExtension;
import org.wso2.carbon.identity.entitlement.pip.PIPResourceFinder;
import org.wso2.carbon.identity.entitlement.policy.PolicyMetaDataFinderModule;
import org.wso2.carbon.utils.CarbonUtils;

public class PIPExtensionBuilder {
    public static final String LOCAL_NAME_EXTENSIONS = "Extensions";
    public static final String LOCAL_NAME_EXTENSION = "Extension";
    public static final String LOCAL_NAME_EXTENSION_CLASS_ATTR = "class";
    public static final String LOCAL_NAME_ATTR_DESIGNATORS = "AttributeDesignators";
    public static final String LOCAL_NAME_ATTR_DESIGNATOR = "Designator";
    public static final String LOCAL_NAME_ATTR_CLASS_ATTR = "class";
    public static final String LOCAL_NAME_RESOURCE_FINDERS = "ResourceFinders";
    public static final String LOCAL_NAME_RESOURCE_FINDER = "Finder";
    public static final String LOCAL_NAME_RESOURCE_FINDER_CLASS = "class";
    public static final String LOCAL_NAME_META_DATA_FINDERS = "MetaDataFinders";
    public static final String LOCAL_NAME_META_DATA_FINDER = "Finder";
    public static final String LOCAL_NAME_META_DATA_FINDER_CLASS = "class";
    public static final String LOCAL_NAME_PROPERTY = "Property";
    public static final String LOCAL_NAME_PROPERTY_NAME = "name";
    private static Log log = LogFactory.getLog(PIPExtensionBuilder.class);
    private static final String PIP_CONFIG = "pip-config.xml";
    private BundleContext bundleContext;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void buildPIPConfig(PIPConfigHolder holder) throws Exception {
        OMElement finderProperty;
        Iterator finderProperties;
        OMElement finder;
        Class<?> clazz;
        String propertyValue;
        String propertyName;
        Properties properties;
        String clazzName;
        OMElement element = null;
        OMElement extensionsRoot = null;
        Iterator extIterator = null;
        OMElement designatorsRoot = null;
        Iterator designatorsIterator = null;
        OMElement resourceFinderRoot = null;
        Iterator resourceFinderIterator = null;
        OMElement metaDataFinderRoot = null;
        Iterator metaDataFinderIterator = null;
        try {
            element = this.getRootElement();
        }
        catch (IOException e) {
            String message = "Error while reading PIP configuration";
            log.error((Object)message);
            throw new Exception(message, e);
        }
        catch (XMLStreamException e) {
            String message = "Error while reading PIP configuration";
            log.error((Object)message);
            throw new Exception(message, e);
        }
        extensionsRoot = element.getFirstChildWithName(new QName(LOCAL_NAME_EXTENSIONS));
        if (extensionsRoot != null) {
            extIterator = extensionsRoot.getChildrenWithLocalName(LOCAL_NAME_EXTENSION);
            while (extIterator.hasNext()) {
                OMElement extension = null;
                clazzName = null;
                extension = (OMElement)extIterator.next();
                clazzName = extension.getAttribute(new QName("class")).getAttributeValue();
                Class<?> clazz2 = null;
                try {
                    clazz2 = Thread.currentThread().getContextClassLoader().loadClass(clazzName);
                    holder.getExtensions().add((PIPExtension)clazz2.newInstance());
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Error while initializing pip extension : " + clazzName));
                }
                catch (InstantiationException e) {
                    log.error((Object)("Error while initializing pip extension : " + clazzName));
                }
                catch (IllegalAccessException e) {
                    log.error((Object)("Error while initializing pip extension : " + clazzName));
                }
            }
        }
        if ((designatorsRoot = element.getFirstChildWithName(new QName(LOCAL_NAME_ATTR_DESIGNATORS))) != null) {
            designatorsIterator = designatorsRoot.getChildrenWithLocalName(LOCAL_NAME_ATTR_DESIGNATOR);
            while (designatorsIterator.hasNext()) {
                OMElement designator = null;
                clazzName = null;
                PIPAttributeFinder attributeFinder = null;
                designator = (OMElement)designatorsIterator.next();
                clazzName = designator.getAttribute(new QName("class")).getAttributeValue();
                properties = new Properties();
                Iterator designatorProperties = designator.getChildrenWithLocalName(LOCAL_NAME_PROPERTY);
                while (designatorProperties.hasNext()) {
                    OMElement designatorProperty = (OMElement)designatorProperties.next();
                    propertyName = designatorProperty.getAttributeValue(new QName(LOCAL_NAME_PROPERTY_NAME));
                    propertyValue = designatorProperty.getText();
                    if (propertyName == null || propertyValue == null) continue;
                    properties.put(propertyName, propertyValue);
                }
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(clazzName);
                    attributeFinder = (PIPAttributeFinder)clazz.newInstance();
                    attributeFinder.init(properties);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Error while initializing attribute designator : " + clazzName));
                }
                catch (InstantiationException e) {
                    log.error((Object)("Error while initializing attribute designator : " + clazzName));
                }
                catch (IllegalAccessException e) {
                    log.error((Object)("Error while initializing attribute designator : " + clazzName));
                }
                catch (Exception e) {
                    log.error((Object)("Error while initializing attribute designator : " + clazzName));
                }
                if (attributeFinder == null) continue;
                holder.getDesignators().add(attributeFinder);
            }
        }
        if ((resourceFinderRoot = element.getFirstChildWithName(new QName(LOCAL_NAME_RESOURCE_FINDERS))) != null) {
            resourceFinderIterator = resourceFinderRoot.getChildrenWithLocalName("Finder");
            while (resourceFinderIterator.hasNext()) {
                finder = null;
                clazzName = null;
                PIPResourceFinder resourceFinder = null;
                finder = (OMElement)resourceFinderIterator.next();
                clazzName = finder.getAttribute(new QName("class")).getAttributeValue();
                properties = new Properties();
                finderProperties = finder.getChildrenWithLocalName(LOCAL_NAME_PROPERTY);
                while (finderProperties.hasNext()) {
                    finderProperty = (OMElement)finderProperties.next();
                    propertyName = finderProperty.getAttributeValue(new QName(LOCAL_NAME_PROPERTY_NAME));
                    propertyValue = finderProperty.getText();
                    if (propertyName == null || propertyValue == null) continue;
                    properties.put(propertyName, propertyValue);
                }
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(clazzName);
                    resourceFinder = (PIPResourceFinder)clazz.newInstance();
                    resourceFinder.init(properties);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Error while initializing resource designator : " + clazzName));
                }
                catch (InstantiationException e) {
                    log.error((Object)("Error while initializing resource designator : " + clazzName));
                }
                catch (IllegalAccessException e) {
                    log.error((Object)("Error while initializing resource designator : " + clazzName));
                }
                catch (Exception e) {
                    log.error((Object)("Error while initializing resource designator : " + clazzName));
                }
                if (resourceFinder == null) continue;
                holder.getResourceFinders().add(resourceFinder);
            }
        }
        if ((metaDataFinderRoot = element.getFirstChildWithName(new QName(LOCAL_NAME_META_DATA_FINDERS))) != null) {
            metaDataFinderIterator = metaDataFinderRoot.getChildrenWithLocalName("Finder");
            while (metaDataFinderIterator.hasNext()) {
                finder = null;
                clazzName = null;
                PolicyMetaDataFinderModule metaDataFinderModule = null;
                finder = (OMElement)metaDataFinderIterator.next();
                clazzName = finder.getAttribute(new QName("class")).getAttributeValue();
                properties = new Properties();
                finderProperties = finder.getChildrenWithLocalName(LOCAL_NAME_PROPERTY);
                while (finderProperties.hasNext()) {
                    finderProperty = (OMElement)finderProperties.next();
                    propertyName = finderProperty.getAttributeValue(new QName(LOCAL_NAME_PROPERTY_NAME));
                    propertyValue = finderProperty.getText();
                    if (propertyName == null || propertyValue == null) continue;
                    properties.put(propertyName, propertyValue);
                }
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(clazzName);
                    metaDataFinderModule = (PolicyMetaDataFinderModule)clazz.newInstance();
                    metaDataFinderModule.init(properties);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Error while initializing resource designator : " + clazzName));
                }
                catch (InstantiationException e) {
                    log.error((Object)("Error while initializing resource designator : " + clazzName));
                }
                catch (IllegalAccessException e) {
                    log.error((Object)("Error while initializing resource designator : " + clazzName));
                }
                catch (Exception e) {
                    log.error((Object)("Error while initializing resource designator : " + clazzName));
                }
                if (metaDataFinderModule == null) continue;
                holder.getPolicyMetaDataFinderModules().add(metaDataFinderModule);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OMElement getRootElement() throws XMLStreamException, IOException {
        StAXOMBuilder builder = null;
        InputStream inStream = null;
        String warningMessage = "";
        try {
            URL url;
            File pipConfigXml = new File(CarbonUtils.getCarbonConfigDirPath(), PIP_CONFIG);
            if (pipConfigXml.exists()) {
                inStream = new FileInputStream(pipConfigXml);
            } else if (this.bundleContext != null) {
                url = this.bundleContext.getBundle().getResource(PIP_CONFIG);
                if (url != null) {
                    inStream = url.openStream();
                } else {
                    warningMessage = "Bundle context could not find resource pip-config.xml or user does not have sufficient permission to access the resource.";
                }
            } else {
                url = this.getClass().getClassLoader().getResource(PIP_CONFIG);
                if (url != null) {
                    inStream = url.openStream();
                } else {
                    warningMessage = "PIP Config Builder could not find resource pip-config.xml or user does not have sufficient permission to access the resource.";
                }
            }
            if (inStream == null) {
                String message = "PIP configuration not found. Cause - " + warningMessage;
                if (log.isDebugEnabled()) {
                    log.debug((Object)message);
                }
                throw new FileNotFoundException(message);
            }
            builder = new StAXOMBuilder(inStream);
            OMElement oMElement = builder.getDocumentElement();
            return oMElement;
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
    }
}

