/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.base.ServerConfigurationException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.entitlement.internal.EntitlementConfigHolder;
import org.wso2.carbon.identity.entitlement.internal.EntitlementExtensionBuilder;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceInitializer;
import org.wso2.carbon.identity.entitlement.thrift.EntitlementService;
import org.wso2.carbon.identity.entitlement.thrift.ThriftEntitlementServiceImpl;
import org.wso2.carbon.identity.thrift.authentication.ThriftAuthenticatorService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;

public class EntitlementServiceComponent {
    private static Log log = LogFactory.getLog(EntitlementServiceComponent.class);
    private static final String POLICY_TEMPLATE = "template.xml";
    private static String templatePolicy = null;
    private static RegistryService registryService = null;
    private static EntitlementConfigHolder entitlementConfig = null;
    private static RealmService realmservice;
    private ThriftAuthenticatorService thriftAuthenticationService;
    private ExecutorService executor = Executors.newFixedThreadPool(2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Identity Entitlement bundle is activated");
        }
        InputStream inStream = null;
        BufferedReader reader = null;
        try {
            inStream = ctxt.getBundleContext().getBundle().getResource(POLICY_TEMPLATE).openStream();
            reader = new BufferedReader(new InputStreamReader(inStream));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line.trim() + " " + "\n");
            }
            templatePolicy = sb.toString();
            inStream.close();
            EntitlementServiceInitializer entitlementServiceInitializer = new EntitlementServiceInitializer(registryService);
            entitlementServiceInitializer.putEntitlementPolicyResourcesToRegistry();
            entitlementConfig = new EntitlementConfigHolder();
            EntitlementExtensionBuilder builder = new EntitlementExtensionBuilder();
            builder.setBundleContext(ctxt.getBundleContext());
            builder.buildPIPConfig(entitlementConfig);
            builder.buildCachingConfig(entitlementConfig);
            builder.buildPAPConfig(entitlementConfig);
            ThriftEntitlementServiceImpl.init(this.thriftAuthenticationService);
            this.startThriftServices();
        }
        catch (Exception e) {
            log.error((Object)"Failed to initialize Entitlement Service", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Unable to close the InputStream " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Entitlement bundle is deactivated");
        }
    }

    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService set in Entitlement bundle");
        }
        EntitlementServiceComponent.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in Entitlement bundle");
        }
        EntitlementServiceComponent.registryService = null;
    }

    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"DefaultUserRealm set in Entitlement bundle");
        }
        realmservice = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"DefaultUserRealm unset in Entitlement bundle");
        }
        realmservice = null;
    }

    protected void setThriftAuthenticationService(ThriftAuthenticatorService authenticationService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ThriftAuthenticatorService set in Entitlement bundle");
        }
        this.thriftAuthenticationService = authenticationService;
    }

    protected void unsetThriftAuthenticationService(ThriftAuthenticatorService authenticationService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ThriftAuthenticatorService unset in Entitlement bundle");
        }
        this.thriftAuthenticationService = null;
    }

    public static String getTemplatePolicy() {
        return templatePolicy;
    }

    public static EntitlementConfigHolder getEntitlementConfig() {
        return entitlementConfig;
    }

    public static RealmService getRealmservice() {
        return realmservice;
    }

    public static void setRealmservice(RealmService realmservice) {
        EntitlementServiceComponent.realmservice = realmservice;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    private void startThriftServices() throws Exception {
        this.startThriftEntitlementService();
    }

    private void startThriftEntitlementService() throws Exception {
        try {
            IdentityUtil.populateProperties();
            String thriftEnabled = IdentityUtil.getProperty((String)"EntitlementSettings.ThirftBasedEntitlementConfig.EnableThriftService");
            if (thriftEnabled != null && Boolean.parseBoolean(thriftEnabled)) {
                TSSLTransportFactory.TSSLTransportParameters transportParam = new TSSLTransportFactory.TSSLTransportParameters();
                String keystorePath = IdentityUtil.getProperty((String)"EntitlementSettings.ThirftBasedEntitlementConfig.KeyStore.Location");
                String keystorePassword = IdentityUtil.getProperty((String)"EntitlementSettings.ThirftBasedEntitlementConfig.KeyStore.Password");
                transportParam.setKeyStore(keystorePath, keystorePassword);
                int receivePort = this.readThriftReceivePort();
                int clientTimeOut = Integer.parseInt(IdentityUtil.getProperty((String)"EntitlementSettings.ThirftBasedEntitlementConfig.ClientTimeout"));
                TServerSocket serverTransport = TSSLTransportFactory.getServerSocket((int)receivePort, (int)clientTimeOut, (InetAddress)InetAddress.getLocalHost(), (TSSLTransportFactory.TSSLTransportParameters)transportParam);
                EntitlementService.Processor<ThriftEntitlementServiceImpl> processor = new EntitlementService.Processor<ThriftEntitlementServiceImpl>(new ThriftEntitlementServiceImpl());
                TThreadPoolServer server = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor(processor));
                ServerRunnable serverThread = new ServerRunnable((TServer)server);
                this.executor.submit(serverThread);
                log.info((Object)("Started thrift entitlement service at port:" + receivePort));
            }
        }
        catch (TTransportException e) {
            String transportErrorMsg = "Error in initializing thrift transport";
            log.error((Object)transportErrorMsg, (Throwable)e);
            throw new Exception(transportErrorMsg);
        }
        catch (UnknownHostException e) {
            String hostErrorMsg = "Error in obtaining host name";
            log.error((Object)hostErrorMsg, (Throwable)e);
            throw new Exception(hostErrorMsg);
        }
        catch (ServerConfigurationException e) {
            String configError = "Error in reading configuration.";
            log.error((Object)configError, (Throwable)e);
            throw new Exception(configError);
        }
    }

    private int readThriftReceivePort() {
        int port = -1;
        String portValue = IdentityUtil.getProperty((String)"EntitlementSettings.ThirftBasedEntitlementConfig.ReceivePort");
        port = portValue.contains("${") && portValue.contains("}") ? CarbonUtils.getPortFromServerConfig((String)portValue) : Integer.parseInt(portValue);
        return port;
    }

    private class ServerRunnable
    implements Runnable {
        TServer server;

        public ServerRunnable(TServer server) {
            this.server = server;
        }

        @Override
        public void run() {
            this.server.serve();
        }
    }
}

