/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.identity.entitlement.internal.EntitlementConfigHolder;
import org.wso2.carbon.identity.entitlement.pip.PIPAttributeFinder;
import org.wso2.carbon.identity.entitlement.pip.PIPExtension;
import org.wso2.carbon.identity.entitlement.pip.PIPResourceFinder;
import org.wso2.carbon.identity.entitlement.policy.PolicyMetaDataFinderModule;
import org.wso2.carbon.utils.CarbonUtils;

public class EntitlementExtensionBuilder {
    public static final String LOCAL_NAME_PIP_CONFIG = "PIPConfig";
    public static final String LOCAL_NAME_CACHING_CONFIG = "CachingConfig";
    public static final String LOCAL_NAME_PAP_CONFIG = "PAPConfig";
    public static final String LOCAL_NAME_EXTENSIONS = "Extensions";
    public static final String LOCAL_NAME_EXTENSION = "Extension";
    public static final String LOCAL_NAME_EXTENSION_CLASS_ATTR = "class";
    public static final String LOCAL_NAME_ATTR_DESIGNATORS = "AttributeDesignators";
    public static final String LOCAL_NAME_ATTR_DESIGNATOR = "Designator";
    public static final String LOCAL_NAME_ATTR_CLASS_ATTR = "class";
    public static final String LOCAL_NAME_RESOURCE_FINDERS = "ResourceFinders";
    public static final String LOCAL_NAME_RESOURCE_FINDER = "Finder";
    public static final String LOCAL_NAME_RESOURCE_FINDER_CLASS = "class";
    public static final String LOCAL_NAME_META_DATA_FINDERS = "MetaDataFinders";
    public static final String LOCAL_NAME_META_DATA_FINDER = "Finder";
    public static final String LOCAL_NAME_META_DATA_FINDER_CLASS = "class";
    public static final String LOCAL_NAME_PROPERTY = "Property";
    public static final String LOCAL_NAME_PROPERTY_NAME = "name";
    public static final String LOCAL_NAME_ATTRIBUTE_CACHING = "AttributeCaching";
    public static final String LOCAL_NAME_RESOURCE_CACHING = "ResourceCaching";
    public static final String LOCAL_NAME_DECISION_CACHING = "DecisionCaching";
    public static final String LOCAL_NAME_ON_DEMAND_LOADING = "OnDemandPolicyLoading";
    public static final String LOCAL_NAME_MAX_POLICIES = "MaxInMemoryPolicies";
    public static final String LOCAL_NAME_CACHING_INTERVAL = "CachingInterval";
    public static final String LOCAL_NAME_ENABLE = "Enable";
    private static final String PIP_CONFIG = "entitlement-config.xml";
    private static Log log = LogFactory.getLog(EntitlementExtensionBuilder.class);
    private BundleContext bundleContext;
    private OMElement rootElement;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void buildPIPConfig(EntitlementConfigHolder holder) throws Exception {
        Class<?> clazz;
        String propertyValue;
        String propertyName;
        OMElement designatorProperty;
        Iterator designatorProperties;
        Properties properties;
        String clazzName;
        OMElement pipConfigElement = null;
        OMElement extensionsRoot = null;
        Iterator extIterator = null;
        OMElement designatorsRoot = null;
        Iterator designatorsIterator = null;
        OMElement resourceFinderRoot = null;
        Iterator resourceFinderIterator = null;
        pipConfigElement = this.getPIPConfigElement();
        if (pipConfigElement == null) {
            return;
        }
        extensionsRoot = pipConfigElement.getFirstChildWithName(new QName(LOCAL_NAME_EXTENSIONS));
        if (extensionsRoot != null) {
            extIterator = extensionsRoot.getChildrenWithLocalName(LOCAL_NAME_EXTENSION);
            while (extIterator.hasNext()) {
                OMElement extension = null;
                clazzName = null;
                PIPExtension pipExtension = null;
                extension = (OMElement)extIterator.next();
                clazzName = extension.getAttribute(new QName("class")).getAttributeValue();
                properties = new Properties();
                designatorProperties = extension.getChildrenWithLocalName(LOCAL_NAME_PROPERTY);
                while (designatorProperties.hasNext()) {
                    designatorProperty = (OMElement)designatorProperties.next();
                    propertyName = designatorProperty.getAttributeValue(new QName(LOCAL_NAME_PROPERTY_NAME));
                    propertyValue = designatorProperty.getText();
                    if (propertyName == null || propertyValue == null) continue;
                    properties.put(propertyName, propertyValue);
                }
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(clazzName);
                    pipExtension = (PIPExtension)clazz.newInstance();
                    pipExtension.init(properties);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Error while initializing pip extension : " + clazzName));
                }
                catch (InstantiationException e) {
                    log.error((Object)("Error while initializing pip extension : " + clazzName));
                }
                catch (IllegalAccessException e) {
                    log.error((Object)("Error while initializing pip extension : " + clazzName));
                }
                if (pipExtension == null) continue;
                holder.addExtensions(pipExtension, properties);
            }
        }
        if ((designatorsRoot = pipConfigElement.getFirstChildWithName(new QName(LOCAL_NAME_ATTR_DESIGNATORS))) != null) {
            designatorsIterator = designatorsRoot.getChildrenWithLocalName(LOCAL_NAME_ATTR_DESIGNATOR);
            while (designatorsIterator.hasNext()) {
                OMElement designator = null;
                clazzName = null;
                PIPAttributeFinder attributeFinder = null;
                designator = (OMElement)designatorsIterator.next();
                clazzName = designator.getAttribute(new QName("class")).getAttributeValue();
                properties = new Properties();
                designatorProperties = designator.getChildrenWithLocalName(LOCAL_NAME_PROPERTY);
                while (designatorProperties.hasNext()) {
                    designatorProperty = (OMElement)designatorProperties.next();
                    propertyName = designatorProperty.getAttributeValue(new QName(LOCAL_NAME_PROPERTY_NAME));
                    propertyValue = designatorProperty.getText();
                    if (propertyName == null || propertyValue == null) continue;
                    properties.put(propertyName, propertyValue);
                }
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(clazzName);
                    attributeFinder = (PIPAttributeFinder)clazz.newInstance();
                    attributeFinder.init(properties);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Error while initializing attribute designator : " + clazzName));
                }
                catch (InstantiationException e) {
                    log.error((Object)("Error while initializing attribute designator : " + clazzName));
                }
                catch (IllegalAccessException e) {
                    log.error((Object)("Error while initializing attribute designator : " + clazzName));
                }
                catch (Exception e) {
                    log.error((Object)("Error while initializing attribute designator : " + clazzName));
                }
                if (attributeFinder == null) continue;
                holder.addDesignators(attributeFinder, properties);
            }
        }
        if ((resourceFinderRoot = pipConfigElement.getFirstChildWithName(new QName(LOCAL_NAME_RESOURCE_FINDERS))) != null) {
            resourceFinderIterator = resourceFinderRoot.getChildrenWithLocalName("Finder");
            while (resourceFinderIterator.hasNext()) {
                OMElement finder = null;
                clazzName = null;
                PIPResourceFinder resourceFinder = null;
                finder = (OMElement)resourceFinderIterator.next();
                clazzName = finder.getAttribute(new QName("class")).getAttributeValue();
                properties = new Properties();
                Iterator finderProperties = finder.getChildrenWithLocalName(LOCAL_NAME_PROPERTY);
                while (finderProperties.hasNext()) {
                    OMElement finderProperty = (OMElement)finderProperties.next();
                    propertyName = finderProperty.getAttributeValue(new QName(LOCAL_NAME_PROPERTY_NAME));
                    propertyValue = finderProperty.getText();
                    if (propertyName == null || propertyValue == null) continue;
                    properties.put(propertyName, propertyValue);
                }
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(clazzName);
                    resourceFinder = (PIPResourceFinder)clazz.newInstance();
                    resourceFinder.init(properties);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Error while initializing resource designator : " + clazzName));
                }
                catch (InstantiationException e) {
                    log.error((Object)("Error while initializing resource designator : " + clazzName));
                }
                catch (IllegalAccessException e) {
                    log.error((Object)("Error while initializing resource designator : " + clazzName));
                }
                catch (Exception e) {
                    log.error((Object)("Error while initializing resource designator : " + clazzName));
                }
                if (resourceFinder == null) continue;
                holder.addResourceFinders(resourceFinder, properties);
            }
        }
    }

    public void buildPAPConfig(EntitlementConfigHolder holder) throws Exception {
        OMElement metaDataFinderRoot = null;
        Iterator metaDataFinderIterator = null;
        OMElement papElement = this.getPAPConfigElement();
        if (papElement == null) {
            return;
        }
        metaDataFinderRoot = papElement.getFirstChildWithName(new QName(LOCAL_NAME_META_DATA_FINDERS));
        if (metaDataFinderRoot != null) {
            metaDataFinderIterator = metaDataFinderRoot.getChildrenWithLocalName("Finder");
            while (metaDataFinderIterator.hasNext()) {
                OMElement finder = null;
                String clazzName = null;
                PolicyMetaDataFinderModule metaDataFinderModule = null;
                finder = (OMElement)metaDataFinderIterator.next();
                clazzName = finder.getAttribute(new QName("class")).getAttributeValue();
                Properties properties = new Properties();
                Iterator finderProperties = finder.getChildrenWithLocalName(LOCAL_NAME_PROPERTY);
                while (finderProperties.hasNext()) {
                    OMElement finderProperty = (OMElement)finderProperties.next();
                    String propertyName = finderProperty.getAttributeValue(new QName(LOCAL_NAME_PROPERTY_NAME));
                    String propertyValue = finderProperty.getText();
                    if (propertyName == null || propertyValue == null) continue;
                    properties.put(propertyName, propertyValue);
                }
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(clazzName);
                    metaDataFinderModule = (PolicyMetaDataFinderModule)clazz.newInstance();
                    metaDataFinderModule.init(properties);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Error while initializing resource designator : " + clazzName));
                }
                catch (InstantiationException e) {
                    log.error((Object)("Error while initializing resource designator : " + clazzName));
                }
                catch (IllegalAccessException e) {
                    log.error((Object)("Error while initializing resource designator : " + clazzName));
                }
                catch (Exception e) {
                    log.error((Object)("Error while initializing resource designator : " + clazzName));
                }
                if (metaDataFinderModule == null) continue;
                holder.addPolicyMetaDataFinderModules(metaDataFinderModule, properties);
            }
        }
    }

    public void buildCachingConfig(EntitlementConfigHolder holder) throws Exception {
        OMElement onDemandLoading;
        OMElement decisionCaching;
        OMElement enable;
        OMElement resourceCaching;
        OMElement enable2;
        Properties properties = new Properties();
        OMElement cachingElement = this.getCachingConfigElement();
        if (cachingElement == null) {
            return;
        }
        OMElement attributeCaching = cachingElement.getFirstChildWithName(new QName(LOCAL_NAME_ATTRIBUTE_CACHING));
        if (attributeCaching != null && (enable2 = attributeCaching.getFirstChildWithName(new QName(LOCAL_NAME_ENABLE))) != null && enable2.getText() != null) {
            properties.setProperty("AttributeCaching.Enable", enable2.getText().trim());
        }
        if ((resourceCaching = cachingElement.getFirstChildWithName(new QName(LOCAL_NAME_RESOURCE_CACHING))) != null && (enable = resourceCaching.getFirstChildWithName(new QName(LOCAL_NAME_ENABLE))) != null && enable.getText() != null) {
            properties.setProperty("ResourceCaching.Enable", enable.getText().trim());
        }
        if ((decisionCaching = cachingElement.getFirstChildWithName(new QName(LOCAL_NAME_DECISION_CACHING))) != null) {
            OMElement cachingInterval;
            OMElement enable3 = decisionCaching.getFirstChildWithName(new QName(LOCAL_NAME_ENABLE));
            if (enable3 != null && enable3.getText() != null) {
                properties.setProperty("DecisionCaching.Enable", enable3.getText().trim());
            }
            if ((cachingInterval = decisionCaching.getFirstChildWithName(new QName(LOCAL_NAME_CACHING_INTERVAL))) != null && cachingInterval.getText() != null) {
                properties.setProperty("DecisionCaching.CachingInterval", cachingInterval.getText().trim());
            }
        }
        if ((onDemandLoading = cachingElement.getFirstChildWithName(new QName(LOCAL_NAME_ON_DEMAND_LOADING))) != null) {
            OMElement maxPolicies;
            OMElement enable4 = onDemandLoading.getFirstChildWithName(new QName(LOCAL_NAME_ENABLE));
            if (enable4 != null && enable4.getText() != null) {
                properties.setProperty("OnDemandPolicyLoading.Enable", enable4.getText().trim());
            }
            if ((maxPolicies = onDemandLoading.getFirstChildWithName(new QName(LOCAL_NAME_MAX_POLICIES))) != null && maxPolicies.getText() != null) {
                properties.setProperty("OnDemandPolicyLoading.MaxInMemoryPolicies", maxPolicies.getText().trim());
            }
        }
        holder.setCachingProperties(properties);
    }

    private OMElement getPIPConfigElement() throws Exception {
        if (this.rootElement == null) {
            this.rootElement = this.getRootElement();
        }
        if (this.rootElement != null) {
            return this.rootElement.getFirstChildWithName(new QName(LOCAL_NAME_PIP_CONFIG));
        }
        return null;
    }

    private OMElement getPAPConfigElement() throws Exception {
        if (this.rootElement == null) {
            this.rootElement = this.getRootElement();
        }
        if (this.rootElement != null) {
            return this.rootElement.getFirstChildWithName(new QName(LOCAL_NAME_PAP_CONFIG));
        }
        return null;
    }

    private OMElement getCachingConfigElement() throws Exception {
        if (this.rootElement == null) {
            this.rootElement = this.getRootElement();
        }
        if (this.rootElement != null) {
            return this.rootElement.getFirstChildWithName(new QName(LOCAL_NAME_CACHING_CONFIG));
        }
        return null;
    }

    private OMElement getRootElement() throws Exception {
        StAXOMBuilder builder = null;
        InputStream inStream = null;
        String warningMessage = "";
        try {
            Object message;
            URL url;
            File pipConfigXml = new File(CarbonUtils.getCarbonConfigDirPath(), PIP_CONFIG);
            if (pipConfigXml.exists()) {
                inStream = new FileInputStream(pipConfigXml);
            } else if (this.bundleContext != null) {
                url = this.bundleContext.getBundle().getResource(PIP_CONFIG);
                if (url != null) {
                    inStream = url.openStream();
                } else {
                    warningMessage = "Bundle context could not find resource entitlement-config.xml or user does not have sufficient permission to access the resource.";
                }
            } else {
                url = this.getClass().getClassLoader().getResource(PIP_CONFIG);
                if (url != null) {
                    inStream = url.openStream();
                } else {
                    warningMessage = "PIP Config Builder could not find resource entitlement-config.xml or user does not have sufficient permission to access the resource.";
                }
            }
            if (inStream == null) {
                message = "Entitlement configuration not found. Cause - " + warningMessage;
                if (log.isDebugEnabled()) {
                    log.debug(message);
                }
                throw new FileNotFoundException((String)message);
            }
            builder = new StAXOMBuilder(inStream);
            message = builder.getDocumentElement();
            return message;
        }
        catch (FileNotFoundException e) {
            String message = "Error while reading Entitlement configuration";
            log.error((Object)message);
            throw new Exception(message, e);
        }
        catch (XMLStreamException e) {
            String message = "Error while reading Entitlement configuration";
            log.error((Object)message);
            throw new Exception(message, e);
        }
        catch (IOException e) {
            String message = "Error while reading Entitlement configuration";
            log.error((Object)message);
            throw new Exception(message, e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error occurs while closing in-stream for Entitlement Config");
                }
            }
        }
    }
}

