/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.ui.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.carbon.identity.entitlement.ui.PolicyEditorException;
import org.wso2.carbon.identity.entitlement.ui.dto.AllOfElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.AnyOfElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.ApplyElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.AttributeDesignatorDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.AttributeSelectorDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.AttributeValueElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.ConditionElementDT0;
import org.wso2.carbon.identity.entitlement.ui.dto.MatchElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.NewTargetElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.RowDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.RuleDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.RuleElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.TargetDTO;
import org.wso2.carbon.identity.entitlement.ui.util.PolicyCreatorUtil;

public class PolicyEditorUtil {
    public static void createTestPolicy(List<RuleDTO> ruleDTOs, TargetDTO targetDTO) {
    }

    public static Element createRule(RuleDTO ruleDTO, Document doc) throws PolicyEditorException {
        RuleElementDTO ruleElementDTO = new RuleElementDTO();
        ruleElementDTO.setRuleId(ruleDTO.getRuleId());
        ruleElementDTO.setRuleEffect(ruleDTO.getRuleEffect());
        ConditionElementDT0 conditionElementDT0 = PolicyEditorUtil.createConditionDTO(ruleDTO.getRowDTOList());
        NewTargetElementDTO targetElementDTO = PolicyEditorUtil.createTargetDTO(ruleDTO.getTargetDTO());
        if (conditionElementDT0 != null) {
            ruleElementDTO.setConditionElementDT0(conditionElementDT0);
        }
        if (targetElementDTO != null) {
            ruleElementDTO.setNewTargetElementDTO(targetElementDTO);
        }
        return PolicyCreatorUtil.createRuleElement(ruleElementDTO, doc);
    }

    public static Element createTarget(TargetDTO targetDTO, Document doc) throws PolicyEditorException {
        Element targetElement = null;
        NewTargetElementDTO targetElementDTO = PolicyEditorUtil.createTargetDTO(targetDTO);
        if (targetElementDTO != null) {
            targetElement = PolicyEditorUtil.createTargetElement(targetElementDTO, doc);
        }
        return targetElement;
    }

    public static ConditionElementDT0 createConditionDTO(List<RowDTO> rowDTOs) throws PolicyEditorException {
        ConditionElementDT0 rootApplyDTO = new ConditionElementDT0();
        ArrayList<RowDTO> temp = new ArrayList<RowDTO>();
        HashSet<ArrayList<RowDTO>> listSet = new HashSet<ArrayList<RowDTO>>();
        for (int i = 0; i < rowDTOs.size(); ++i) {
            if (i == 0) {
                temp.add(rowDTOs.get(0));
                continue;
            }
            String string = rowDTOs.get(i - 1).getCombineFunction();
            if ("AND".equals(string)) {
                temp.add(rowDTOs.get(i));
            }
            if (!"OR".equals(string)) continue;
            listSet.add(temp);
            temp = new ArrayList();
            temp.add(rowDTOs.get(i));
        }
        listSet.add(temp);
        if (listSet.size() > 1) {
            for (ArrayList arrayList : listSet) {
                ApplyElementDTO orApplyDTO = new ApplyElementDTO();
                orApplyDTO.setFunctionId(PolicyEditorUtil.processFunction("or"));
                if (arrayList.size() > 1) {
                    ApplyElementDTO andApplyDTO = new ApplyElementDTO();
                    andApplyDTO.setFunctionId(PolicyEditorUtil.processFunction("and"));
                    for (RowDTO rowDTO : arrayList) {
                        ApplyElementDTO applyElementDTO = PolicyEditorUtil.createApplyElement(rowDTO);
                        andApplyDTO.setApplyElement(applyElementDTO);
                    }
                    orApplyDTO.setApplyElement(andApplyDTO);
                    continue;
                }
                if (arrayList.size() != 1) continue;
                RowDTO rowDTO = (RowDTO)arrayList.get(0);
                ApplyElementDTO andApplyDTO = PolicyEditorUtil.createApplyElement(rowDTO);
                orApplyDTO.setApplyElement(andApplyDTO);
            }
        } else if (listSet.size() == 1) {
            ArrayList rowDTOArrayList = (ArrayList)listSet.iterator().next();
            if (rowDTOArrayList.size() > 1) {
                ApplyElementDTO applyElementDTO = new ApplyElementDTO();
                applyElementDTO.setFunctionId(PolicyEditorUtil.processFunction("and"));
                for (RowDTO rowDTO : rowDTOArrayList) {
                    ApplyElementDTO applyElementDTO2 = PolicyEditorUtil.createApplyElement(rowDTO);
                    applyElementDTO.setApplyElement(applyElementDTO2);
                }
            } else if (rowDTOArrayList.size() == 1) {
                RowDTO rowDTO = (RowDTO)rowDTOArrayList.get(0);
                ApplyElementDTO andApplyDTO = PolicyEditorUtil.createApplyElement(rowDTO);
                rootApplyDTO.setApplyElement(andApplyDTO);
            }
        }
        for (RowDTO rowDTO : rowDTOs) {
            if (rowDTO.getFunction().contains("<") || rowDTO.getFunction().contains(">")) {
                PolicyEditorUtil.processGreaterLessThanFunctions(rowDTO);
                continue;
            }
            if (!rowDTO.getFunction().equals("=")) continue;
            PolicyEditorUtil.processEqualFunctions(rowDTO);
        }
        return rootApplyDTO;
    }

    public static ApplyElementDTO createApplyElement(RowDTO rowDTO) throws PolicyEditorException {
        ApplyElementDTO applyElementDTO;
        if (rowDTO.getFunction().contains("<") || rowDTO.getFunction().contains(">")) {
            applyElementDTO = PolicyEditorUtil.processGreaterLessThanFunctions(rowDTO);
        } else if (rowDTO.getFunction().equals("=")) {
            applyElementDTO = PolicyEditorUtil.processEqualFunctions(rowDTO);
        } else {
            throw new PolicyEditorException("");
        }
        return applyElementDTO;
    }

    public static NewTargetElementDTO createTargetDTO(TargetDTO targetDTO) {
        AllOfElementDTO allOfElementDTO = new AllOfElementDTO();
        AnyOfElementDTO anyOfElementDTO = new AnyOfElementDTO();
        NewTargetElementDTO targetElementDTO = new NewTargetElementDTO();
        ArrayList<RowDTO> rowDTOs = targetDTO.getRowDTOList();
        ArrayList<RowDTO> tempRowDTOs = new ArrayList<RowDTO>();
        for (RowDTO rowDTO : rowDTOs) {
            if ("are".equals(rowDTO.getPreFunction())) {
                String[] attributeValues = rowDTO.getAttributeValue().split(",");
                allOfElementDTO = new AllOfElementDTO();
                for (int j = 0; j < attributeValues.length; ++j) {
                    RowDTO newDto = new RowDTO(rowDTO);
                    newDto.setAttributeValue(attributeValues[j]);
                    if (j != attributeValues.length - 1) {
                        newDto.setCombineFunction("AND");
                    }
                    tempRowDTOs.add(newDto);
                }
                continue;
            }
            tempRowDTOs.add(rowDTO);
        }
        for (int i = 0; i < tempRowDTOs.size(); ++i) {
            MatchElementDTO matchElementDTO;
            if (i == 0) {
                MatchElementDTO matchElementDTO2 = PolicyEditorUtil.createTargetMatch((RowDTO)tempRowDTOs.get(0));
                if (matchElementDTO2 == null) continue;
                allOfElementDTO.addMatchElementDTO(matchElementDTO2);
                continue;
            }
            String combineFunction = ((RowDTO)tempRowDTOs.get(i - 1)).getCombineFunction();
            if ("AND".equals(combineFunction) && (matchElementDTO = PolicyEditorUtil.createTargetMatch((RowDTO)tempRowDTOs.get(i))) != null) {
                allOfElementDTO.addMatchElementDTO(matchElementDTO);
            }
            if (!"OR".equals(combineFunction)) continue;
            anyOfElementDTO.addAllOfElementDTO(allOfElementDTO);
            allOfElementDTO = new AllOfElementDTO();
            matchElementDTO = PolicyEditorUtil.createTargetMatch((RowDTO)tempRowDTOs.get(i));
            if (matchElementDTO == null) continue;
            allOfElementDTO.addMatchElementDTO(matchElementDTO);
        }
        anyOfElementDTO.addAllOfElementDTO(allOfElementDTO);
        targetElementDTO.addAnyOfElementDTO(anyOfElementDTO);
        return targetElementDTO;
    }

    public static Element createTargetElement(NewTargetElementDTO targetDTO, Document doc) {
        Element targetElement = doc.createElement("Target");
        List<AnyOfElementDTO> anyOfElementDTOs = targetDTO.getAnyOfElementDTOs();
        for (AnyOfElementDTO anyOfElementDTO : anyOfElementDTOs) {
            Element anyOfElement = doc.createElement("AnyOf");
            List<AllOfElementDTO> allOfElementDTOs = anyOfElementDTO.getAllOfElementDTOs();
            for (AllOfElementDTO allOfElementDTO : allOfElementDTOs) {
                Element allOfElement = doc.createElement("AllOf");
                List<MatchElementDTO> matchElementDTOs = allOfElementDTO.getMatchElementDTOs();
                for (MatchElementDTO matchElementDTO : matchElementDTOs) {
                    Element matchElement = PolicyCreatorUtil.createMatchElement(matchElementDTO, doc);
                    allOfElement.appendChild(matchElement);
                }
                anyOfElement.appendChild(allOfElement);
            }
            targetElement.appendChild(anyOfElement);
        }
        return targetElement;
    }

    public static Element processArithmeticFunctions(RowDTO rowDTO) throws PolicyEditorException {
        return null;
    }

    public static ApplyElementDTO processEqualFunctions(RowDTO rowDTO) {
        return null;
    }

    public static ApplyElementDTO processGreaterLessThanFunctions(RowDTO rowDTO) throws PolicyEditorException {
        String function = rowDTO.getFunction();
        String dataType = rowDTO.getAttributeDataType();
        String attributeValue = rowDTO.getAttributeValue();
        String[] values = attributeValue.split(",");
        if (values.length != 2) {
            throw new PolicyEditorException("Can not create Apply element: Required Attribute value is missing");
        }
        String leftValue = values[0];
        String rightValue = values[1];
        AttributeDesignatorDTO designatorDTO = new AttributeDesignatorDTO();
        designatorDTO.setCategory(rowDTO.getCategory());
        designatorDTO.setAttributeId(rowDTO.getAttributeId());
        designatorDTO.setDataType(dataType);
        designatorDTO.setMustBePresent("true");
        if (function == null) {
            throw new PolicyEditorException("Can not create Apply element: Required Function Id is missing");
        }
        if ("greater-than-or-equal-and-less-than-or-equal".equals(function)) {
            ApplyElementDTO andApplyElement = new ApplyElementDTO();
            andApplyElement.setFunctionId(PolicyEditorUtil.processFunction("and", dataType));
            ApplyElementDTO greaterThanApplyElement = new ApplyElementDTO();
            greaterThanApplyElement.setFunctionId(PolicyEditorUtil.processFunction("greater-than-or-equal", dataType));
            ApplyElementDTO lessThanApplyElement = new ApplyElementDTO();
            lessThanApplyElement.setFunctionId(PolicyEditorUtil.processFunction("less-than-or-equal", dataType));
            ApplyElementDTO oneAndOnlyApplyElement = new ApplyElementDTO();
            oneAndOnlyApplyElement.setFunctionId(PolicyEditorUtil.processFunction("one-and-only", dataType));
            oneAndOnlyApplyElement.setAttributeDesignators(designatorDTO);
            AttributeValueElementDTO leftValueElementDTO = new AttributeValueElementDTO();
            leftValueElementDTO.setAttributeDataType(dataType);
            leftValueElementDTO.setAttributeValue(leftValue);
            AttributeValueElementDTO rightValueElementDTO = new AttributeValueElementDTO();
            rightValueElementDTO.setAttributeDataType(dataType);
            rightValueElementDTO.setAttributeValue(rightValue);
            greaterThanApplyElement.setApplyElement(oneAndOnlyApplyElement);
            greaterThanApplyElement.setAttributeValueElementDTO(leftValueElementDTO);
            lessThanApplyElement.setApplyElement(oneAndOnlyApplyElement);
            lessThanApplyElement.setAttributeValueElementDTO(rightValueElementDTO);
            andApplyElement.setApplyElement(greaterThanApplyElement);
            andApplyElement.setApplyElement(lessThanApplyElement);
            return andApplyElement;
        }
        return null;
    }

    private static String processFunction(String function, String type, int version) {
        return "urn:oasis:names:tc:xacml:" + version + ":function:" + PolicyEditorUtil.getDataTypePrefix(type) + "-" + function;
    }

    private static String processFunction(String function) {
        return "urn:oasis:names:tc:xacml:1.0:function:" + function;
    }

    private static String processFunction(String function, String type) {
        return "urn:oasis:names:tc:xacml:1.0:function:" + PolicyEditorUtil.getDataTypePrefix(type) + "-" + function;
    }

    private static String getDataTypePrefix(String dataTypeUri) {
        if (dataTypeUri != null) {
            String[] stringArray;
            if (dataTypeUri.contains("#")) {
                return dataTypeUri.substring(dataTypeUri.indexOf("#") + 1);
            }
            if (dataTypeUri.contains(":") && (stringArray = dataTypeUri.split(":")) != null && stringArray.length > 0) {
                return stringArray[stringArray.length];
            }
        }
        return dataTypeUri;
    }

    public static MatchElementDTO createTargetMatch(RowDTO rowDTO) {
        String category = rowDTO.getCategory();
        String functionId = rowDTO.getFunction();
        String attributeValue = rowDTO.getAttributeValue();
        String attributeId = rowDTO.getAttributeId();
        String dataType = rowDTO.getAttributeDataType();
        if (functionId == null || functionId.trim().length() <= 0 || attributeValue == null || attributeValue.trim().length() <= 0 || category == null || category.trim().length() <= 0 || attributeId == null || attributeId.trim().length() <= 0 || dataType == null || dataType.trim().length() <= 0) {
            return null;
        }
        functionId = PolicyEditorUtil.processFunction(functionId, dataType);
        MatchElementDTO matchElementDTO = new MatchElementDTO();
        AttributeValueElementDTO attributeValueElementDTO = new AttributeValueElementDTO();
        attributeValueElementDTO.setAttributeDataType(dataType);
        attributeValueElementDTO.setAttributeValue(attributeValue.trim());
        AttributeDesignatorDTO attributeDesignatorDTO = new AttributeDesignatorDTO();
        attributeDesignatorDTO.setDataType(dataType);
        attributeDesignatorDTO.setAttributeId(attributeId);
        attributeDesignatorDTO.setElementName(category);
        matchElementDTO.setMatchElementName(category);
        matchElementDTO.setMatchId(functionId);
        matchElementDTO.setAttributeValueElementDTO(attributeValueElementDTO);
        matchElementDTO.setAttributeDesignatorDTO(attributeDesignatorDTO);
        return matchElementDTO;
    }

    public static Element createMatchElement(MatchElementDTO matchElementDTO, Document doc) throws PolicyEditorException {
        Element matchElement;
        if (matchElementDTO.getMatchId() != null && matchElementDTO.getMatchId().trim().length() > 0) {
            matchElement = doc.createElement("Match");
            matchElement.setAttribute("MatchId", matchElementDTO.getMatchId());
            if (matchElementDTO.getAttributeValueElementDTO() != null) {
                Element attributeValueElement = PolicyEditorUtil.createAttributeValueElement(matchElementDTO.getAttributeValueElementDTO(), doc);
                matchElement.appendChild(attributeValueElement);
            }
            if (matchElementDTO.getAttributeDesignatorDTO() != null) {
                Element attributeDesignatorElement = PolicyEditorUtil.createAttributeDesignatorElement(matchElementDTO.getAttributeDesignatorDTO(), doc);
                matchElement.appendChild(attributeDesignatorElement);
            } else if (matchElementDTO.getAttributeSelectorDTO() != null) {
                Element attributeSelectorElement = PolicyEditorUtil.createAttributeSelectorElement(matchElementDTO.getAttributeSelectorDTO(), doc);
                matchElement.appendChild(attributeSelectorElement);
            }
        } else {
            throw new PolicyEditorException("Can not create Match element: Required Attributes are missing");
        }
        return matchElement;
    }

    public static Element createAttributeValueElement(AttributeValueElementDTO attributeValueElementDTO, Document doc) {
        Element attributeValueElement = doc.createElement("AttributeValue");
        if (attributeValueElementDTO.getAttributeValue() != null && attributeValueElementDTO.getAttributeValue().trim().length() > 0) {
            attributeValueElement.setTextContent(attributeValueElementDTO.getAttributeValue().trim());
            if (attributeValueElementDTO.getAttributeDataType() != null && attributeValueElementDTO.getAttributeDataType().trim().length() > 0) {
                attributeValueElement.setAttribute("DataType", attributeValueElementDTO.getAttributeDataType());
            } else {
                attributeValueElement.setAttribute("DataType", "http://www.w3.org/2001/XMLSchema#string");
            }
        }
        return attributeValueElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Element createAttributeDesignatorElement(AttributeDesignatorDTO attributeDesignatorDTO, Document doc) throws PolicyEditorException {
        if (attributeDesignatorDTO == null || doc == null) throw new PolicyEditorException("Can not create AttributeDesignator element: A Null object is received");
        String category = attributeDesignatorDTO.getCategory();
        String attributeId = attributeDesignatorDTO.getAttributeId();
        String dataType = attributeDesignatorDTO.getDataType();
        String mustBe = attributeDesignatorDTO.getMustBePresent();
        if (category == null || category.trim().length() <= 0 || attributeId == null || attributeId.trim().length() <= 0 || dataType == null || dataType.trim().length() <= 0 || mustBe == null || mustBe.trim().length() <= 0) throw new PolicyEditorException("Can not create AttributeDesignator element: Required Attributes are missing");
        Element attributeDesignatorElement = doc.createElement("AttributeDesignator");
        attributeDesignatorElement.setAttribute("AttributeId", attributeId);
        attributeDesignatorElement.setAttribute("Category", category);
        attributeDesignatorElement.setAttribute("DataType", dataType);
        attributeDesignatorElement.setAttribute("MustBePresent", mustBe);
        if (attributeDesignatorDTO.getIssuer() == null || attributeDesignatorDTO.getIssuer().trim().length() <= 0) return attributeDesignatorElement;
        attributeDesignatorElement.setAttribute("Issuer", attributeDesignatorDTO.getIssuer());
        return attributeDesignatorElement;
    }

    public static Element createAttributeSelectorElement(AttributeSelectorDTO attributeSelectorDTO, Document doc) {
        Element attributeSelectorElement = doc.createElement("AttributeSelector");
        if (attributeSelectorDTO.getAttributeSelectorRequestContextPath() != null && attributeSelectorDTO.getAttributeSelectorRequestContextPath().trim().length() > 0) {
            attributeSelectorElement.setAttribute("RequestContextPath", "urn:oasis:names:tc:xacml:2.0:example:attribute:" + attributeSelectorDTO.getAttributeSelectorRequestContextPath());
            if (attributeSelectorDTO.getAttributeSelectorDataType() != null && attributeSelectorDTO.getAttributeSelectorDataType().trim().length() > 0) {
                attributeSelectorElement.setAttribute("DataType", attributeSelectorDTO.getAttributeSelectorDataType());
            } else {
                attributeSelectorElement.setAttribute("DataType", "http://www.w3.org/2001/XMLSchema#string");
            }
            if (attributeSelectorDTO.getAttributeSelectorMustBePresent() != null && attributeSelectorDTO.getAttributeSelectorMustBePresent().trim().length() > 0) {
                attributeSelectorElement.setAttribute("MustBePresent", attributeSelectorDTO.getAttributeSelectorMustBePresent());
            }
        }
        return attributeSelectorElement;
    }
}

