/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.thrift.authentication;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.services.util.CarbonAuthenticationUtil;
import org.wso2.carbon.identity.authentication.AuthenticationService;
import org.wso2.carbon.identity.thrift.authentication.AuthenticationException;
import org.wso2.carbon.identity.thrift.authentication.ThriftAuthenticatorService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ThriftSession;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class ThriftAuthenticatorServiceImpl
extends AbstractAdmin
implements ThriftAuthenticatorService {
    private static final Log log = LogFactory.getLog(ThriftAuthenticatorServiceImpl.class);
    private static ThriftAuthenticatorServiceImpl instance = new ThriftAuthenticatorServiceImpl();
    private static long thriftSessionTimeOut = 60000L;
    private AuthenticationService authenticationService;
    private RealmService realmService;
    private Map<String, ThriftSession> authenticatedSessions = new ConcurrentHashMap<String, ThriftSession>();

    private ThriftAuthenticatorServiceImpl() {
    }

    public static ThriftAuthenticatorServiceImpl getInstance() {
        return instance;
    }

    public void init(AuthenticationService authenticationService, RealmService realmService) {
        this.authenticationService = authenticationService;
        this.realmService = realmService;
    }

    @Override
    public String authenticate(String userName, String password) throws AuthenticationException {
        boolean isSuccessful;
        String domainName;
        if (userName == null) {
            this.logAndAuthenticationException("Authentication request was missing the user name ");
        }
        if (userName.indexOf("@") > 0 && ((domainName = userName.substring(userName.indexOf("@") + 1)) == null || domainName.trim().equals(""))) {
            this.logAndAuthenticationException("Authentication request was missing the domain name of the user");
        }
        if (password == null) {
            this.logAndAuthenticationException("Authentication request was missing the required password");
        }
        if (isSuccessful = this.authenticationService.authenticate(userName, password)) {
            for (Map.Entry<String, ThriftSession> thriftSessionEntry : this.authenticatedSessions.entrySet()) {
                if (!userName.equals(thriftSessionEntry.getValue().getUserName()) || !password.equals(thriftSessionEntry.getValue().getPassword())) continue;
                String existingId = thriftSessionEntry.getKey();
                if (this.isSessionValid(existingId)) {
                    this.authenticatedSessions.get(existingId).setLastAccess(System.currentTimeMillis());
                    return thriftSessionEntry.getKey();
                }
                this.authenticatedSessions.remove(existingId);
            }
            String sessionId = null;
            ThriftSession session = null;
            try {
                sessionId = UUID.randomUUID().toString();
                session = new ThriftSession();
                session.setSessionId(sessionId);
                session.setUserName(userName);
                session.setPassword(password);
                session.setCreatedAt(System.currentTimeMillis());
                session.setLastAccess(System.currentTimeMillis());
                if (this.realmService == null) {
                    String errorMsg = "Realm service not properly set..";
                    log.error((Object)errorMsg);
                    throw new AuthenticationException(errorMsg);
                }
                String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
                int tenantId = this.realmService.getTenantManager().getTenantId(tenantDomain);
                CarbonAuthenticationUtil.onSuccessAdminLogin((ThriftSession)session, (String)userName, (int)tenantId, (String)tenantDomain, (String)"");
                this.authenticatedSessions.put(sessionId, session);
            }
            catch (Exception e) {
                String errorMsg = "Error occured while authenticating the user: " + userName;
                log.error((Object)errorMsg, (Throwable)e);
                throw new AuthenticationException(errorMsg);
            }
            return sessionId;
        }
        return null;
    }

    @Override
    public boolean isAuthenticated(String sessionId) {
        if (sessionId == null) {
            return false;
        }
        if (this.authenticatedSessions.containsKey(sessionId)) {
            if (this.isSessionValid(sessionId)) {
                this.authenticatedSessions.get(sessionId).setLastAccess(System.currentTimeMillis());
                return true;
            }
            this.authenticatedSessions.remove(sessionId);
            return false;
        }
        return false;
    }

    @Override
    public ThriftSession getSessionInfo(String sessionId) {
        return this.authenticatedSessions.get(sessionId);
    }

    private void logAndAuthenticationException(String msg) throws AuthenticationException {
        log.error((Object)msg);
        throw new AuthenticationException(msg);
    }

    private boolean isSessionValid(String sessionId) {
        if (this.authenticatedSessions.containsKey(sessionId)) {
            ThriftSession authSession = this.authenticatedSessions.get(sessionId);
            return System.currentTimeMillis() - authSession.getLastAccess() < thriftSessionTimeOut;
        }
        return false;
    }
}

