/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml3.ctx;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.Attribute;
import org.wso2.balana.MultipleCtxResult;
import org.wso2.balana.PDPConfig;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.BagAttribute;
import org.wso2.balana.attr.StringAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.ctx.AbstractRequestCtx;
import org.wso2.balana.ctx.BasicEvaluationCtx;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.finder.ResourceFinderResult;
import org.wso2.balana.xacml3.Attributes;
import org.wso2.balana.xacml3.AttributesReference;
import org.wso2.balana.xacml3.MultiRequests;
import org.wso2.balana.xacml3.RequestReference;
import org.wso2.balana.xacml3.ctx.RequestCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XACML3EvaluationCtx
extends BasicEvaluationCtx {
    private Set<Attributes> attributesSet;
    private boolean multipleAttributes;
    private Map<String, Set<Attributes>> mapAttributes;
    private RequestCtx requestCtx;
    private int resourceScope;
    private AttributeValue resourceId;
    private static Log logger = LogFactory.getLog(XACML3EvaluationCtx.class);

    public XACML3EvaluationCtx(RequestCtx requestCtx, PDPConfig pdpConfig) {
        this.currentDate = null;
        this.currentTime = null;
        this.currentDateTime = null;
        this.mapAttributes = new HashMap<String, Set<Attributes>>();
        this.attributesSet = requestCtx.getAttributesSet();
        this.pdpConfig = pdpConfig;
        this.requestCtx = requestCtx;
        this.setupAttributes(this.attributesSet, this.mapAttributes);
    }

    @Override
    public EvaluationResult getAttribute(URI type, URI id, String issuer, URI category) {
        ArrayList<AttributeValue> attributeValues = new ArrayList<AttributeValue>();
        Set<Attributes> attributesSet = this.mapAttributes.get(category.toString());
        if (attributesSet != null && attributesSet.size() > 0) {
            Set<Attribute> attributeSet = attributesSet.iterator().next().getAttributes();
            for (Attribute attribute : attributeSet) {
                if (!attribute.getId().equals(id) || !attribute.getType().equals(type) || issuer != null && !issuer.equals(attribute.getIssuer()) || attribute.getValue() == null) continue;
                attributeValues.add(attribute.getValue());
            }
            if (attributeValues.size() < 1) {
                return this.callHelper(type, id, issuer, category);
            }
        }
        return new EvaluationResult(new BagAttribute(type, attributeValues));
    }

    @Override
    public int getXacmlVersion() {
        return this.requestCtx.getXacmlVersion();
    }

    private void setupAttributes(Set<Attributes> attributeSet, Map<String, Set<Attributes>> mapAttributes) {
        for (Attributes attributes : attributeSet) {
            Set<Object> set;
            String category = attributes.getCategory().toString();
            if ("urn:oasis:names:tc:xacml:3.0:attribute-category:resource".equals(category)) {
                for (Attribute attribute : attributes.getAttributes()) {
                    if ("urn:oasis:names:tc:xacml:2.0:resource:scope".equals(attribute.getId().toString())) {
                        AttributeValue value = attribute.getValue();
                        if (value instanceof StringAttribute) {
                            String scope = ((StringAttribute)value).getValue();
                            if (scope.equals("Children")) {
                                this.resourceScope = 1;
                                break;
                            }
                            if (!scope.equals("Descendants")) break;
                            this.resourceScope = 2;
                            break;
                        }
                        logger.error((Object)"scope attribute must be a string");
                        break;
                    }
                    if (!"urn:oasis:names:tc:xacml:1.0:resource:resource-id".equals(attribute.getId().toString()) || this.resourceId != null) continue;
                    this.resourceId = attribute.getValue();
                }
            }
            if (mapAttributes.containsKey(category)) {
                set = mapAttributes.get(category);
                set.add(attributes);
                this.multipleAttributes = true;
                continue;
            }
            set = new HashSet();
            set.add(attributes);
            mapAttributes.put(category, set);
        }
    }

    @Override
    public MultipleCtxResult getMultipleEvaluationCtx() {
        MultipleCtxResult result;
        HashSet newSet;
        MultipleCtxResult result2;
        HashSet<EvaluationCtx> evaluationCtxSet = new HashSet<EvaluationCtx>();
        MultiRequests multiRequests = this.requestCtx.getMultiRequests();
        if (multiRequests != null) {
            result2 = this.processMultiRequestElement(this);
            if (result2.isIndeterminate()) {
                return result2;
            }
            evaluationCtxSet.addAll(result2.getEvaluationCtxSet());
        }
        if (evaluationCtxSet.size() > 0) {
            newSet = new HashSet(evaluationCtxSet);
            for (EvaluationCtx evaluationCtx : newSet) {
                if (!this.multipleAttributes) continue;
                evaluationCtxSet.remove(evaluationCtx);
                result = this.processMultipleAttributes((XACML3EvaluationCtx)evaluationCtx);
                if (result.isIndeterminate()) {
                    return result;
                }
                evaluationCtxSet.addAll(result.getEvaluationCtxSet());
            }
        } else if (this.multipleAttributes) {
            result2 = this.processMultipleAttributes(this);
            if (result2.isIndeterminate()) {
                return result2;
            }
            evaluationCtxSet.addAll(result2.getEvaluationCtxSet());
        }
        if (evaluationCtxSet.size() > 0) {
            newSet = new HashSet(evaluationCtxSet);
            for (EvaluationCtx evaluationCtx : newSet) {
                if (this.resourceScope == 0) continue;
                evaluationCtxSet.remove(evaluationCtx);
                result = this.processHierarchicalAttributes((XACML3EvaluationCtx)evaluationCtx);
                if (result.isIndeterminate()) {
                    return result;
                }
                evaluationCtxSet.addAll(result.getEvaluationCtxSet());
            }
        } else if (this.resourceScope != 0) {
            result2 = this.processHierarchicalAttributes(this);
            if (result2.isIndeterminate()) {
                return result2;
            }
            evaluationCtxSet.addAll(result2.getEvaluationCtxSet());
        }
        if (evaluationCtxSet.size() > 0) {
            return new MultipleCtxResult(evaluationCtxSet, null, false);
        }
        evaluationCtxSet.add(this);
        return new MultipleCtxResult(evaluationCtxSet, null, false);
    }

    private MultipleCtxResult processMultiRequestElement(XACML3EvaluationCtx evaluationCtx) {
        HashSet<EvaluationCtx> children = new HashSet<EvaluationCtx>();
        MultiRequests multiRequests = this.requestCtx.getMultiRequests();
        if (multiRequests != null) {
            Set<RequestReference> requestReferences = multiRequests.getRequestReferences();
            for (RequestReference reference : requestReferences) {
                Set<AttributesReference> attributesReferences = reference.getReferences();
                if (attributesReferences == null || attributesReferences.size() <= 0) continue;
                HashSet<Attributes> attributes = new HashSet<Attributes>();
                for (AttributesReference attributesReference : attributesReferences) {
                    String referenceId = attributesReference.getId();
                    if (referenceId != null) {
                        for (Attributes attribute : evaluationCtx.getRequestCtx().getAttributesSet()) {
                            if (attribute.getId() == null || !attribute.getId().equals(referenceId)) continue;
                            attributes.add(attribute);
                        }
                    }
                    RequestCtx ctx = new RequestCtx(attributes, null);
                    children.add(new XACML3EvaluationCtx(ctx, this.pdpConfig));
                }
            }
        }
        return new MultipleCtxResult(children, null, false);
    }

    private MultipleCtxResult processMultipleAttributes(XACML3EvaluationCtx evaluationCtx) {
        HashSet<EvaluationCtx> children = new HashSet<EvaluationCtx>();
        HashSet<RequestCtx> newRequestCtxSet = new HashSet<RequestCtx>();
        for (Map.Entry<String, Set<Attributes>> mapAttributesEntry : this.mapAttributes.entrySet()) {
            if (mapAttributesEntry.getValue().size() <= 1) continue;
            for (Attributes attributesElement : mapAttributesEntry.getValue()) {
                HashSet<Attributes> newSet = new HashSet<Attributes>(this.attributesSet);
                newSet.removeAll((Collection)mapAttributesEntry.getValue());
                newSet.add(attributesElement);
                RequestCtx newRequestCtx = new RequestCtx(newSet, null);
                newRequestCtxSet.add(newRequestCtx);
            }
        }
        for (RequestCtx ctx : newRequestCtxSet) {
            children.add(new XACML3EvaluationCtx(ctx, this.pdpConfig));
        }
        return new MultipleCtxResult(children, null, false);
    }

    private MultipleCtxResult processHierarchicalAttributes(XACML3EvaluationCtx evaluationCtx) {
        ResourceFinderResult resourceResult = null;
        HashSet<EvaluationCtx> children = new HashSet<EvaluationCtx>();
        if (this.resourceId != null) {
            if (this.resourceScope == 1) {
                resourceResult = this.pdpConfig.getResourceFinder().findChildResources(this.resourceId, evaluationCtx);
            } else if (this.resourceScope == 2) {
                resourceResult = this.pdpConfig.getResourceFinder().findDescendantResources(this.resourceId, evaluationCtx);
            } else {
                logger.error((Object)"Unknown scope type: ");
            }
        } else {
            logger.error((Object)"ResourceId Attribute is NULL: ");
        }
        if (resourceResult == null || resourceResult.isEmpty()) {
            logger.error((Object)"Resource Finder result is NULL: ");
        } else {
            for (AttributeValue resource : resourceResult.getResources()) {
                evaluationCtx.setResourceId(resource, this.attributesSet);
                children.add(new XACML3EvaluationCtx(new RequestCtx(this.attributesSet, null), this.pdpConfig));
            }
        }
        return new MultipleCtxResult(children, null, false);
    }

    public void setResourceId(AttributeValue resourceId, Set<Attributes> attributesSet) {
        for (Attributes attributes : attributesSet) {
            if (!"urn:oasis:names:tc:xacml:3.0:attribute-category:resource".equals(attributes.getCategory().toString())) continue;
            Set<Attribute> attributeSet = attributes.getAttributes();
            HashSet<Attribute> newSet = new HashSet<Attribute>(attributeSet);
            Attribute resourceIdAttribute = null;
            for (Attribute attribute : newSet) {
                if ("urn:oasis:names:tc:xacml:1.0:resource:resource-id".equals(attribute.getId().toString())) {
                    resourceIdAttribute = attribute;
                    attributeSet.remove(attribute);
                    continue;
                }
                if (!"urn:oasis:names:tc:xacml:2.0:resource:scope".equals(attribute.getId().toString())) continue;
                attributeSet.remove(attribute);
            }
            if (resourceIdAttribute == null) break;
            attributeSet.add(new Attribute(resourceIdAttribute.getId(), resourceIdAttribute.getIssuer(), resourceIdAttribute.getIssueInstant(), resourceId, resourceIdAttribute.isIncludeInResult()));
            break;
        }
    }

    public boolean isMultipleAttributes() {
        return this.multipleAttributes;
    }

    @Override
    public AbstractRequestCtx getRequestCtx() {
        return this.requestCtx;
    }
}

