/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml3;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.Indenter;
import org.wso2.balana.ObligationResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.xacml3.Obligation;
import org.wso2.balana.xacml3.advice.Advice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result
extends AbstractResult {
    public Result(int decision, Status status, Set<ObligationResult> obligationResults, Set<Advice> advices, EvaluationCtx evaluationCtx) throws IllegalArgumentException {
        super(decision, status, obligationResults, advices, evaluationCtx);
    }

    public Result(int decision, Status status, Set<ObligationResult> obligationResults, Set<Advice> advices) throws IllegalArgumentException {
        super(decision, status, obligationResults, advices, null);
    }

    public static AbstractResult getInstance(Node root) throws ParsingException {
        int decision = -1;
        Status status = null;
        Set obligations = null;
        Set advices = null;
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("Decision")) {
                String type = node.getFirstChild().getNodeValue();
                for (int j = 0; j < DECISIONS.length; ++j) {
                    if (!DECISIONS[j].equals(type)) continue;
                    decision = j;
                    break;
                }
                if (decision != -1) continue;
                throw new ParsingException("Unknown Decision: " + type);
            }
            if (name.equals("Status")) {
                status = Status.getInstance(node);
                continue;
            }
            if (name.equals("Obligations")) {
                obligations = Result.parseObligations(node);
                continue;
            }
            if (!name.equals("Obligations")) continue;
            advices = Result.parseAdvices(node);
        }
        return new Result(decision, status, obligations, advices);
    }

    private static Set parseObligations(Node root) throws ParsingException {
        HashSet<Obligation> set = new HashSet<Obligation>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("Obligation")) continue;
            set.add(Obligation.getInstance(node));
        }
        if (set.size() == 0) {
            throw new ParsingException("ObligationsType must not be empty");
        }
        return set;
    }

    private static Set parseAdvices(Node root) throws ParsingException {
        HashSet set = new HashSet();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("Advices")) continue;
        }
        if (set.size() == 0) {
            throw new ParsingException("ObligationsType must not be empty");
        }
        return set;
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        indenter.in();
        String indentNext = indenter.makeString();
        out.println(indent + "<Result>");
        out.println(indentNext + "<Decision>" + DECISIONS[this.decision] + "</Decision>");
        if (this.status != null) {
            this.status.encode(output, indenter);
        }
        if (this.obligations != null && this.obligations.size() != 0) {
            out.println(indentNext + "<Obligations>");
            Iterator it = this.obligations.iterator();
            indenter.in();
            while (it.hasNext()) {
                Obligation obligation = (Obligation)it.next();
                obligation.encode(output, indenter);
            }
            indenter.out();
            out.println(indentNext + "</Obligations>");
        }
        indenter.out();
        out.println(indent + "</Result>");
    }
}

