/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml3;

import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.ParsingException;
import org.wso2.balana.xacml3.AttributesReference;
import org.wso2.balana.xacml3.RequestReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiRequests {
    private Set<RequestReference> requestReferences;

    private MultiRequests(Set<RequestReference> requestReferences) {
        this.requestReferences = requestReferences;
    }

    public static MultiRequests getInstance(Node root) throws ParsingException {
        HashSet<RequestReference> requestReferences = new HashSet<RequestReference>();
        if (!root.getNodeName().equals("MultiRequests")) {
            throw new ParsingException("MultiRequests object cannot be created with root node of type: " + root.getNodeName());
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!"RequestReference".equals(node.getNodeName())) continue;
            HashSet<AttributesReference> attributesReferences = new HashSet<AttributesReference>();
            RequestReference requestReference = new RequestReference();
            NodeList childNodes = node.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node childNode = childNodes.item(i);
                if (!"AttributesReference".equals(childNode.getNodeName())) continue;
                AttributesReference attributesReference = new AttributesReference();
                attributesReferences.add(attributesReference);
                NamedNodeMap nodeAttributes = root.getAttributes();
                try {
                    String referenceId = nodeAttributes.getNamedItem("ReferenceId").getNodeValue();
                    attributesReference.setId(referenceId);
                    continue;
                }
                catch (Exception e) {
                    throw new ParsingException("Error parsing required ReferenceId in MultiRequestsType", e);
                }
            }
            if (attributesReferences.isEmpty()) {
                throw new ParsingException("RequestReference must contain at least one AttributesReference");
            }
            requestReference.setReferences(attributesReferences);
            requestReferences.add(requestReference);
        }
        if (requestReferences.isEmpty()) {
            throw new ParsingException("MultiRequests must contain at least one RequestReference");
        }
        return new MultiRequests(requestReferences);
    }

    public Set<RequestReference> getRequestReferences() {
        return this.requestReferences;
    }
}

