/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml2;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.Indenter;
import org.wso2.balana.MatchResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.TargetMatch;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.xacml2.TargetMatchGroup;

public class TargetSection {
    private List matchGroups;
    private int matchType;
    private int xacmlVersion;

    public TargetSection(List matchGroups, int matchType, int xacmlVersion) {
        this.matchGroups = matchGroups == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(new ArrayList(matchGroups));
        this.matchType = matchType;
        this.xacmlVersion = xacmlVersion;
    }

    public static TargetSection getInstance(Node root, int matchType, PolicyMetaData metaData) throws ParsingException {
        ArrayList<TargetMatchGroup> groups = new ArrayList<TargetMatchGroup>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String typeName;
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals(typeName = TargetMatch.NAMES[matchType])) {
                groups.add(TargetMatchGroup.getInstance(child, matchType, metaData));
                continue;
            }
            if (name.equals("Any" + typeName)) break;
        }
        return new TargetSection(groups, matchType, metaData.getXACMLVersion());
    }

    public List getMatchGroups() {
        return this.matchGroups;
    }

    public boolean matchesAny() {
        return this.matchGroups.isEmpty();
    }

    public MatchResult match(EvaluationCtx context) {
        if (this.matchGroups.isEmpty()) {
            return new MatchResult(0);
        }
        Iterator it = this.matchGroups.iterator();
        Status firstIndeterminateStatus = null;
        while (it.hasNext()) {
            TargetMatchGroup group = (TargetMatchGroup)it.next();
            MatchResult result = group.match(context);
            if (result.getResult() == 0) {
                return result;
            }
            if (result.getResult() != 2 || firstIndeterminateStatus != null) continue;
            firstIndeterminateStatus = result.getStatus();
        }
        if (firstIndeterminateStatus == null) {
            return new MatchResult(1);
        }
        return new MatchResult(2, firstIndeterminateStatus);
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        String name = TargetMatch.NAMES[this.matchType];
        if (this.matchGroups.isEmpty()) {
            if (this.xacmlVersion == 0) {
                out.println(indent + "<" + name + "s>");
                indenter.in();
                out.println(indenter.makeString() + "<Any" + name + "/>");
                indenter.out();
                out.println(indent + "</" + name + "s>");
            }
        } else {
            out.println(indent + "<" + name + "s>");
            Iterator it = this.matchGroups.iterator();
            indenter.in();
            while (it.hasNext()) {
                TargetMatchGroup group = (TargetMatchGroup)it.next();
                group.encode(output, indenter);
            }
            indenter.out();
            out.println(indent + "</" + name + "s>");
        }
    }
}

