/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.xacml2;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.AbstractTarget;
import org.wso2.balana.Indenter;
import org.wso2.balana.MatchResult;
import org.wso2.balana.ParsingException;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.ProcessingException;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.xacml2.TargetSection;

public class Target
extends AbstractTarget {
    private TargetSection subjectsSection;
    private TargetSection resourcesSection;
    private TargetSection actionsSection;
    private TargetSection environmentsSection;
    private int xacmlVersion;
    private static Log logger = LogFactory.getLog(Target.class);

    public Target(TargetSection subjectsSection, TargetSection resourcesSection, TargetSection actionsSection) {
        if (subjectsSection == null || resourcesSection == null || actionsSection == null) {
            throw new ProcessingException("All sections of a Target must be non-null");
        }
        this.subjectsSection = subjectsSection;
        this.resourcesSection = resourcesSection;
        this.actionsSection = actionsSection;
        this.environmentsSection = new TargetSection(null, 3, 0);
        this.xacmlVersion = 0;
    }

    public Target(TargetSection subjectsSection, TargetSection resourcesSection, TargetSection actionsSection, TargetSection environmentsSection) {
        if (subjectsSection == null || resourcesSection == null || actionsSection == null || environmentsSection == null) {
            throw new ProcessingException("All sections of a Target must be non-null");
        }
        this.subjectsSection = subjectsSection;
        this.resourcesSection = resourcesSection;
        this.actionsSection = actionsSection;
        this.environmentsSection = environmentsSection;
        this.xacmlVersion = 2;
    }

    public static Target getInstance(Node root, String xpathVersion) throws ParsingException {
        return Target.getInstance(root, new PolicyMetaData("urn:oasis:names:tc:xacml:1.0:policy", xpathVersion));
    }

    public static Target getInstance(Node root, PolicyMetaData metaData) throws ParsingException {
        TargetSection subjects = null;
        TargetSection resources = null;
        TargetSection actions = null;
        TargetSection environments = null;
        HashSet anyOfSet = new HashSet();
        int version = metaData.getXACMLVersion();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals("Subjects")) {
                subjects = TargetSection.getInstance(child, 0, metaData);
                continue;
            }
            if (name.equals("Resources")) {
                resources = TargetSection.getInstance(child, 1, metaData);
                continue;
            }
            if (name.equals("Actions")) {
                actions = TargetSection.getInstance(child, 2, metaData);
                continue;
            }
            if (!name.equals("Environments")) continue;
            environments = TargetSection.getInstance(child, 3, metaData);
        }
        if (subjects == null) {
            subjects = new TargetSection(null, 0, version);
        }
        if (resources == null) {
            resources = new TargetSection(null, 1, version);
        }
        if (actions == null) {
            actions = new TargetSection(null, 2, version);
        }
        if (version == 2) {
            if (environments == null) {
                environments = new TargetSection(null, 3, version);
            }
            return new Target(subjects, resources, actions, environments);
        }
        return new Target(subjects, resources, actions);
    }

    public TargetSection getSubjectsSection() {
        return this.subjectsSection;
    }

    public TargetSection getResourcesSection() {
        return this.resourcesSection;
    }

    public TargetSection getActionsSection() {
        return this.actionsSection;
    }

    public TargetSection getEnvironmentsSection() {
        return this.environmentsSection;
    }

    public boolean matchesAny() {
        return this.subjectsSection.matchesAny() && this.resourcesSection.matchesAny() && this.actionsSection.matchesAny() && this.environmentsSection.matchesAny();
    }

    public MatchResult match(EvaluationCtx context) {
        MatchResult result = null;
        if (this.matchesAny()) {
            return new MatchResult(0);
        }
        result = this.subjectsSection.match(context);
        if (result.getResult() != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"failed to match Subjects section of Target");
            }
            return result;
        }
        String subjectPolicyValue = result.getPolicyValue();
        result = this.resourcesSection.match(context);
        if (result.getResult() != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"failed to match Resources section of Target");
            }
            return result;
        }
        String resourcePolicyValue = result.getPolicyValue();
        result = this.actionsSection.match(context);
        if (result.getResult() != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"failed to match Actions section of Target");
            }
            return result;
        }
        String actionPolicyValue = result.getPolicyValue();
        result = this.environmentsSection.match(context);
        if (result.getResult() != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"failed to match Environments section of Target");
            }
            return result;
        }
        String envPolicyValue = result.getPolicyValue();
        result.setActionPolicyValue(actionPolicyValue);
        result.setSubjectPolicyValue(subjectPolicyValue);
        result.setEnvPolicyValue(envPolicyValue);
        result.setResourcePolicyValue(resourcePolicyValue);
        return result;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        boolean matchesAny;
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        boolean bl = matchesAny = this.subjectsSection.matchesAny() && this.resourcesSection.matchesAny() && this.actionsSection.matchesAny() && this.environmentsSection.matchesAny();
        if (matchesAny && this.xacmlVersion == 2) {
            out.println("<Target/>");
        } else {
            out.println(indent + "<Target>");
            indenter.in();
            this.subjectsSection.encode(output, indenter);
            this.resourcesSection.encode(output, indenter);
            this.actionsSection.encode(output, indenter);
            if (this.xacmlVersion == 2) {
                this.environmentsSection.encode(output, indenter);
            }
            indenter.out();
            out.println(indent + "</Target>");
        }
    }
}

