/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.finder;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.wso2.balana.attr.BagAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.finder.AttributeFinderModule;

public class AttributeFinder {
    private List allModules = new ArrayList();
    private List designatorModules = new ArrayList();
    private List selectorModules = new ArrayList();
    private static Log logger = LogFactory.getLog(AttributeFinder.class);

    public List getModules() {
        return new ArrayList(this.allModules);
    }

    public void setModules(List modules) {
        Iterator it = modules.iterator();
        this.allModules = new ArrayList(modules);
        this.designatorModules = new ArrayList();
        this.selectorModules = new ArrayList();
        while (it.hasNext()) {
            AttributeFinderModule module = (AttributeFinderModule)it.next();
            if (module.isDesignatorSupported()) {
                this.designatorModules.add(module);
            }
            if (!module.isSelectorSupported()) continue;
            this.selectorModules.add(module);
        }
    }

    public EvaluationResult findAttribute(URI attributeType, URI attributeId, String issuer, URI category, EvaluationCtx context) {
        for (AttributeFinderModule module : this.designatorModules) {
            EvaluationResult result = module.findAttribute(attributeType, attributeId, issuer, category, context);
            if (result.indeterminate()) {
                logger.info((Object)("Error while trying to resolve values: " + result.getStatus().getMessage()));
                return result;
            }
            BagAttribute bag = (BagAttribute)result.getAttributeValue();
            if (bag.isEmpty()) continue;
            return result;
        }
        logger.info((Object)("Failed to resolve any values for " + attributeId.toString()));
        return new EvaluationResult(BagAttribute.createEmptyBag(attributeType));
    }

    public EvaluationResult findAttribute(String contextPath, Node namespaceNode, URI attributeType, EvaluationCtx context, String xpathVersion) {
        for (AttributeFinderModule module : this.selectorModules) {
            EvaluationResult result = module.findAttribute(contextPath, namespaceNode, attributeType, context, xpathVersion);
            if (result.indeterminate()) {
                logger.info((Object)("Error while trying to resolve values: " + result.getStatus().getMessage()));
                return result;
            }
            BagAttribute bag = (BagAttribute)result.getAttributeValue();
            if (bag.isEmpty()) continue;
            return result;
        }
        logger.info((Object)("Failed to resolve any values for " + contextPath));
        return new EvaluationResult(BagAttribute.createEmptyBag(attributeType));
    }
}

